/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.definition;

import com.sap.sdb.syncMan.consumption.TableConsumptionSQLHandler;
import com.sap.sdb.syncMan.definition.ReplicationSchema;
import com.sap.sdb.syncMan.definition.ReplicationUnit;
import com.sap.sdb.syncMan.util.TableName;
import java.util.Enumeration;
import java.util.Hashtable;

public class ReplicationTable {
    private ReplicationSchema m_ownSchema;
    private ReplicationUnit m_ownUnit;
    private TableName m_table;
    private TableName m_version_table;
    private TableName m_shadow_table;
    private TableName m_audit_table;
    private Hashtable m_columnsById;
    private Hashtable m_keyColumnsById;
    private Hashtable m_columnTypesById;
    private Long[] m_keyIDs;
    private int[] m_keyTypes;
    private String[] m_keyNames;
    private Long[] m_nonKeyIDs;
    private int[] m_nonKeyTypes;
    private String[] m_nonKeyNames;
    private int m_col_count;
    private int m_key_count;
    private int m_non_key_count;
    private TableConsumptionSQLHandler m_conSqlHandler;

    public ReplicationTable(ReplicationUnit unit, String tableOwner, String tableName, String versionTableName, String shadowTableName, String auditTableName) throws Exception {
        this.m_ownUnit = unit;
        this.m_ownSchema = unit.getSchema();
        this.m_conSqlHandler = null;
        this.m_table = new TableName(tableOwner, tableName);
        this.m_version_table = new TableName(this.m_ownSchema.getSchemaName(), versionTableName);
        this.m_shadow_table = new TableName(this.m_ownSchema.getSchemaName(), shadowTableName);
        this.m_audit_table = new TableName(this.m_ownSchema.getSchemaName(), auditTableName);
        this.m_columnsById = new Hashtable();
        this.m_keyColumnsById = new Hashtable();
        this.m_columnTypesById = new Hashtable();
    }

    void init() {
        this.m_col_count = this.m_columnsById.size();
        this.m_key_count = this.m_keyColumnsById.size();
        this.m_non_key_count = this.m_col_count - this.m_key_count;
        this.m_keyIDs = new Long[this.m_key_count];
        this.m_keyTypes = new int[this.m_key_count];
        this.m_keyNames = new String[this.m_key_count];
        this.m_nonKeyIDs = new Long[this.m_non_key_count];
        this.m_nonKeyTypes = new int[this.m_non_key_count];
        this.m_nonKeyNames = new String[this.m_non_key_count];
        int key_idx = 0;
        int nonkey_idx = 0;
        Enumeration en = this.getColumnIdEnum();
        while (en.hasMoreElements()) {
            Long col_id_obj = (Long)en.nextElement();
            String col_name = this.getColumnById(col_id_obj);
            int col_type = this.getColumnTypeById(col_id_obj);
            if (this.isKeyColumnById(col_id_obj)) {
                this.m_keyIDs[key_idx] = col_id_obj;
                this.m_keyNames[key_idx] = col_name;
                this.m_keyTypes[key_idx] = col_type;
                ++key_idx;
                continue;
            }
            this.m_nonKeyIDs[nonkey_idx] = col_id_obj;
            this.m_nonKeyNames[nonkey_idx] = col_name;
            this.m_nonKeyTypes[nonkey_idx] = col_type;
            ++nonkey_idx;
        }
    }

    private String getColumnById(Long columnId) {
        return (String)this.m_columnsById.get(columnId);
    }

    private int getColumnTypeById(Long columnId) {
        return (Integer)this.m_columnTypesById.get(columnId);
    }

    public int getColumnCount() {
        return this.m_col_count;
    }

    private boolean isKeyColumnById(Long columnId) {
        return this.m_keyColumnsById.get(columnId) != null;
    }

    public int getKeyColumnCount() {
        return this.m_key_count;
    }

    private Enumeration getColumnIdEnum() {
        return this.m_columnsById.keys();
    }

    public ReplicationUnit getUnit() {
        return this.m_ownUnit;
    }

    public TableName getTableName() {
        return this.m_table;
    }

    public TableName getVersionTableName() {
        return this.m_version_table;
    }

    public TableName getShadowTableName() {
        return this.m_shadow_table;
    }

    public TableName getAuditTableName() {
        return this.m_audit_table;
    }

    public TableConsumptionSQLHandler getTableConsumptionSQLHandler() {
        if (this.m_conSqlHandler == null) {
            try {
                this.m_conSqlHandler = TableConsumptionSQLHandler.createHandler(this.m_ownSchema, this.m_ownUnit, this);
            }
            catch (Exception ex) {
                RuntimeException rt = new RuntimeException(ex.getMessage());
                rt.fillInStackTrace();
                throw rt;
            }
        }
        return this.m_conSqlHandler;
    }

    void addColumn(Long colId, String colName, Integer colType, boolean isInKey) {
        this.m_columnsById.put(colId, colName);
        this.m_columnTypesById.put(colId, colType);
        if (isInKey) {
            this.m_keyColumnsById.put(colId, colName);
        }
    }

    public Long[] getKeyIDs() {
        return this.m_keyIDs;
    }

    public int[] getKeyTypes() {
        return this.m_keyTypes;
    }

    public String[] getKeyNames() {
        return this.m_keyNames;
    }

    public Long[] getNonKeyIDs() {
        return this.m_nonKeyIDs;
    }

    public int[] getNonKeyTypes() {
        return this.m_nonKeyTypes;
    }

    public String[] getNonKeyNames() {
        return this.m_nonKeyNames;
    }
}

