/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.consumption;

import com.sap.sdb.syncMan.SyncManThreadManager;
import com.sap.sdb.syncMan.SyncService;
import com.sap.sdb.syncMan.consumption.ConsumptionQueue;
import com.sap.sdb.syncMan.consumption.ConsumptionUpdateHandlerThread;
import com.sap.sdb.syncMan.definition.ReplicationUnit;
import com.sap.sdb.syncMan.message.RowReceiveMessage;
import com.sap.sdb.syncMan.message.SyncManMessage;
import com.sap.sdb.syncMan.util.DebugOutput;
import com.sap.sdb.syncMan.util.SQLBuilder;
import javax.jms.Connection;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.naming.InitialContext;

public class ConsumptionMessageListener {
    private ReplicationUnit m_unt;
    private TopicConnection m_topic_connection = null;
    private QueueConnection m_queue_connection = null;
    private Connection m_connection = null;
    private TopicSession m_topic_session = null;
    private QueueSession m_queue_session = null;
    private Session m_session = null;
    private MessageConsumer m_jms_consumer;
    private MessageListener m_jms_msglistener;
    private ExceptionListener m_jms_exlistener;
    private ConsumptionQueue m_cqueue = null;
    private ConsumptionUpdateHandlerThread m_updateHandler = null;
    int m_msgs_inprocess;
    int m_transactionRetries;
    int m_maxTransactionRetries;
    boolean m_transactionCompleted;
    static /* synthetic */ Class class$com$sap$sdb$syncMan$util$DebugOutput;

    public ConsumptionMessageListener(ReplicationUnit unt) throws Exception {
        this.m_unt = unt;
        this.m_maxTransactionRetries = 20;
        this.m_transactionRetries = 0;
        this.m_msgs_inprocess = 0;
        this.m_transactionCompleted = false;
        this.m_jms_msglistener = new MessageListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onMessage(Message jms_msg) {
                try {
                    RowReceiveMessage msg = SyncManMessage.createFromJMSMessage(jms_msg);
                    do {
                        if (DebugOutput.isVerboseConsumptionMsg()) {
                            DebugOutput.println("" + System.currentTimeMillis() + " : " + "ConsumptionMessageListener " + this + " : onMessage : " + msg.toString());
                        }
                        if (ConsumptionMessageListener.this.m_cqueue == null) {
                            ConsumptionMessageListener.this.m_cqueue = new ConsumptionQueue("" + ConsumptionMessageListener.this.m_unt.getUnitID() + "." + "(" + ConsumptionMessageListener.this.m_unt.getUnitName() + ")");
                            ConsumptionMessageListener.this.m_updateHandler = ConsumptionUpdateHandlerThread.create(ConsumptionMessageListener.this);
                            ConsumptionMessageListener.this.m_updateHandler.start();
                        }
                        ConsumptionMessageListener consumptionMessageListener = ConsumptionMessageListener.this;
                        synchronized (consumptionMessageListener) {
                            ConsumptionMessageListener.this.m_cqueue.push(msg);
                            ++ConsumptionMessageListener.this.m_msgs_inprocess;
                            if (msg.getIsLastInTransaction()) {
                                ConsumptionMessageListener.this.m_connection.stop();
                                ConsumptionMessageListener.this.m_transactionCompleted = true;
                            }
                        }
                    } while (null != (msg = msg.getNextReceivedMsg()));
                }
                catch (Exception ex) {
                    Class clazz = class$com$sap$sdb$syncMan$util$DebugOutput == null ? (class$com$sap$sdb$syncMan$util$DebugOutput = ConsumptionMessageListener.class$("com.sap.sdb.syncMan.util.DebugOutput")) : class$com$sap$sdb$syncMan$util$DebugOutput;
                    synchronized (clazz) {
                        DebugOutput.printErrorMsg("consumption ERROR : ");
                        DebugOutput.printException(ex);
                    }
                }
            }
        };
        this.m_jms_exlistener = new ExceptionListener(){

            public void onException(JMSException exception) {
                ConsumptionMessageListener.this.handleFatalException((Exception)((Object)exception));
            }
        };
        try {
            InitialContext jndi = new InitialContext(this.m_unt.getJndiProperties());
            String pass = SQLBuilder.makeMsgSvrPassword(this.m_unt.getInboundDestPass(), this.m_unt.getInboundDestName());
            if (this.m_unt.isMaster()) {
                QueueConnectionFactory conFactory = (QueueConnectionFactory)jndi.lookup("jms.QueueConnectionFactory");
                this.m_queue_connection = conFactory.createQueueConnection("", pass);
                this.m_connection = this.m_queue_connection;
                this.m_queue_session = this.m_queue_connection.createQueueSession(true, 1);
                this.m_session = this.m_queue_session;
                Queue queue = (Queue)jndi.lookup("jms.queue." + this.m_unt.getInboundDestName());
                this.m_jms_consumer = this.m_queue_session.createReceiver(queue);
                this.m_jms_consumer.setMessageListener(this.m_jms_msglistener);
                this.m_queue_connection.setExceptionListener(this.m_jms_exlistener);
            } else {
                TopicConnectionFactory conFactory = (TopicConnectionFactory)jndi.lookup("jms.TopicConnectionFactory");
                this.m_topic_connection = conFactory.createTopicConnection("", pass);
                this.m_connection = this.m_topic_connection;
                this.m_topic_session = this.m_topic_connection.createTopicSession(true, 1);
                this.m_session = this.m_topic_session;
                Topic topic = (Topic)jndi.lookup("jms.topic." + this.m_unt.getInboundDestName());
                String msgSelector = SyncManMessage.createMessageSelectorString(this.m_unt.getUnitID());
                String subscriptionName = String.valueOf(this.m_unt.getUnitID());
                this.m_jms_consumer = this.m_topic_session.createDurableSubscriber(topic, subscriptionName, msgSelector, false);
                if (DebugOutput.isVerboseConsumption()) {
                    DebugOutput.println("ConsumptionMessageListener " + this + " ctor : Topic : " + "jms.topic." + this.m_unt.getInboundDestName());
                    DebugOutput.println("ConsumptionMessageListener " + this + " ctor : Unit: " + String.valueOf(this.m_unt.getUnitID()));
                    DebugOutput.println("ConsumptionMessageListener " + this + " ctor : Selector: " + msgSelector);
                }
                this.m_jms_consumer.setMessageListener(this.m_jms_msglistener);
                this.m_topic_connection.setExceptionListener(this.m_jms_exlistener);
            }
        }
        catch (Exception ex) {
            this.handleFatalException(ex);
        }
    }

    public ReplicationUnit getUnit() {
        return this.m_unt;
    }

    public ConsumptionQueue getCQueue() {
        return this.m_cqueue;
    }

    private void handleFatalException(Exception ex) {
        DebugOutput.setVerboseException();
        try {
            if (this.m_connection != null) {
                this.m_connection.stop();
            }
        }
        catch (Exception stex) {
            DebugOutput.printException(stex);
        }
        DebugOutput.printException(ex);
        SyncManThreadManager.abortAllThreads(ex);
    }

    public void start() {
        try {
            if (this.m_connection != null) {
                this.m_connection.start();
            }
        }
        catch (Exception ex) {
            this.handleFatalException(ex);
        }
    }

    public synchronized void messageProcessed() throws Exception {
        SyncService.keepAlive();
        --this.m_msgs_inprocess;
        if (this.m_msgs_inprocess == 0 && this.m_transactionCompleted) {
            this.m_updateHandler.commitDbConnection();
            this.m_session.commit();
            this.m_transactionRetries = 0;
            this.m_transactionCompleted = false;
            this.m_connection.start();
        }
    }

    public void retryMsgTransaction() throws Exception {
        SyncService.keepAlive();
        if (this.m_transactionRetries >= this.m_maxTransactionRetries) {
            throw new Exception("giving up after " + this.m_maxTransactionRetries + " retries of same messaging transaction.");
        }
        this.m_connection.stop();
        this.m_session.rollback();
        this.m_updateHandler.rollbackDbConnection();
        ++this.m_transactionRetries;
        this.m_cqueue.clear();
        this.m_updateHandler.reinitializeIgnoreList();
        this.m_msgs_inprocess = 0;
        this.m_transactionCompleted = false;
        if (DebugOutput.isVerbose()) {
            DebugOutput.println("Consumption INFO : retrying messaging transaction for unit " + String.valueOf(this.m_unt.getUnitID()) + ".");
            DebugOutput.println("Consumption INFO : number of retries: " + this.m_transactionRetries + "/" + this.m_maxTransactionRetries);
        }
        this.m_connection.start();
    }

    public void close() throws Exception {
        this.m_connection.stop();
        this.m_updateHandler.pleaseStop();
        this.m_updateHandler.rollbackDbConnection();
        this.m_session.rollback();
        this.m_updateHandler.freeDbConnection();
        this.m_connection.close();
    }
}

