/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.capture;

import com.sap.sdb.syncMan.capture.CaptureManager;
import com.sap.sdb.syncMan.capture.CaptureUnit;
import com.sap.sdb.syncMan.message.MessageFreeList;
import com.sap.sdb.syncMan.message.RowSendMessage;
import java.util.Iterator;
import java.util.LinkedList;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.QueueSender;
import javax.jms.TopicPublisher;

class CaptureUnitSender {
    private RowSendMessage m_topicMsgToSend = null;
    private LinkedList m_queueMsgToSendList = null;
    private Message m_jmsMessage = null;
    private QueueSender m_queueSender = null;
    private TopicPublisher m_topicPublisher = null;
    private int m_cachedTransDataSize = 0;
    private int m_transMsgCount = 0;
    private static final int MAX_CACHED_TRANS_DATA_SIZE = 32768;

    CaptureUnitSender(CaptureUnit unit) throws JMSException {
        if (unit.isMaster()) {
            this.m_jmsMessage = CaptureManager.getJMSTopicMessage();
            this.m_topicPublisher = CaptureManager.getJMSTopicPublisher(unit.getDestination());
        } else {
            this.m_queueMsgToSendList = new LinkedList();
            this.m_jmsMessage = CaptureManager.getJMSQueueMessage();
            this.m_queueSender = CaptureManager.getJMSQueueSender(unit.getDestination());
        }
    }

    synchronized void addDataMessage(RowSendMessage msg) throws JMSException {
        ++this.m_transMsgCount;
        if (this.m_queueMsgToSendList == null) {
            if (this.m_topicMsgToSend != null) {
                this.sendTopicMessage();
            }
            this.m_topicMsgToSend = msg;
        } else {
            this.m_cachedTransDataSize += msg.getColumnDataSize();
            if (this.m_cachedTransDataSize > 32768) {
                this.sendCachedQueueMessages();
                this.m_cachedTransDataSize = msg.getColumnDataSize();
            }
            this.m_queueMsgToSendList.addLast(msg);
        }
    }

    private synchronized void sendCachedQueueMessages() throws JMSException {
        int msgCount = this.m_queueMsgToSendList.size();
        if (msgCount == 0) {
            return;
        }
        boolean isFirst = true;
        Iterator iter = this.m_queueMsgToSendList.iterator();
        while (iter.hasNext()) {
            RowSendMessage currMsgToSend = (RowSendMessage)iter.next();
            if (isFirst) {
                currMsgToSend.initMultiJMSMessage(this.m_jmsMessage, msgCount);
                isFirst = false;
            } else {
                currMsgToSend.appendToJMSMessage(this.m_jmsMessage);
                if (!iter.hasNext()) {
                    currMsgToSend.finishMultiJMSMessage(this.m_jmsMessage);
                }
            }
            MessageFreeList.freeRowSendMessage(currMsgToSend);
        }
        this.m_queueSender.send(this.m_jmsMessage);
        this.m_queueMsgToSendList.clear();
        this.m_cachedTransDataSize = 0;
    }

    synchronized void sendLastMessage() throws JMSException {
        ++this.m_transMsgCount;
        if (this.m_queueMsgToSendList == null) {
            if (this.m_topicMsgToSend != null) {
                this.m_topicMsgToSend.setIsLastInTransaction();
                this.sendTopicMessage();
            }
        } else if (!this.m_queueMsgToSendList.isEmpty()) {
            RowSendMessage lastMsg = (RowSendMessage)this.m_queueMsgToSendList.getLast();
            lastMsg.setIsLastInTransaction();
            this.sendCachedQueueMessages();
        }
        this.m_transMsgCount = 0;
    }

    private void sendTopicMessage() throws JMSException {
        boolean sendToAll = this.m_topicMsgToSend.buildJMSMessage(this.m_jmsMessage);
        this.m_topicPublisher.publish(this.m_jmsMessage);
        if (!sendToAll && this.m_transMsgCount > 1 && this.m_topicMsgToSend.getIsLastInTransaction()) {
            this.m_topicMsgToSend.createEndOfTransJMSMsg(this.m_jmsMessage);
            this.m_topicPublisher.publish(this.m_jmsMessage);
        }
        MessageFreeList.freeRowSendMessage(this.m_topicMsgToSend);
        this.m_topicMsgToSend = null;
    }
}

