/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.capture;

import com.sap.sdb.syncMan.SyncManThread;
import com.sap.sdb.syncMan.SyncManThreadManager;
import com.sap.sdb.syncMan.capture.CaptureManager;
import com.sap.sdb.syncMan.capture.CapturePrepStmtCache;
import com.sap.sdb.syncMan.capture.CaptureShadowTable;
import com.sap.sdb.syncMan.capture.CaptureSourceTable;
import com.sap.sdb.syncMan.capture.CaptureTable;
import com.sap.sdb.syncMan.capture.CaptureTableHandler;
import com.sap.sdb.syncMan.capture.CaptureTransHandler;
import com.sap.sdb.syncMan.capture.CaptureUnit;
import com.sap.sdb.syncMan.capture.CaptureUnitSender;
import com.sap.sdb.syncMan.message.RowSendMessage;
import com.sap.sdb.syncMan.util.ConnectionPool;
import com.sap.sdb.syncMan.util.TableName;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.jms.JMSException;

abstract class CaptureHandler
extends SyncManThread {
    private boolean m_isAnyoneWaitingForSpace = false;
    private boolean m_isHandlerWaitingForMsg = false;
    private int m_numberOfCaptureTables = 0;
    private long m_msgSentCount = 0L;
    private long m_createdVersionCount = 0L;
    private HashMap m_unitSenderMap = new HashMap();
    private HashMap m_transSendMap = new HashMap();
    private HashMap m_captureTabMap = new HashMap();
    private LinkedList m_msgToSendQueue = new LinkedList();
    private LinkedList m_captureTableQueue = new LinkedList();
    private Exception m_tableHandlerException = null;
    private CapturePrepStmtCache m_prepStmtCache;
    private static final int MSG_TO_SEND_LIMIT = 100;
    private static final int MSG_TO_SEND_NOTIFY = 20;

    CaptureHandler(String name, int maxTableHandlers, String[] unitnames) {
        super(name);
        this.m_prepStmtCache = new CapturePrepStmtCache(ConnectionPool.getSchema(), unitnames);
        int maxHandlers = maxTableHandlers < 1 ? 1 : maxTableHandlers;
        for (int i = 0; i < maxHandlers; ++i) {
            CaptureTableHandler tableHandler = new CaptureTableHandler(this, unitnames);
            tableHandler.start();
        }
    }

    boolean accumulatedUpdWanted() {
        return false;
    }

    synchronized void addCreatedVersionCount(long versionCount) {
        this.m_createdVersionCount += versionCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addReplicationMessage(CaptureUnit unit, RowSendMessage msg) throws JMSException {
        if (Thread.currentThread() == this) {
            this.getUnitSender(unit).addDataMessage(msg);
            if (this.m_msgSentCount < Long.MAX_VALUE) {
                ++this.m_msgSentCount;
            }
            return;
        }
        MessageToSend msgToSend = new MessageToSend(unit, msg);
        LinkedList linkedList = this.m_msgToSendQueue;
        synchronized (linkedList) {
            while (this.m_msgToSendQueue.size() > 100 || this.m_isAnyoneWaitingForSpace && this.m_msgToSendQueue.size() > 20) {
                this.m_isAnyoneWaitingForSpace = true;
                SyncManThread client = (SyncManThread)Thread.currentThread();
                try {
                    client.waitSemaphore(this.m_msgToSendQueue, 0L, "message queue space");
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                if (this.m_tableHandlerException == null) continue;
                throw new JMSException("table handler error: " + this.m_tableHandlerException.toString());
            }
            this.m_msgToSendQueue.add(msgToSend);
            if (this.m_isHandlerWaitingForMsg) {
                this.m_isHandlerWaitingForMsg = false;
                this.m_msgToSendQueue.notifyAll();
            }
        }
    }

    void checkTableHandleException() throws Exception {
        if (this.m_tableHandlerException != null) {
            throw this.m_tableHandlerException;
        }
    }

    boolean existsUnitSenderMap() {
        return this.m_unitSenderMap != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishJMSTransaction() throws JMSException {
        Object[] senderList = null;
        CaptureHandler captureHandler = this;
        synchronized (captureHandler) {
            if (this.m_unitSenderMap != null) {
                senderList = this.m_transSendMap.values().toArray();
            }
            this.m_transSendMap.clear();
        }
        if (senderList != null) {
            for (int i = 0; i < senderList.length; ++i) {
                ((CaptureUnitSender)senderList[i]).sendLastMessage();
            }
        }
        CaptureManager.commitJMSSession();
    }

    CaptureTable getCaptureTable(Connection con, TableName tabname) throws SQLException {
        CaptureTable captureTab = (CaptureTable)this.m_captureTabMap.get(tabname);
        if (captureTab == null) {
            if (this instanceof CaptureTransHandler) {
                captureTab = new CaptureShadowTable(this, con, tabname);
            } else {
                captureTab = new CaptureSourceTable(this, con, tabname);
                this.m_captureTabMap.put(tabname, captureTab);
            }
        }
        return captureTab;
    }

    synchronized long getCreatedVersionCount() {
        return this.m_createdVersionCount;
    }

    abstract String getCurrentTransID();

    long getMsgSentCount() {
        return this.m_msgSentCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CaptureTable getNextCaptureTable() throws InterruptedException {
        LinkedList linkedList = this.m_captureTableQueue;
        synchronized (linkedList) {
            while (this.m_captureTableQueue.size() <= 0) {
                SyncManThread.performWait(this.m_captureTableQueue, 0L, "table");
            }
            return (CaptureTable)this.m_captureTableQueue.removeFirst();
        }
    }

    CapturePrepStmtCache getPrepStmtCache() {
        return this.m_prepStmtCache;
    }

    long getSingleRecieverID() {
        return -1L;
    }

    int getUnfinishedTables() {
        return this.m_numberOfCaptureTables;
    }

    private synchronized CaptureUnitSender getUnitSender(CaptureUnit unit) throws JMSException {
        CaptureUnitSender sender = null;
        Long keyUnitId = null;
        if (this.m_unitSenderMap != null && (sender = (CaptureUnitSender)this.m_unitSenderMap.get(keyUnitId = new Long(unit.getUnitID()))) == null) {
            sender = new CaptureUnitSender(unit);
            this.m_unitSenderMap.put(keyUnitId, sender);
        }
        if (sender == null) {
            throw new JMSException("sender of replication unit not available");
        }
        this.m_transSendMap.put(keyUnitId, sender);
        return sender;
    }

    synchronized void removeAllUnitSenders() {
        this.m_unitSenderMap = null;
        this.m_transSendMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void reset() {
        this.m_numberOfCaptureTables = 0;
        this.m_tableHandlerException = null;
        LinkedList linkedList = this.m_captureTableQueue;
        synchronized (linkedList) {
            this.m_captureTableQueue.clear();
        }
        linkedList = this.m_msgToSendQueue;
        synchronized (linkedList) {
            this.m_msgToSendQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessagesAndFinishTables(Connection con) throws InterruptedException, JMSException, SQLException {
        while (!super.isStopWanted()) {
            Object obj;
            LinkedList linkedList = this.m_msgToSendQueue;
            synchronized (linkedList) {
                while (this.m_msgToSendQueue.size() <= 0) {
                    if (this.m_numberOfCaptureTables <= 0) {
                        return;
                    }
                    this.m_isHandlerWaitingForMsg = true;
                    super.waitSemaphore(this.m_msgToSendQueue, 0L, "message (" + this.m_msgSentCount + " sent)");
                    if (this.m_tableHandlerException != null || super.isStopWanted()) {
                        throw new InterruptedException();
                    }
                    super.setCustomMsg(this.m_msgSentCount + " messages sent");
                }
                obj = this.m_msgToSendQueue.removeFirst();
                if (this.m_msgToSendQueue.size() <= 20) {
                    this.m_isAnyoneWaitingForSpace = false;
                    this.m_msgToSendQueue.notifyAll();
                }
            }
            if (obj instanceof MessageToSend) {
                ((MessageToSend)obj).send();
                if (this.m_msgSentCount >= Long.MAX_VALUE) continue;
                ++this.m_msgSentCount;
                if (this.m_msgSentCount % 100L != 0L) continue;
                super.setCustomMsg(this.m_msgSentCount + " messages sent");
                continue;
            }
            if (!(obj instanceof CaptureShadowTable)) continue;
            ((CaptureShadowTable)obj).deleteTransEntries(con, ((CaptureTransHandler)this).getCurrentTransIDBytes());
        }
        throw new InterruptedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNumberOfCaptureTables(int tabCount) {
        LinkedList linkedList = this.m_msgToSendQueue;
        synchronized (linkedList) {
            this.m_numberOfCaptureTables = tabCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void signalTableHandlerError(Exception ex) {
        LinkedList linkedList = this.m_msgToSendQueue;
        synchronized (linkedList) {
            if (this.m_tableHandlerException == null) {
                this.m_tableHandlerException = ex;
            }
            this.m_msgToSendQueue.notifyAll();
        }
        super.setFinished();
        SyncManThreadManager.abortAllThreads(ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void signalTableHandlerFinished(CaptureTable captureTab) {
        LinkedList linkedList = this.m_msgToSendQueue;
        synchronized (linkedList) {
            --this.m_numberOfCaptureTables;
            if (captureTab instanceof CaptureShadowTable) {
                this.m_msgToSendQueue.add(captureTab);
            }
            this.m_msgToSendQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void triggerAndWaitForTableHandlers(Connection con, Iterator tabIter) throws Exception {
        while (tabIter.hasNext()) {
            TableName tabname = (TableName)tabIter.next();
            CaptureTable captureTab = this.getCaptureTable(con, tabname);
            LinkedList linkedList = this.m_captureTableQueue;
            synchronized (linkedList) {
                this.m_captureTableQueue.add(captureTab);
                this.m_captureTableQueue.notify();
            }
        }
        this.sendMessagesAndFinishTables(con);
    }

    private class MessageToSend {
        private CaptureUnit m_unit;
        private RowSendMessage m_msg;

        MessageToSend(CaptureUnit unit, RowSendMessage msg) {
            this.m_unit = unit;
            this.m_msg = msg;
        }

        void send() throws JMSException {
            CaptureHandler.this.getUnitSender(this.m_unit).addDataMessage(this.m_msg);
        }
    }
}

