/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.capture;

import com.sap.sdb.syncMan.capture.CaptureHandler;
import com.sap.sdb.syncMan.capture.CaptureManager;
import com.sap.sdb.syncMan.capture.CapturePrepStmtCache;
import com.sap.sdb.syncMan.util.ConnectionPool;
import com.sap.sdb.syncMan.util.DebugOutput;
import com.sap.sdb.syncMan.util.TableName;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;

class CaptureCopyHandler
extends CaptureHandler {
    private boolean m_initRowVersOnly;
    private long m_singleReceiverID;
    private LinkedList m_tableList;
    private String m_actionMsg;
    private static final String HANDLER_NAME = "CaptureCopyHandler";

    CaptureCopyHandler(long singleReceiverID, String[] masterUnits, int maxTableHandlers) {
        super(HANDLER_NAME, maxTableHandlers, masterUnits);
        this.m_initRowVersOnly = false;
        this.m_actionMsg = "initial copy";
        this.m_tableList = new LinkedList();
        this.m_singleReceiverID = singleReceiverID;
    }

    CaptureCopyHandler(String[] masterUnits, int maxTableHandlers) {
        super(HANDLER_NAME, maxTableHandlers, masterUnits);
        this.m_initRowVersOnly = true;
        this.m_actionMsg = "init row versions";
        this.m_tableList = new LinkedList();
        this.m_singleReceiverID = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyTables() throws Exception {
        try {
            Connection con = ConnectionPool.getConnection();
            try {
                this.selectTables(con);
                con.commit();
                if (super.isStopWanted()) {
                    return;
                }
                super.setCustomMsg(this.m_actionMsg);
                super.setNumberOfCaptureTables(this.m_tableList.size());
                super.triggerAndWaitForTableHandlers(con, this.m_tableList.iterator());
                con.commit();
            }
            finally {
                ConnectionPool.freeConnection(con);
            }
            if (!this.m_initRowVersOnly) {
                super.finishJMSTransaction();
            }
            super.checkTableHandleException();
            int unfinishedTables = super.getUnfinishedTables();
            if (unfinishedTables > 0) {
                throw new Exception(this.m_actionMsg + " incomplete (" + unfinishedTables + " tables left)");
            }
        }
        catch (InterruptedException ex) {
            super.checkTableHandleException();
            throw new Exception(this.m_actionMsg + " terminated by InterruptedException");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doWork() throws Exception {
        long startTime = System.currentTimeMillis();
        Exception ownException = null;
        this.reset();
        try {
            try {
                this.copyTables();
            }
            catch (Exception ex) {
                ownException = ex;
                throw ex;
            }
            Object var6_3 = null;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            if (DebugOutput.isVerboseCapture() || DebugOutput.isVerbose()) {
                if (ownException != null) {
                    DebugOutput.println(this.m_actionMsg + " terminated: " + ownException.toString());
                } else {
                    String durationPrefix;
                    long duration = System.currentTimeMillis() - startTime;
                    long durationMin = duration / 60000L;
                    long durationSec = duration / 1000L % 60L;
                    long durationMSec = duration % 1000L;
                    String string = durationPrefix = durationSec < 10L ? durationMin + ":0" + durationSec : durationMin + ":" + durationSec;
                    String durationMsg = durationMSec < 10L ? durationPrefix + ".00" + durationMSec : (durationMSec < 100L ? durationPrefix + ".0" + durationMSec : durationPrefix + "." + durationMSec);
                    String msgPrefix = this.m_actionMsg + " finished (" + durationMsg + "  " + super.getCreatedVersionCount() + " row versions inserted";
                    if (this.m_initRowVersOnly) {
                        DebugOutput.println(msgPrefix + ")");
                    } else {
                        DebugOutput.println(msgPrefix + ";  " + super.getMsgSentCount() + " messages sent)");
                    }
                }
            }
            CaptureManager.signalCaptureHandlerFinished();
            super.setFinished();
            throw throwable;
        }
        if (DebugOutput.isVerboseCapture() || DebugOutput.isVerbose()) {
            if (ownException != null) {
                DebugOutput.println(this.m_actionMsg + " terminated: " + ownException.toString());
            } else {
                String durationPrefix;
                long duration = System.currentTimeMillis() - startTime;
                long durationMin = duration / 60000L;
                long durationSec = duration / 1000L % 60L;
                long durationMSec = duration % 1000L;
                String string = durationPrefix = durationSec < 10L ? durationMin + ":0" + durationSec : durationMin + ":" + durationSec;
                String durationMsg = durationMSec < 10L ? durationPrefix + ".00" + durationMSec : (durationMSec < 100L ? durationPrefix + ".0" + durationMSec : durationPrefix + "." + durationMSec);
                String msgPrefix = this.m_actionMsg + " finished (" + durationMsg + "  " + super.getCreatedVersionCount() + " row versions inserted";
                if (this.m_initRowVersOnly) {
                    DebugOutput.println(msgPrefix + ")");
                } else {
                    DebugOutput.println(msgPrefix + ";  " + super.getMsgSentCount() + " messages sent)");
                }
            }
        }
        CaptureManager.signalCaptureHandlerFinished();
        super.setFinished();
    }

    String getCurrentTransID() {
        return null;
    }

    long getSingleRecieverID() {
        return this.m_singleReceiverID;
    }

    boolean isInitRowVersOnly() {
        return this.m_initRowVersOnly;
    }

    void selectTables(Connection con) throws SQLException {
        super.setCustomMsg("select tables");
        CapturePrepStmtCache prepStmtCache = super.getPrepStmtCache();
        PreparedStatement prepStmt = prepStmtCache.getPrepStmt(con, 1);
        ResultSet result = prepStmt.executeQuery();
        while (result.next()) {
            TableName tabname = new TableName(result.getString("TABLE_SCHEMA"), result.getString("TABLE_NAME"));
            this.m_tableList.add(tabname);
        }
        result.close();
    }
}

