/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan;

import com.sap.sdb.syncMan.SyncManThreadManager;
import com.sap.sdb.syncMan.util.DebugOutput;
import java.util.Date;

public abstract class SyncManThread
extends Thread {
    private boolean m_verboseWait = DebugOutput.isVerboseWait();
    private long m_waitCount = 0L;
    private String m_actionMsg = "initialized";
    private String m_customMsg = "";
    private boolean m_stopFlag = false;
    private boolean m_stopped = true;
    private static int s_threadCount = 0;

    public SyncManThread(String name) {
        super(name + "-" + s_threadCount++);
        super.setDaemon(true);
    }

    public abstract void doWork() throws Exception;

    boolean hasStopped() {
        return this.m_stopped;
    }

    public boolean isStopWanted() {
        return this.m_stopFlag;
    }

    public void performSleep(int seconds) throws InterruptedException {
        this.setActionMsg("sleeping " + seconds + " sec");
        Thread.sleep(1000 * seconds);
        this.resetActionMsg();
    }

    public static void performWait(Object obj, long timeout, String objName) throws InterruptedException {
        Thread ownThread = Thread.currentThread();
        if (ownThread instanceof SyncManThread) {
            ((SyncManThread)ownThread).waitSemaphore(obj, timeout, objName);
        } else {
            obj.wait(timeout);
        }
    }

    public synchronized void pleaseStop() {
        if (!this.m_stopFlag) {
            this.m_stopFlag = true;
            this.interrupt();
        }
    }

    public void println(String line) {
        DebugOutput.println("[" + new Date() + " " + super.getName() + "] " + line);
    }

    public void printOwnAction() {
        this.println(this.m_actionMsg);
        if (this.m_customMsg != null && this.m_customMsg.trim().length() != 0) {
            this.println(this.m_customMsg);
        }
    }

    void printState() {
        String stateMsg;
        String string = stateMsg = this.m_customMsg != null && this.m_customMsg.trim().length() > 0 ? "; " + this.m_customMsg.trim() : "";
        if (this.m_waitCount == 1L) {
            this.println("1 wait call; " + this.m_actionMsg + stateMsg);
        } else {
            this.println(this.m_waitCount + " wait calls; " + this.m_actionMsg + stateMsg);
        }
    }

    public void printTraceLine(String line) {
        if (DebugOutput.isVerbose()) {
            this.println(line);
        }
    }

    public void resetActionMsg() {
        this.m_actionMsg = "running";
    }

    public void resetCustomMsg() {
        this.m_customMsg = null;
    }

    public void run() {
        if (!this.m_stopFlag) {
            boolean isOK = SyncManThreadManager.addThread();
            if (!isOK) {
                this.m_stopFlag = true;
            } else {
                this.printTraceLine("started");
                this.resetActionMsg();
                this.m_stopped = false;
            }
        }
        while (!this.m_stopFlag) {
            try {
                this.doWork();
            }
            catch (InterruptedException ex) {
            }
            catch (Exception ex) {
                SyncManThreadManager.abortAllThreads(ex);
                DebugOutput.setVerboseException();
                DebugOutput.printException(ex);
                this.m_stopFlag = true;
            }
        }
        this.printTraceLine("stopped");
        this.m_actionMsg = "stopped";
        this.m_stopped = true;
    }

    public void setActionMsg(String actionMsg) {
        this.m_actionMsg = actionMsg;
    }

    public void setCustomMsg(String customMsg) {
        this.m_customMsg = customMsg;
    }

    public synchronized void setFinished() {
        this.m_stopFlag = true;
        this.m_actionMsg = "finished";
    }

    public void waitSemaphore(Object obj, long timeout, String objName) throws InterruptedException {
        this.m_actionMsg = "waiting for " + objName;
        if (this.m_verboseWait) {
            this.printOwnAction();
        }
        this.m_waitCount = this.m_waitCount < Long.MAX_VALUE ? ++this.m_waitCount : 0L;
        obj.wait(timeout);
        this.resetActionMsg();
        if (this.m_verboseWait) {
            this.printOwnAction();
        }
    }
}

