/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.programmargs;

import com.sap.sdb.programmargs.Crypt;
import com.sap.sdb.programmargs.ToolParams;
import java.util.Enumeration;
import java.util.Properties;

public class AccParams
extends ToolParams {
    private static final String m_host_name = "database_host";
    private static final String m_database_name = "database_name";
    private static final String m_user_name = "database_user";
    private static final String m_password_name = "database_password";
    private static final String m_db_ssl_name = "dbsecure";
    private static final String m_ms_password_name = "msgserver_password";
    private static final String m_ms_msg_name = "msgserver_msg_host";
    private static final String m_ms_jndi_name = "msgserver_jndi_host";
    private static final String m_ms_admin_port_name = "msgserver_admin_port";
    private static final String m_ms_msg_port_name = "msgserver_msg_port";
    private static final String m_ms_jndi_port_name = "msgserver_jndi_port";
    private static final String m_ms_ssl_name = "msgserver_secure";
    private static final String m_sync_admin_port_name = "sync_admin_port";
    private String m_access_key = null;
    private String m_host = "";
    private String m_database = "";
    private String m_user = "";
    private String m_password = "";
    private String m_db_ssl = "";
    private String m_ms_password = "";
    private String m_ms_msg_server = "";
    private String m_ms_jndi_server = "";
    private String m_ms_admin_port = "";
    private String m_ms_msg_port = "";
    private String m_ms_jndi_port = "";
    private String m_ms_ssl = "";
    private String m_sync_admin_port = "";
    private Crypt m_crypt;

    public AccParams(String key, String security_provider) throws Exception {
        super(".syncmanacc", "Synchronization Manager Access");
        this.m_crypt = new Crypt(key, security_provider);
        this.m_access_key = key + "_";
    }

    public void deleteParams() {
        this.m_host = "";
        this.m_database = "";
        this.m_user = "";
        this.m_password = "";
        this.m_db_ssl = "";
        this.m_ms_password = "";
        this.m_ms_msg_server = "";
        this.m_ms_jndi_server = "";
        this.m_ms_admin_port = "";
        this.m_ms_msg_port = "";
        this.m_ms_jndi_port = "";
        this.m_ms_ssl = "";
        Enumeration<Object> enumeration = this.m_properties.keys();
        while (enumeration.hasMoreElements()) {
            Object next = enumeration.nextElement();
            if (!next.toString().startsWith(this.m_access_key)) continue;
            this.m_properties.remove(next);
        }
    }

    protected void setDefaults(Properties defaults) {
        defaults.put(this.m_access_key + m_host_name, "");
        defaults.put(this.m_access_key + m_database_name, "");
        defaults.put(this.m_access_key + m_user_name, "");
        defaults.put(this.m_access_key + m_password_name, "");
        defaults.put(this.m_access_key + m_db_ssl_name, "");
        defaults.put(this.m_access_key + m_ms_password_name, "");
        defaults.put(this.m_access_key + m_ms_msg_name, "");
        defaults.put(this.m_access_key + m_ms_jndi_name, "");
        defaults.put(this.m_access_key + m_ms_admin_port_name, "");
        defaults.put(this.m_access_key + m_ms_jndi_port_name, "");
        defaults.put(this.m_access_key + m_ms_msg_port_name, "");
        defaults.put(this.m_access_key + m_ms_ssl_name, "");
        defaults.put(this.m_access_key + m_sync_admin_port_name, "");
    }

    protected void updatePropertiesFromSettings() {
        this.m_properties.put(this.m_access_key + m_host_name, this.m_host);
        this.m_properties.put(this.m_access_key + m_database_name, this.m_database);
        this.m_properties.put(this.m_access_key + m_user_name, this.m_user);
        this.m_properties.put(this.m_access_key + m_password_name, this.m_password);
        this.m_properties.put(this.m_access_key + m_db_ssl_name, this.m_db_ssl);
        this.m_properties.put(this.m_access_key + m_ms_msg_name, this.m_ms_msg_server);
        this.m_properties.put(this.m_access_key + m_ms_jndi_name, this.m_ms_jndi_server);
        this.m_properties.put(this.m_access_key + m_ms_admin_port_name, this.m_ms_admin_port);
        this.m_properties.put(this.m_access_key + m_ms_msg_port_name, this.m_ms_msg_port);
        this.m_properties.put(this.m_access_key + m_ms_jndi_port_name, this.m_ms_jndi_port);
        this.m_properties.put(this.m_access_key + m_ms_password_name, this.m_ms_password);
        this.m_properties.put(this.m_access_key + m_ms_ssl_name, this.m_ms_ssl);
        this.m_properties.put(this.m_access_key + m_sync_admin_port_name, this.m_sync_admin_port);
    }

    protected void updateSettingsFromProperties() {
        this.m_host = this.m_properties.getProperty(this.m_access_key + m_host_name);
        this.m_database = this.m_properties.getProperty(this.m_access_key + m_database_name);
        this.m_user = this.m_properties.getProperty(this.m_access_key + m_user_name);
        this.m_password = this.m_properties.getProperty(this.m_access_key + m_password_name);
        this.m_db_ssl = this.m_properties.getProperty(this.m_access_key + m_db_ssl_name);
        this.m_ms_msg_server = this.m_properties.getProperty(this.m_access_key + m_ms_msg_name);
        this.m_ms_jndi_server = this.m_properties.getProperty(this.m_access_key + m_ms_jndi_name);
        this.m_ms_admin_port = this.m_properties.getProperty(this.m_access_key + m_ms_admin_port_name);
        this.m_ms_msg_port = this.m_properties.getProperty(this.m_access_key + m_ms_msg_port_name);
        this.m_ms_jndi_port = this.m_properties.getProperty(this.m_access_key + m_ms_jndi_port_name);
        this.m_ms_password = this.m_properties.getProperty(this.m_access_key + m_ms_password_name);
        this.m_ms_ssl = this.m_properties.getProperty(this.m_access_key + m_ms_ssl_name);
        this.m_sync_admin_port = this.m_properties.getProperty(this.m_access_key + m_sync_admin_port_name);
    }

    public String getDBName() {
        return this.m_database;
    }

    public void setDBName(String database) {
        this.m_database = database;
    }

    public String getDB_SSL() {
        return this.m_db_ssl;
    }

    public void setDB_SSL(String db_ssl) {
        this.m_db_ssl = db_ssl;
    }

    public String getMsgAdminPassword() throws Exception {
        return this.m_crypt.decrypt(this.m_ms_password);
    }

    public void setMsgAdminPassword(String ms_password) throws Exception {
        this.m_ms_password = this.m_crypt.crypt(ms_password);
    }

    public String getMsgSvrAdminPort() {
        return this.m_ms_admin_port;
    }

    public void setMsgSvrAdminPort(String port) {
        this.m_ms_admin_port = port;
    }

    public String getJndiPort() {
        return this.m_ms_jndi_port;
    }

    public void setJndiPort(String port) {
        this.m_ms_jndi_port = port;
    }

    public void setMsgPort(String port) {
        this.m_ms_msg_port = port;
    }

    public String getMsgPort() {
        return this.m_ms_msg_port;
    }

    public String getMsgServer() {
        return this.m_ms_msg_server;
    }

    public void setMsgServer(String server) {
        this.m_ms_msg_server = server;
    }

    public String getJndiServer() {
        return this.m_ms_jndi_server;
    }

    public void setJndiServer(String server) {
        this.m_ms_jndi_server = server;
    }

    public String getMsg_SSL() {
        return this.m_ms_ssl;
    }

    public void setMsg_SSL(String ms_ssl) {
        this.m_ms_ssl = ms_ssl;
    }

    public String getDBHost() {
        return this.m_host;
    }

    public void setDBHost(String host) {
        this.m_host = host;
    }

    public String getDBPassword() throws Exception {
        return this.m_crypt.decrypt(this.m_password);
    }

    public void setDBPassword(String password) throws Exception {
        this.m_password = this.m_crypt.crypt(password == null ? "" : password);
    }

    public String getDBUser() throws Exception {
        return this.m_crypt.decrypt(this.m_user);
    }

    public void setDBUser(String user) throws Exception {
        this.m_user = this.m_crypt.crypt(user);
    }

    public void setSyncAdminPort(String sync_admin_port) {
        this.m_sync_admin_port = sync_admin_port;
    }

    public String getSyncAdminPort() {
        return this.m_sync_admin_port;
    }

    public boolean containsKey(String key) {
        return this.m_properties.containsKey(key + "_" + m_database_name);
    }
}

