/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.acc;

import com.sap.sdb.programmargs.AccParams;
import com.sap.sdb.programmargs.PasswordPrompt;
import com.sap.sdb.syncMan.tool.Resources;
import com.sap.sdb.syncMan.util.SQLBuilder;
import com.sap.sdb.syncMan.util.SyncManTokenizer;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class SyncManACC {
    private static final String DB_HOST = "-database_host";
    private static final String DB_NAME = "-database_name";
    private static final String USER = "-user";
    private static final String PASSWORD = "-password";
    private static final String ACCESS_KEY = "-access_key";
    private static final String DB_ENCRYPTION = "-database_encryption";
    private static final String MSG_ENCRYPTION = "-msgserver_encryption";
    private static final String MSG_SERVER = "-msgserver_host";
    private static final String JNDI_SERVER = "-jndiserver_host";
    private static final String MSG_SERVER_PORT = "-msgserver_port";
    private static final String JNDI_SERVER_PORT = "-jndiserver_port";
    private static final String MSG_SERVER_ADMIN_PORT = "-msgserver_admin_port";
    private static final String MSG_SERVER_PASSWORD = "-msgserver_password";
    private static final String COMMAND = "-command";
    private static final String SYNC_SERVICE_ADMIN_PORT = "-sync_admin_port";
    private static final String SECURITY_PROVIDER = "-security_provider";
    private static final String HELP1 = "-help";
    private static final String HELP2 = "-h";
    private static final String HELP3 = "-?";
    private static final String CMD_LIST = "list";
    private static final String CMD_CLEAR = "clear";
    private static final String CMD_SET = "set";
    private static final String CMD_EXISTS = "exists";
    private static final String CMD_HELP1 = "help";
    private static final String CMD_HELP2 = "h";
    private static final String CMD_HELP3 = "?";
    private static final String CMD_QUIT1 = "quit";
    private static final String CMD_QUIT2 = "bye";
    private static final String CMD_QUIT3 = "exit";
    private static String cmd_access_key = null;
    private static String cmd_host = null;
    private static String cmd_database = null;
    private static String cmd_user = null;
    private static String cmd_password = null;
    private static String cmd_db_ssl = null;
    private static String cmd_ms_password = null;
    private static String cmd_msg_server = null;
    private static String cmd_jndi_server = null;
    private static String cmd_ms_admin_port = null;
    private static String cmd_ms_msg_port = null;
    private static String cmd_ms_jndi_port = null;
    private static String cmd_ms_ssl = null;
    private static String cmd_security_provider = null;
    private static String cmd_sync_admin_port = null;
    private static boolean cmd_host_exits = false;
    private static boolean cmd_database_exits = false;
    private static boolean cmd_user_exits = false;
    private static boolean cmd_password_exits = false;
    private static boolean cmd_db_ssl_exits = false;
    private static boolean cmd_ms_password_exits = false;
    private static boolean cmd_msg_server_exits = false;
    private static boolean cmd_jndi_server_exits = false;
    private static boolean cmd_ms_admin_port_exits = false;
    private static boolean cmd_ms_msg_port_exits = false;
    private static boolean cmd_ms_jndi_port_exits = false;
    private static boolean cmd_ms_ssl_exits = false;
    private static boolean cmd_sync_admin_port_exits = false;
    private static String cmd_cmd = null;
    private static int m_retCode = 0;
    private static AccParams m_params;

    private SyncManACC() {
    }

    public static void main(String[] args) {
        boolean no_exit = false;
        try {
            int i = 0;
            while (i < args.length) {
                String tmp;
                if (args[i].equals("-n") || args[i].equals(DB_HOST)) {
                    cmd_host = args[i + 1];
                    cmd_host_exits = true;
                    i += 2;
                    continue;
                }
                if (args[i].equals("-d") || args[i].equals(DB_NAME)) {
                    cmd_database = args[i + 1];
                    cmd_database_exits = true;
                    i += 2;
                    continue;
                }
                if (args[i].equals("-A") || args[i].equals(ACCESS_KEY)) {
                    cmd_access_key = args[i + 1];
                    i += 2;
                    continue;
                }
                if (args[i].equals("-u")) {
                    StringTokenizer st = new StringTokenizer(args[i + 1], ",");
                    if (st.hasMoreTokens()) {
                        if (cmd_user != null && cmd_user.length() > 1) {
                            System.out.println("User " + Resources.getString((String)"CMDLine.Error"));
                            System.exit(1);
                        }
                        cmd_user = st.nextToken();
                        cmd_user_exits = true;
                    }
                    if (st.hasMoreTokens()) {
                        if (cmd_password != null && cmd_password.length() > 0) {
                            System.out.println("Password " + Resources.getString((String)"CMDLine.Error"));
                            System.exit(1);
                        }
                        cmd_password_exits = true;
                        cmd_password = st.nextToken();
                    }
                    i += 2;
                    continue;
                }
                if (args[i].equals(USER)) {
                    if (cmd_user != null && cmd_user.length() > 1) {
                        System.out.println("User " + Resources.getString((String)"CMDLine.Error"));
                        System.exit(1);
                    }
                    cmd_user = args[i + 1];
                    cmd_user_exits = true;
                    i += 2;
                    continue;
                }
                if (args[i].equals(PASSWORD)) {
                    if (cmd_password != null && cmd_password.length() > 0) {
                        System.out.println("Password " + Resources.getString((String)"CMDLine.Error"));
                        System.exit(1);
                    }
                    try {
                        tmp = args[i + 1];
                        if (!tmp.startsWith("-")) {
                            cmd_password = tmp;
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        // empty catch block
                    }
                    if (cmd_password == null || cmd_password.length() < 1) {
                        ++i;
                        cmd_password = PasswordPrompt.getPassword("Database Password:\n");
                    } else {
                        i += 2;
                    }
                    cmd_password_exits = true;
                    continue;
                }
                if (args[i].equals(DB_ENCRYPTION)) {
                    cmd_db_ssl = args[i + 1];
                    cmd_db_ssl_exits = true;
                    i += 2;
                    continue;
                }
                if (args[i].equals(MSG_SERVER)) {
                    cmd_msg_server = args[i + 1];
                    cmd_msg_server_exits = true;
                    i += 2;
                    continue;
                }
                if (args[i].equals(JNDI_SERVER)) {
                    cmd_jndi_server = args[i + 1];
                    cmd_jndi_server_exits = true;
                    i += 2;
                    continue;
                }
                if (args[i].equals(MSG_SERVER_PORT)) {
                    cmd_ms_msg_port = args[i + 1];
                    cmd_ms_msg_port_exits = true;
                    i += 2;
                    continue;
                }
                if (args[i].equals(JNDI_SERVER_PORT)) {
                    cmd_ms_jndi_port = args[i + 1];
                    cmd_ms_jndi_port_exits = true;
                    i += 2;
                    continue;
                }
                if (args[i].equals(MSG_SERVER_ADMIN_PORT)) {
                    cmd_ms_admin_port = args[i + 1];
                    cmd_ms_admin_port_exits = true;
                    i += 2;
                    continue;
                }
                if (args[i].equals(SYNC_SERVICE_ADMIN_PORT)) {
                    cmd_sync_admin_port = args[i + 1];
                    cmd_sync_admin_port_exits = true;
                    i += 2;
                    continue;
                }
                if (args[i].equals(MSG_ENCRYPTION)) {
                    cmd_ms_ssl = args[i + 1];
                    cmd_ms_ssl_exits = true;
                    i += 2;
                    continue;
                }
                if (args[i].equals(SECURITY_PROVIDER)) {
                    cmd_security_provider = args[i + 1];
                    i += 2;
                    continue;
                }
                if (args[i].equals(MSG_SERVER_PASSWORD)) {
                    if (cmd_ms_password != null && cmd_ms_password.length() > 0) {
                        System.out.println("Message Server Password " + Resources.getString((String)"CMDLine.Error"));
                        System.exit(1);
                    }
                    try {
                        tmp = args[i + 1];
                        if (!tmp.startsWith("-")) {
                            cmd_ms_password = tmp;
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    if (cmd_ms_password == null || cmd_ms_password.length() < 1) {
                        ++i;
                        cmd_ms_password = PasswordPrompt.getPassword("Message Server Password:\n");
                    } else {
                        i += 2;
                    }
                    cmd_ms_password_exits = true;
                    continue;
                }
                if (args[i].equals(COMMAND) || args[i].equals("-c")) {
                    cmd_cmd = args[i] + " " + args[i + 1];
                    i += 2;
                    continue;
                }
                if (args[i].equals(HELP1) || args[i].equals(HELP2) || args[i].equals(HELP3)) {
                    SyncManACC.displayCmdHelp();
                    return;
                }
                if (args[i].equals("-no_exit")) {
                    no_exit = true;
                    ++i;
                    continue;
                }
                System.out.println("unknown argument in command line at position " + (i + 1) + ": " + args[i]);
                SyncManACC.displayCmdHelp();
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (cmd_access_key == null || cmd_access_key.length() < 8) {
            System.out.println("Access key needs to be at least 8 characters.");
            System.exit(1);
        }
        try {
            SQLBuilder.createInstance(null);
            m_params = new AccParams(cmd_access_key, cmd_security_provider);
            m_params.loadParameters();
            SyncManACC.getAccessParamsWithCmdLinePrior();
        }
        catch (FileNotFoundException ex) {
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
        try {
            if (cmd_cmd != null) {
                SyncManACC.processCMD(cmd_cmd);
            } else {
                SyncManACC.readCMDInput();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("Exit SyncManACC due to java exception: " + ex.toString());
            m_retCode = 1;
        }
        SQLBuilder.destroyInstance();
        if (!no_exit) {
            System.exit(m_retCode);
        }
    }

    private static void readCMDInput() throws Exception {
        try {
            boolean end = false;
            String s = "";
            BufferedReader stdin = null;
            stdin = new BufferedReader(new InputStreamReader(System.in));
            while (!end) {
                System.out.print(">");
                System.out.flush();
                s = stdin.readLine();
                if (s == null) {
                    stdin.close();
                    return;
                }
                if (s.trim().equalsIgnoreCase(CMD_QUIT1) || s.trim().equalsIgnoreCase(CMD_QUIT2) || s.trim().equalsIgnoreCase(CMD_QUIT3)) {
                    stdin.close();
                    end = true;
                    continue;
                }
                SyncManACC.processCMD(s);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            SQLBuilder.writeProt(ex);
        }
    }

    private static void displayCmdHelp() {
        System.out.println("-access_key     | -A        // access key");
        System.out.println("-database_host  | -n        // host");
        System.out.println("-database_name  | -d        // database");
        System.out.println("-user                       // user");
        System.out.println("-password                   // password");
        System.out.println("-database_encryption ssl    // use a ssl socket");
        System.out.println("-msgserver_host             // message server");
        System.out.println("-msgserver_port             // message server port");
        System.out.println("-jndiserver_host            // jndi server");
        System.out.println("-jndiserver_port            // jndi server port");
        System.out.println("-msgserver_admin_port       // message server admin port");
        System.out.println("-sync_admin_port            // sync service admin port");
        System.out.println("-msgserver_password         // message server password");
        System.out.println("-msgserver_encryption ssl   // use ssl sockets");
        System.out.println("-command                    // command");
        System.out.println("---- Commands: -----");
        System.out.println("list                        // list key entries");
        System.out.println("set                         // set key entries");
        System.out.println("clear                       // delete key entries");
        System.out.println("--------------------");
        System.out.println("-help                       // help");
        System.out.println("-h                          // help");
        System.out.println("-?                          // help");
    }

    private static void processCMD(String completeCMD) throws Exception {
        if (completeCMD.equalsIgnoreCase(CMD_QUIT1) || completeCMD.equalsIgnoreCase(CMD_QUIT2) || completeCMD.equalsIgnoreCase(CMD_QUIT3)) {
            System.exit(0);
        } else if (completeCMD.equalsIgnoreCase(CMD_HELP1) || completeCMD.equalsIgnoreCase(CMD_HELP2) || completeCMD.equalsIgnoreCase(CMD_HELP3)) {
            SyncManACC.displayCmdHelp();
        } else {
            SyncManACC.getParamsFromCMDInput(completeCMD);
        }
    }

    private static void setAccessParams() throws Exception {
        if (cmd_host != null && cmd_host.length() > 0 && cmd_database != null && cmd_database.length() > 0 && cmd_user != null && cmd_user.length() > 0 && cmd_password != null && cmd_password.length() > 0 && cmd_ms_jndi_port != null && cmd_ms_jndi_port.length() > 0 && cmd_ms_msg_port != null && cmd_ms_msg_port.length() > 0) {
            boolean msssl;
            boolean db_ssl;
            m_params.setDBHost(cmd_host);
            m_params.setDBName(cmd_database);
            m_params.setDBUser(cmd_user);
            m_params.setDBPassword(cmd_password);
            boolean bl = db_ssl = cmd_db_ssl != null && cmd_db_ssl.equalsIgnoreCase("ssl");
            if (db_ssl) {
                m_params.setDB_SSL(cmd_db_ssl);
            } else {
                m_params.setDB_SSL("");
            }
            if (cmd_ms_admin_port != null) {
                m_params.setMsgSvrAdminPort(cmd_ms_admin_port);
            } else {
                m_params.setMsgSvrAdminPort("");
            }
            if (cmd_ms_password != null) {
                m_params.setMsgAdminPassword(cmd_ms_password);
            } else {
                m_params.setMsgAdminPassword("");
            }
            if (cmd_msg_server != null) {
                m_params.setMsgServer(cmd_msg_server);
            } else {
                m_params.setMsgServer("");
            }
            boolean bl2 = msssl = cmd_ms_ssl != null && cmd_ms_ssl.equalsIgnoreCase("ssl");
            if (msssl) {
                m_params.setDB_SSL(cmd_ms_ssl);
            } else {
                m_params.setDB_SSL("");
            }
            if (cmd_jndi_server != null) {
                m_params.setJndiServer(cmd_jndi_server);
            } else {
                m_params.setJndiServer("");
            }
            if (cmd_ms_jndi_port != null) {
                m_params.setJndiPort(cmd_ms_jndi_port);
            } else {
                m_params.setJndiPort("");
            }
            if (cmd_ms_msg_port != null) {
                m_params.setMsgPort(cmd_ms_msg_port);
            } else {
                m_params.setMsgPort("");
            }
            if (cmd_sync_admin_port != null) {
                m_params.setSyncAdminPort(cmd_sync_admin_port);
            } else {
                m_params.setSyncAdminPort("");
            }
        } else {
            throw new Exception("Insufficient access parameters. Missing 'host' or 'database' or 'user' or 'password' or 'jndi port' or 'msg server port'");
        }
        m_params.saveParameters(true);
        SQLBuilder.writeProt("Access key written.", false);
    }

    private static void getAccessParamsWithCmdLinePrior() throws Exception {
        if (!cmd_host_exits) {
            cmd_host = m_params.getDBHost();
        }
        if (!cmd_database_exits) {
            cmd_database = m_params.getDBName();
        }
        if (!cmd_user_exits) {
            cmd_user = m_params.getDBUser();
        }
        if (!cmd_password_exits) {
            cmd_password = m_params.getDBPassword();
        }
        if (!cmd_db_ssl_exits) {
            cmd_db_ssl = m_params.getDB_SSL();
        }
        if (!cmd_ms_admin_port_exits) {
            cmd_ms_admin_port = m_params.getMsgSvrAdminPort();
        }
        if (!cmd_ms_password_exits) {
            cmd_ms_password = m_params.getMsgAdminPassword();
        }
        if (!cmd_msg_server_exits) {
            cmd_msg_server = m_params.getMsgServer();
        }
        if (!cmd_ms_ssl_exits) {
            cmd_ms_ssl = m_params.getDB_SSL();
        }
        if (!cmd_jndi_server_exits) {
            cmd_jndi_server = m_params.getJndiServer();
        }
        if (!cmd_ms_jndi_port_exits) {
            cmd_ms_jndi_port = m_params.getJndiPort();
        }
        if (!cmd_ms_msg_port_exits) {
            cmd_ms_msg_port = m_params.getMsgPort();
        }
        if (!cmd_sync_admin_port_exits) {
            cmd_sync_admin_port = m_params.getSyncAdminPort();
        }
    }

    private static void getAccessParams() throws Exception {
        cmd_host = m_params.getDBHost();
        cmd_database = m_params.getDBName();
        cmd_user = m_params.getDBUser();
        cmd_password = m_params.getDBPassword();
        cmd_db_ssl = m_params.getDB_SSL();
        cmd_ms_admin_port = m_params.getMsgSvrAdminPort();
        cmd_ms_password = m_params.getMsgAdminPassword();
        cmd_msg_server = m_params.getMsgServer();
        cmd_ms_ssl = m_params.getDB_SSL();
        cmd_jndi_server = m_params.getJndiServer();
        cmd_ms_jndi_port = m_params.getJndiPort();
        cmd_ms_msg_port = m_params.getMsgPort();
        cmd_sync_admin_port = m_params.getSyncAdminPort();
    }

    private static void getParamsFromCMDInput(String completeCMD) throws Exception {
        SyncManTokenizer st = new SyncManTokenizer(completeCMD.toCharArray());
        String cmd = st.nextWordToken();
        if (cmd == null) {
            return;
        }
        if (cmd.equalsIgnoreCase("-")) {
            cmd = cmd + st.nextWordToken();
        }
        if (cmd.equals("-n") || cmd.equals(DB_HOST)) {
            cmd_host = st.nextWordToken();
            m_params.setDBHost(cmd_host == null ? "127.0.0.1" : cmd_host);
        } else if (cmd.equals(COMMAND) || cmd.equals("-c")) {
            cmd_cmd = st.nextWordToken();
            if (cmd_cmd.equalsIgnoreCase(CMD_CLEAR)) {
                m_params.deleteParams();
                m_params.saveParameters(false);
                SyncManACC.getAccessParams();
                System.out.println("Access key deleted.");
            } else if (cmd_cmd.equalsIgnoreCase(CMD_EXISTS)) {
                if (m_params.containsKey(cmd_access_key)) {
                    System.out.println("Access key " + cmd_access_key + " exists.");
                    m_retCode = 0;
                } else {
                    System.out.println("Access key " + cmd_access_key + " does not exist.");
                    m_retCode = 1;
                }
            } else if (cmd_cmd.equalsIgnoreCase(CMD_LIST)) {
                if (!m_params.containsKey(cmd_access_key)) {
                    System.out.println("Access key " + cmd_access_key + " does not exist.");
                    m_retCode = 1;
                    return;
                }
                SQLBuilder.writeProt("Access Key:                " + cmd_access_key, false);
                SQLBuilder.writeProt("Database Host:             " + m_params.getDBHost(), false);
                SQLBuilder.writeProt("Database Name:             " + m_params.getDBName(), false);
                SQLBuilder.writeProt("Database User:             " + m_params.getDBUser(), false);
                SQLBuilder.writeProt("Database Password:         **********", false);
                SQLBuilder.writeProt("Database Secure:           " + m_params.getDB_SSL(), false);
                SQLBuilder.writeProt("Message Server Host:       " + m_params.getMsgServer(), false);
                SQLBuilder.writeProt("Message Server Port:       " + m_params.getMsgPort(), false);
                SQLBuilder.writeProt("Jndi Server Host:          " + m_params.getJndiServer(), false);
                SQLBuilder.writeProt("Jndi Server Port:          " + m_params.getJndiPort(), false);
                SQLBuilder.writeProt("Message Server Admin Port: " + m_params.getMsgSvrAdminPort(), false);
                SQLBuilder.writeProt("Message Server Password:   **********", false);
                SQLBuilder.writeProt("Message Server Secure:     " + m_params.getMsg_SSL(), false);
                SQLBuilder.writeProt("Sync Service Admin Port:   " + m_params.getSyncAdminPort(), false);
            } else if (cmd_cmd.equalsIgnoreCase(CMD_SET)) {
                SyncManACC.setAccessParams();
            } else {
                System.out.println("unknown command : " + cmd_cmd);
                m_retCode = 1;
            }
        } else if (cmd.equals("-d") || cmd.equals(DB_NAME)) {
            cmd_database = st.nextWordToken();
            m_params.setDBName(cmd_database);
        } else if (cmd.equals("-u")) {
            try {
                cmd_user = st.nextWordToken();
            }
            catch (NoSuchElementException ex) {
                // empty catch block
            }
            m_params.setDBUser(cmd_user);
            cmd_password = null;
            try {
                cmd_password = st.nextWordToken();
            }
            catch (NoSuchElementException ex) {
                // empty catch block
            }
            if (cmd_password == null || cmd_password.length() < 1) {
                cmd_password = PasswordPrompt.getPassword("Password:\n");
            }
            m_params.setDBPassword(cmd_password);
        } else if (cmd.equals(USER)) {
            cmd_user = st.nextWordToken();
            m_params.setDBUser(cmd_user);
        } else if (cmd.equals(PASSWORD)) {
            cmd_password = null;
            try {
                cmd_password = st.nextWordToken();
            }
            catch (NoSuchElementException ex) {
                // empty catch block
            }
            if (cmd_password == null || cmd_password.length() < 1) {
                cmd_password = PasswordPrompt.getPassword("Password:\n");
            }
            m_params.setDBPassword(cmd_password);
        } else if (cmd.equals(DB_ENCRYPTION)) {
            boolean db_ssl;
            cmd_db_ssl = st.nextWordToken();
            boolean bl = db_ssl = cmd_db_ssl != null && cmd_db_ssl.equalsIgnoreCase("ssl");
            if (db_ssl) {
                m_params.setDB_SSL(cmd_db_ssl);
            } else {
                m_params.setDB_SSL("");
            }
        } else if (cmd.equals(MSG_SERVER)) {
            cmd_msg_server = st.nextWordToken();
            m_params.setMsgServer(cmd_msg_server);
        } else if (cmd.equals(JNDI_SERVER)) {
            cmd_jndi_server = st.nextWordToken();
            m_params.setJndiServer(cmd_ms_msg_port);
        } else if (cmd.equals(MSG_SERVER_PORT)) {
            cmd_ms_msg_port = st.nextWordToken();
            m_params.setMsgPort(cmd_ms_msg_port);
        } else if (cmd.equals(JNDI_SERVER_PORT)) {
            cmd_ms_jndi_port = st.nextWordToken();
            m_params.setJndiPort(cmd_ms_jndi_port);
        } else if (cmd.equals(MSG_SERVER_ADMIN_PORT)) {
            cmd_ms_admin_port = st.nextWordToken();
            m_params.setMsgSvrAdminPort(cmd_ms_admin_port);
        } else if (cmd.equals(SYNC_SERVICE_ADMIN_PORT)) {
            cmd_sync_admin_port = st.nextWordToken();
            m_params.setSyncAdminPort(cmd_sync_admin_port);
        } else if (cmd.equals(MSG_ENCRYPTION)) {
            boolean msssl;
            cmd_ms_ssl = st.nextWordToken();
            boolean bl = msssl = cmd_ms_ssl != null && cmd_ms_ssl.equalsIgnoreCase("ssl");
            if (msssl) {
                m_params.setDB_SSL(cmd_ms_ssl);
            } else {
                m_params.setDB_SSL("");
            }
        } else if (cmd.equals(MSG_SERVER_PASSWORD)) {
            cmd_ms_password = null;
            try {
                cmd_ms_password = st.nextWordToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            if (cmd_ms_password == null || cmd_ms_password.length() < 1) {
                cmd_ms_password = PasswordPrompt.getPassword("Password:\n");
            }
            m_params.setMsgAdminPassword(cmd_ms_password);
        } else {
            System.out.println("unknown argument : " + cmd);
            m_retCode = 1;
        }
    }
}

