/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.design;

import com.sap.sdb.programmargs.Convert;
import com.sap.sdb.syncMan.design.Column;
import com.sap.sdb.syncMan.design.ColumnGroup;
import com.sap.sdb.syncMan.design.DataBaseNode;
import com.sap.sdb.syncMan.design.InstalledRepTable;
import com.sap.sdb.syncMan.design.Participant;
import com.sap.sdb.syncMan.design.ParticipantConfig;
import com.sap.sdb.syncMan.design.ReplicationTable;
import com.sap.sdb.syncMan.design.SchemaNode;
import com.sap.sdb.syncMan.design.UnitTable;
import com.sap.sdb.syncMan.message.SyncManMessage;
import com.sap.sdb.syncMan.tool.ConDataBase;
import com.sap.sdb.syncMan.tool.ConMessageServer;
import com.sap.sdb.syncMan.tool.Resources;
import com.sap.sdb.syncMan.util.ColumnDesc;
import com.sap.sdb.syncMan.util.GenUID;
import com.sap.sdb.syncMan.util.SQLBuilder;
import com.sap.sdb.syncMan.util.SQLNames;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;

public class DesignSQLLayer
implements SQLNames {
    private static final String LINE_SEP = System.getProperty("line.separator");

    private DesignSQLLayer() {
    }

    public static boolean existsMasterParticipantName(ConDataBase dbCon, String participantName) throws SQLException {
        boolean ret = false;
        String SQL = "select PARTICIPANT_ID from " + dbCon.buildTableQualifier("RD_PARTICIPANT") + " where IS_MASTER = 1 and PARTICIPANT_NAME=?";
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        stmt.setString(1, participantName);
        ResultSet result = stmt.executeQuery();
        if (result.next()) {
            ret = true;
        }
        result.close();
        return ret;
    }

    public static void insertParticipantConfig(ConDataBase dbCon, ParticipantConfig config) throws SQLException {
        String SQL = "insert into " + dbCon.buildTableQualifier("RD_PARTICIPANT_CONFIG") + " values (?,?,?,?)";
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        stmt.setString(1, config.getHost());
        stmt.setString(2, config.getDataBase());
        stmt.setBoolean(3, config.getUseSSL());
        stmt.setString(4, config.jdbcDriver());
        stmt.execute();
    }

    public static void insertParticipantConfigWithCheck(ConDataBase dbCon, ParticipantConfig config) throws SQLException {
        ParticipantConfig test = DesignSQLLayer.selectParticipantConfig(dbCon, config.getHost(), config.getDataBase());
        if (test == null) {
            DesignSQLLayer.insertParticipantConfig(dbCon, config);
        }
    }

    public static void alterParticipantConfig(ConDataBase dbCon, ParticipantConfig config) throws SQLException {
        String SQL = "update " + dbCon.buildTableQualifier("RD_PARTICIPANT_CONFIG") + " set USE_SSL=?,JDBC_DRIVER=? " + "where SERVER_NODE=? and DATA_BASE=?";
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        stmt.setBoolean(1, config.getUseSSL());
        stmt.setString(2, config.jdbcDriver());
        stmt.setString(3, config.getHost());
        stmt.setString(4, config.getDataBase());
        stmt.execute();
    }

    public static int deleteParticipantConfig(ConDataBase dbCon, String server, String database) throws SQLException {
        boolean exists = DesignSQLLayer.existsUnitNode(dbCon, server, database);
        if (!exists) {
            String SQL = "delete from " + dbCon.buildTableQualifier("RD_PARTICIPANT_CONFIG") + "where SERVER_NODE=? and DATA_BASE=?";
            PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
            stmt.setString(1, server);
            stmt.setString(2, database);
            return stmt.executeUpdate();
        }
        return -1;
    }

    public static Vector selectRepTables(ConDataBase dbCon, SchemaNode schema, String filter) throws SQLException {
        Vector<ReplicationTable> tables = new Vector<ReplicationTable>();
        String SQL = "select REP_TABLE_ID,REP_TABLE_NAME from " + dbCon.buildTableQualifier("RD_REP_TABLE") + "where REP_TABLE_SCHEMA =?" + " and REP_TABLE_NAME like '" + filter + "'" + " order by REP_TABLE_NAME asc ";
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        stmt.setString(1, schema.toString());
        ResultSet result = stmt.executeQuery();
        while (result.next()) {
            long tableID = result.getLong(1);
            String name = result.getString(2);
            ReplicationTable table = new ReplicationTable(tableID, schema.getParent().getParent().toString(), schema.getParent().toString(), schema.toString(), name);
            table.setParent(schema);
            tables.add(table);
        }
        result.close();
        return tables;
    }

    public static ReplicationTable selectRepTable(ConDataBase dbCon, String server, String database, String schema, String table) throws SQLException {
        ReplicationTable repTable = null;
        String SQL = "select REP_TABLE_ID from " + dbCon.buildTableQualifier("RD_REP_TABLE") + "where REP_TABLE_SERVER = ? and REP_TABLE_DATABASE =? and REP_TABLE_SCHEMA =?" + " and REP_TABLE_NAME = ?";
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        stmt.setString(1, server);
        stmt.setString(2, database);
        stmt.setString(3, schema);
        stmt.setString(4, table);
        ResultSet result = stmt.executeQuery();
        if (result.next()) {
            long tableID = result.getLong(1);
            repTable = new ReplicationTable(tableID, server, database, schema, table);
        }
        result.close();
        return repTable;
    }

    public static Vector selectRepTableSchema(ConDataBase dbCon, DataBaseNode db) throws SQLException {
        Vector<SchemaNode> schemas = new Vector<SchemaNode>();
        String SQL = "select distinct REP_TABLE_SCHEMA from " + dbCon.buildTableQualifier("RD_REP_TABLE") + " order by REP_TABLE_SCHEMA asc";
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        ResultSet result = stmt.executeQuery();
        while (result.next()) {
            String schema = result.getString(1);
            SchemaNode node = new SchemaNode(db, schema);
            schemas.add(node);
        }
        result.close();
        return schemas;
    }

    public static Vector selectColumnGroupsOfTable(ConDataBase dbCon, long participantID, long tableID) throws Exception {
        ColumnGroup cg;
        boolean forReplication;
        boolean versioned;
        boolean keyCols;
        String columnGroupName;
        long columnGroupID;
        Vector<ColumnGroup> cgs = new Vector<ColumnGroup>();
        String SQL = "select COLUMN_GROUP_ID,COLUMN_GROUP_NAME,HAS_KEYCOLS,IS_VERSIONED,FOR_REPLICATION from " + dbCon.buildTableQualifier("RD_TABLE_COLUMN_GROUP") + " where PARTICIPANT_ID=? " + " and TABLE_ID =?" + " and COLUMN_GROUP_ID ='" + -2 + "'";
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        DesignSQLLayer.setNumericParam(1, stmt, dbCon, participantID);
        DesignSQLLayer.setNumericParam(2, stmt, dbCon, tableID);
        ResultSet result = stmt.executeQuery();
        while (result.next()) {
            columnGroupID = result.getLong(1);
            columnGroupName = result.getString(2);
            keyCols = result.getBoolean(3);
            versioned = result.getBoolean(4);
            forReplication = result.getBoolean(5);
            cg = new ColumnGroup(columnGroupName, columnGroupID);
            cg.setForReplication(forReplication);
            cg.setVersioned(versioned);
            cg.setKeyCols(keyCols);
            cgs.add(cg);
            DesignSQLLayer.selectColumnsOfColumnGroup(dbCon, participantID, tableID, cg);
        }
        result.close();
        SQL = "select COLUMN_GROUP_ID,COLUMN_GROUP_NAME,HAS_KEYCOLS,IS_VERSIONED,FOR_REPLICATION,COLUMN_GROUP_NAME from " + dbCon.buildTableQualifier("RD_TABLE_COLUMN_GROUP") + " where PARTICIPANT_ID=? " + " and TABLE_ID =?" + " and COLUMN_GROUP_ID !='" + -2 + "'" + " order by UPPER(COLUMN_GROUP_NAME) asc ";
        stmt = dbCon.getConnection().prepareStatement(SQL);
        DesignSQLLayer.setNumericParam(1, stmt, dbCon, participantID);
        DesignSQLLayer.setNumericParam(2, stmt, dbCon, tableID);
        result = stmt.executeQuery();
        while (result.next()) {
            columnGroupID = result.getLong(1);
            columnGroupName = result.getString(2);
            keyCols = result.getBoolean(3);
            versioned = result.getBoolean(4);
            forReplication = result.getBoolean(5);
            cg = new ColumnGroup(columnGroupName, columnGroupID);
            cg.setForReplication(forReplication);
            cg.setVersioned(versioned);
            cg.setKeyCols(keyCols);
            cgs.add(cg);
            DesignSQLLayer.selectColumnsOfColumnGroup(dbCon, participantID, tableID, cg);
        }
        result.close();
        return cgs;
    }

    public static ColumnDesc isColumnForAnyReplication(ConDataBase dbCon, UnitTable table, Column col) throws Exception {
        long columnGroupID = -1L;
        boolean forReplication = false;
        boolean isVersioned = false;
        String SQL = "select for_replication,is_versioned from " + dbCon.buildTableQualifier("RD_TABLE_COLUMN_GROUP") + " where TABLE_ID <>?" + " and FOR_REPLICATION = '1'" + " and COLUMN_GROUP_ID in (" + "select COLUMN_GROUP_ID from " + dbCon.buildTableQualifier("RD_TABLE_COLUMN") + " where TABLE_ID <> ?" + " and COLUMN_ID =?)";
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        DesignSQLLayer.setNumericParam(1, stmt, dbCon, table.getRepTableID());
        DesignSQLLayer.setNumericParam(2, stmt, dbCon, table.getRepTableID());
        DesignSQLLayer.setNumericParam(3, stmt, dbCon, col.columnID());
        ResultSet result = stmt.executeQuery();
        while (result.next()) {
            forReplication = result.getBoolean(1);
            isVersioned = result.getBoolean(2);
            if (!forReplication) continue;
        }
        result.close();
        if (forReplication) {
            return new ColumnDesc(col.columnName(), col.columnID(), columnGroupID, col.sqlType(), col.typeName(), col.precision(), col.scale(), col.pos(), col.keyPos(), isVersioned, col.constraintType(), col.constraintValue1(), col.constraintValue2());
        }
        return null;
    }

    private static void selectColumnsOfColumnGroup(ConDataBase dbCon, long participantID, long tableID, ColumnGroup cg) throws Exception {
        String SQL = "select COLUMN_ID,COLUMN_NAME,SQL_TYPE,TYPE_NAME,COL_PRECISION,SCALE,POS,KEY_POS,CONSTRAINT_TYPE,CONSTRAINT_VALUE1,CONSTRAINT_VALUE2,COLUMN_GROUP_ID from " + dbCon.buildTableQualifier("RD_TABLE_COLUMN") + " where " + "PARTICIPANT_ID" + "=? and " + "TABLE_ID" + "=? and " + "COLUMN_GROUP_ID" + "=? " + "order by " + "POS" + "," + "COLUMN_GROUP_ID" + " asc ";
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        DesignSQLLayer.setNumericParam(1, stmt, dbCon, participantID);
        DesignSQLLayer.setNumericParam(2, stmt, dbCon, tableID);
        DesignSQLLayer.setNumericParam(3, stmt, dbCon, cg.columnGroupID());
        ResultSet result = stmt.executeQuery();
        while (result.next()) {
            long columnID = result.getLong(1);
            String columnName = result.getString(2);
            int sqlType = result.getInt(3);
            String typeName = result.getString(4);
            int precision = result.getInt(5);
            int scale = result.getInt(6);
            int pos = result.getInt(7);
            int keyPos = result.getInt(8);
            int constraintType = result.getInt(9);
            String constraintValue1 = result.getString(10);
            String constraintValue2 = result.getString(11);
            Column col = new Column(columnID, columnName, sqlType, typeName, precision, scale, pos, keyPos, constraintType, constraintValue1, constraintValue2);
            cg.addColumn(col);
        }
        result.close();
    }

    private static void alterClientCount(ConDataBase dbCon, long clientCount, long participantID) throws SQLException {
        String UPDATE_UNIT = "update " + dbCon.buildTableQualifier("REPLICATION_UNITS") + " set INSTALLED_CLIENTS=? " + "where UNIT_ID=? and IS_MASTER=1";
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(UPDATE_UNIT);
        DesignSQLLayer.setNumericParam(1, stmt, dbCon, clientCount);
        DesignSQLLayer.setNumericParam(2, stmt, dbCon, participantID);
        stmt.executeUpdate();
    }

    public static void alterColumn(ConDataBase dbCon, long participantID, long tableID, Column col) throws Exception {
        String SQL = "UPDATE " + dbCon.buildTableQualifier("RD_TABLE_COLUMN") + " set COLUMN_NAME=?,CONSTRAINT_TYPE=?,CONSTRAINT_VALUE1=?,CONSTRAINT_VALUE2=?" + " where PARTICIPANT_ID=? and TABLE_ID=? and COLUMN_ID=?";
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        stmt.setString(1, col.columnName());
        stmt.setInt(2, col.constraintType());
        stmt.setString(3, col.constraintValue1());
        stmt.setString(4, col.constraintValue2());
        DesignSQLLayer.setNumericParam(5, stmt, dbCon, participantID);
        DesignSQLLayer.setNumericParam(6, stmt, dbCon, tableID);
        DesignSQLLayer.setNumericParam(7, stmt, dbCon, col.columnID());
        int result = stmt.executeUpdate();
        if (result != 1) {
            throw new SQLException(result + " column updated.");
        }
    }

    public static Vector selectColumnsOfUnitTable(ConDataBase dbCon, long participantID, long tableID, boolean forReplication) throws Exception {
        String temp = "0";
        if (forReplication) {
            temp = "1";
        }
        String SQL = "select COLUMN_ID,COLUMN_NAME,SQL_TYPE,TYPE_NAME,COL_PRECISION,SCALE,POS,KEY_POS,CONSTRAINT_TYPE,CONSTRAINT_VALUE1,CONSTRAINT_VALUE2 from " + dbCon.buildTableQualifier("RD_TABLE_COLUMN") + ", " + dbCon.buildTableQualifier("RD_TABLE_COLUMN_GROUP") + " " + " where RD_TABLE_COLUMN.PARTICIPANT_ID=? " + "AND " + dbCon.buildTableQualifier("RD_TABLE_COLUMN") + ".TABLE_ID=? " + "AND " + dbCon.buildTableQualifier("RD_TABLE_COLUMN_GROUP") + ".PARTICIPANT_ID=? " + "AND " + dbCon.buildTableQualifier("RD_TABLE_COLUMN_GROUP") + ".TABLE_ID=? " + "AND " + dbCon.buildTableQualifier("RD_TABLE_COLUMN") + ".COLUMN_GROUP_ID=" + dbCon.buildTableQualifier("RD_TABLE_COLUMN_GROUP") + ".COLUMN_GROUP_ID" + " AND " + dbCon.buildTableQualifier("RD_TABLE_COLUMN_GROUP") + ".FOR_REPLICATION=" + temp + " order by POS asc ";
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        DesignSQLLayer.setNumericParam(1, stmt, dbCon, participantID);
        DesignSQLLayer.setNumericParam(2, stmt, dbCon, tableID);
        DesignSQLLayer.setNumericParam(3, stmt, dbCon, participantID);
        DesignSQLLayer.setNumericParam(4, stmt, dbCon, tableID);
        ResultSet result = stmt.executeQuery();
        Vector<Column> cols = new Vector<Column>();
        while (result.next()) {
            long columnID = result.getLong(1);
            String columnName = result.getString(2);
            int sqlType = result.getInt(3);
            String typeName = result.getString(4);
            int precision = result.getInt(5);
            int scale = result.getInt(6);
            int pos = result.getInt(7);
            int keyPos = result.getInt(8);
            int constraintType = result.getInt(9);
            String constraintValue1 = result.getString(10);
            String constraintValue2 = result.getString(11);
            Column col = new Column(columnID, columnName, sqlType, typeName, precision, scale, pos, keyPos, constraintType, constraintValue1, constraintValue2);
            cols.add(col);
        }
        result.close();
        return cols;
    }

    public static Vector selectParticipantConfigs(ConDataBase dbCon) throws SQLException {
        String SQL = "select SERVER_NODE,DATA_BASE,USE_SSL,JDBC_DRIVER from " + dbCon.buildTableQualifier("RD_PARTICIPANT_CONFIG") + " order by SERVER_NODE,DATA_BASE asc ";
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        ResultSet result = stmt.executeQuery();
        Vector<ParticipantConfig> participants = new Vector<ParticipantConfig>();
        while (result.next()) {
            String host = result.getString(1);
            String database = result.getString(2);
            boolean useSSL = result.getBoolean(3);
            String jdbcDriver = result.getString(4);
            ParticipantConfig part = new ParticipantConfig(host, database, useSSL, jdbcDriver);
            participants.add(part);
        }
        result.close();
        return participants;
    }

    public static boolean existsUnitNode(ConDataBase dbCon, String server, String database) throws SQLException {
        String SQL = "select 1 from " + dbCon.buildTableQualifier("RD_PARTICIPANT") + " where SERVER_NODE=? and DATA_BASE=? ";
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        stmt.setString(1, server);
        stmt.setString(2, database);
        ResultSet result = stmt.executeQuery();
        if (result == null) {
            return false;
        }
        if (result.next()) {
            result.close();
            return true;
        }
        result.close();
        return false;
    }

    public static long selectClientUnitCount(ConDataBase dbCon) throws SQLException {
        long count = 0L;
        String SQL = "select count(*) from " + dbCon.buildTableQualifier("REPLICATION_UNITS");
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        ResultSet result = stmt.executeQuery();
        if (result == null) {
            return -1L;
        }
        if (result.next()) {
            count = result.getLong(1);
        }
        result.close();
        return count;
    }

    public static long selectInstalledClientCount(ConDataBase dbCon, long designID) throws SQLException {
        long count = 0L;
        String SQL = "select count(*) from " + dbCon.buildTableQualifier("RD_PARTICIPANT") + " where design_id =? and IS_MASTER = 0 and IS_INSTALLED=1";
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        DesignSQLLayer.setNumericParam(1, stmt, dbCon, designID);
        ResultSet result = stmt.executeQuery();
        if (result == null) {
            return -1L;
        }
        if (result.next()) {
            count = result.getLong(1);
        }
        result.close();
        return count;
    }

    public static String[] selectMsgDestPasswords(ConDataBase dbCon, long destID, boolean isQueueDest) throws SQLException {
        String SQL = "select RD_DEST_READ_PASS,RD_DEST_WRITE_PASS from " + dbCon.buildTableQualifier("RD_PARTICIPANT_AUTH") + " where " + "DESIGN_ID" + "=? and " + "RD_DEST_IS_QUEUE" + "=?";
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        stmt.setLong(1, destID);
        stmt.setBoolean(2, isQueueDest);
        ResultSet result = stmt.executeQuery();
        if (result == null) {
            return null;
        }
        if (result.next()) {
            String[] ret = new String[]{result.getString(1), result.getString(2)};
            result.close();
            return ret;
        }
        result.close();
        return null;
    }

    public static String selectTheOneAnyOnlyMsgDestWritePass(ConDataBase dbCon) throws SQLException {
        String SQL = "select RD_DEST_WRITE_PASS from " + dbCon.buildTableQualifier("RD_PARTICIPANT_AUTH");
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        ResultSet result = stmt.executeQuery();
        if (result == null) {
            return null;
        }
        if (result.next()) {
            String ret = result.getString(1);
            result.close();
            return ret;
        }
        result.close();
        return null;
    }

    public static ParticipantConfig selectParticipantConfig(ConDataBase dbCon, String server, String database) throws SQLException {
        ParticipantConfig part = null;
        String SQL = "select USE_SSL,JDBC_DRIVER from " + dbCon.buildTableQualifier("RD_PARTICIPANT_CONFIG") + " where SERVER_NODE=? and DATA_BASE=?";
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        stmt.setString(1, server);
        stmt.setString(2, database);
        ResultSet result = stmt.executeQuery();
        if (result.next()) {
            boolean useSSL = result.getBoolean(1);
            String jdbcDriver = result.getString(2);
            part = new ParticipantConfig(server, database, useSSL, jdbcDriver);
        }
        result.close();
        return part;
    }

    public static Vector selectParticipants(ConDataBase dbCon, long designID, boolean master, boolean clients) throws SQLException {
        ResultSet result;
        if (!master && !clients) {
            throw new SQLException("At least master or client unit has to be selected");
        }
        Vector<Participant> parts = new Vector<Participant>();
        String SQL = "select DESIGN_ID,PARTICIPANT_ID,PARTICIPANT_NAME,PARTICIPANT_TYPE,SERVER_NODE,DATA_BASE,REP_USER,REP_PASSWORD,IS_MASTER,IS_INSTALLED from " + dbCon.buildTableQualifier("RD_PARTICIPANT");
        if (designID > 0L) {
            SQL = SQL + " where DESIGN_ID=? ";
        }
        if (master && !clients || !master && clients) {
            SQL = designID > 0L ? SQL + "and" : SQL + " where";
            SQL = SQL + " IS_MASTER=?";
        }
        SQL = SQL + " order by IS_MASTER desc, PARTICIPANT_NAME,SERVER_NODE,DATA_BASE asc ";
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        if (designID > 0L) {
            DesignSQLLayer.setNumericParam(1, stmt, dbCon, designID);
        }
        if (master && !clients || !master && clients) {
            if (designID > 0L) {
                stmt.setBoolean(2, master);
            } else {
                stmt.setBoolean(1, master);
            }
        }
        if ((result = stmt.executeQuery()) == null) {
            return parts;
        }
        while (result.next()) {
            long newDesignID = result.getLong(1);
            long unitID = result.getLong(2);
            String unitName = result.getString(3);
            int unitType = result.getInt(4);
            String host = result.getString(5);
            String database = result.getString(6);
            String cRepUser = result.getString(7);
            String repUser = "";
            String cRepPassword = result.getString(8);
            String repPassword = "";
            try {
                repPassword = dbCon.getCryptObject().decrypt(cRepPassword);
                repUser = dbCon.getCryptObject().decrypt(cRepUser);
            }
            catch (Exception ex) {
                throw new SQLException(ex.toString());
            }
            boolean isMaster = result.getBoolean(9);
            boolean isInstalled = result.getBoolean(10);
            Participant part = new Participant(newDesignID, unitID, unitName, unitType, host, database, repUser, repPassword, isMaster, isInstalled);
            parts.add(part);
        }
        result.close();
        return parts;
    }

    public static Participant selectMasterParticipantByName(ConDataBase dbCon, String unitName) throws SQLException {
        String SQL = "select DESIGN_ID,PARTICIPANT_ID,PARTICIPANT_TYPE,SERVER_NODE,DATA_BASE,REP_USER,REP_PASSWORD,IS_INSTALLED from " + dbCon.buildTableQualifier("RD_PARTICIPANT") + " where IS_MASTER=1 and PARTICIPANT_NAME = ?";
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        stmt.setString(1, unitName);
        ResultSet result = stmt.executeQuery();
        if (result == null) {
            return null;
        }
        if (result.next()) {
            long newDesignID = result.getLong(1);
            long unitID = result.getLong(2);
            int unitType = result.getInt(3);
            String host = result.getString(4);
            String database = result.getString(5);
            String cRepUser = result.getString(6);
            String repUser = "";
            String cRepPassword = result.getString(7);
            String repPassword = "";
            try {
                repPassword = dbCon.getCryptObject().decrypt(cRepPassword);
                repUser = dbCon.getCryptObject().decrypt(cRepUser);
            }
            catch (Exception ex) {
                throw new SQLException(ex.toString());
            }
            boolean isInstalled = result.getBoolean(8);
            Participant part = new Participant(newDesignID, unitID, unitName, unitType, host, database, repUser, repPassword, true, isInstalled);
            result.close();
            return part;
        }
        result.close();
        return null;
    }

    public static Participant selectClientParticipantByName(ConDataBase dbCon, String unitName, long designID) throws SQLException {
        String SQL = "select PARTICIPANT_ID,PARTICIPANT_TYPE,SERVER_NODE,DATA_BASE,REP_USER,REP_PASSWORD,IS_INSTALLED from " + dbCon.buildTableQualifier("RD_PARTICIPANT") + " where IS_MASTER=0 and DESIGN_ID=? and PARTICIPANT_NAME = ?";
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        stmt.setLong(1, designID);
        stmt.setString(2, unitName);
        ResultSet result = stmt.executeQuery();
        if (result == null) {
            return null;
        }
        if (result.next()) {
            long unitID = result.getLong(1);
            int unitType = result.getInt(2);
            String host = result.getString(3);
            String database = result.getString(4);
            String cRepUser = result.getString(5);
            String repUser = "";
            String cRepPassword = result.getString(6);
            String repPassword = "";
            try {
                repPassword = dbCon.getCryptObject().decrypt(cRepPassword);
                repUser = dbCon.getCryptObject().decrypt(cRepUser);
            }
            catch (Exception ex) {
                throw new SQLException(ex.toString());
            }
            boolean isInstalled = result.getBoolean(7);
            Participant part = new Participant(designID, unitID, unitName, unitType, host, database, repUser, repPassword, true, isInstalled);
            result.close();
            return part;
        }
        result.close();
        return null;
    }

    public static Participant selectParticipant(ConDataBase dbCon, long participantID) throws SQLException {
        Participant part = null;
        String SQL = "select DESIGN_ID,PARTICIPANT_NAME,PARTICIPANT_TYPE,SERVER_NODE,DATA_BASE,REP_USER,REP_PASSWORD,IS_MASTER,IS_INSTALLED from " + dbCon.buildTableQualifier("RD_PARTICIPANT") + " where PARTICIPANT_ID=? ";
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        DesignSQLLayer.setNumericParam(1, stmt, dbCon, participantID);
        ResultSet result = stmt.executeQuery();
        if (result == null) {
            return part;
        }
        while (result.next()) {
            long designID = result.getLong(1);
            String unitName = result.getString(2);
            int unitType = result.getInt(3);
            String host = result.getString(4);
            String database = result.getString(5);
            String cRepUser = result.getString(6);
            String repUser = "";
            String cRepPassword = result.getString(7);
            String repPassword = "";
            try {
                repPassword = dbCon.getCryptObject().decrypt(cRepPassword);
                repUser = dbCon.getCryptObject().decrypt(cRepUser);
            }
            catch (Exception ex) {
                throw new SQLException(ex.toString());
            }
            boolean isMaster = result.getBoolean(8);
            boolean isInstalled = result.getBoolean(9);
            part = new Participant(designID, participantID, unitName, unitType, host, database, repUser, repPassword, isMaster, isInstalled);
        }
        result.close();
        return part;
    }

    public static long selectNumberOfInstalledParticipants(ConDataBase dbCon, long designID) throws SQLException {
        long count = -1L;
        String SQL = "select count(*) from " + dbCon.buildTableQualifier("RD_PARTICIPANT") + " where DESIGN_ID=? and IS_INSTALLED=1";
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        DesignSQLLayer.setNumericParam(1, stmt, dbCon, designID);
        ResultSet result = stmt.executeQuery();
        if (result == null) {
            return count;
        }
        if (result.next()) {
            count = result.getLong(1);
        }
        result.close();
        return count;
    }

    public static Vector selectUnitTables(ConDataBase dbCon, long designID, long participantID) throws SQLException {
        String SQL = "select REP_TABLE_ID,TABLE_ID,TABLE_SERVER,TABLE_DATABASE,TABLE_SCHEMA,TABLE_NAME,IS_MASTER_TABLE from " + dbCon.buildTableQualifier("RD_PARTICIPANT_TABLE") + " where DESIGN_ID=? and PARTICIPANT_ID=?";
        Vector<UnitTable> tables = new Vector<UnitTable>();
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        DesignSQLLayer.setNumericParam(1, stmt, dbCon, designID);
        DesignSQLLayer.setNumericParam(2, stmt, dbCon, participantID);
        ResultSet result = stmt.executeQuery();
        if (result == null) {
            return tables;
        }
        while (result.next()) {
            long repTableID = result.getLong(1);
            long tableID = result.getLong(2);
            String server = result.getString(3);
            String database = result.getString(4);
            String schema = result.getString(5);
            String name = result.getString(6);
            boolean isMasterTab = result.getBoolean(7);
            UnitTable table = new UnitTable(designID, participantID, repTableID, tableID, server, database, schema, name, isMasterTab);
            tables.add(table);
        }
        result.close();
        return tables;
    }

    public static UnitTable selectUnitTable(ConDataBase dbCon, long designID, long participantID, String schema, String table) throws SQLException {
        String SQL = "select REP_TABLE_ID,TABLE_ID,TABLE_SERVER,TABLE_DATABASE,IS_MASTER_TABLE from " + dbCon.buildTableQualifier("RD_PARTICIPANT_TABLE") + " where DESIGN_ID=? and PARTICIPANT_ID=? and TABLE_SCHEMA=? and TABLE_NAME=?";
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        stmt.setString(1, Long.toString(designID));
        stmt.setString(2, Long.toString(participantID));
        stmt.setString(3, schema);
        stmt.setString(4, table);
        ResultSet result = stmt.executeQuery();
        if (result == null) {
            return null;
        }
        if (result.next()) {
            long repTableID = result.getLong(1);
            long tableID = result.getLong(2);
            String server = result.getString(3);
            String database = result.getString(4);
            boolean isMasterTab = result.getBoolean(5);
            UnitTable unitTable = new UnitTable(designID, participantID, repTableID, tableID, server, database, schema, table, isMasterTab);
            result.close();
            return unitTable;
        }
        result.close();
        return null;
    }

    public static UnitTable selectUnitTable(ConDataBase dbCon, long designID, long participantID, long tableID) throws SQLException {
        String SQL = "select REP_TABLE_ID,TABLE_SERVER,TABLE_DATABASE,TABLE_SCHEMA,TABLE_NAME,IS_MASTER_TABLE from " + dbCon.buildTableQualifier("RD_PARTICIPANT_TABLE") + " where DESIGN_ID=? and PARTICIPANT_ID=? and TABLE_ID=?";
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        stmt.setString(1, Long.toString(designID));
        stmt.setString(2, Long.toString(participantID));
        stmt.setString(3, Long.toString(tableID));
        ResultSet result = stmt.executeQuery();
        if (result == null) {
            return null;
        }
        if (result.next()) {
            long repTableID = result.getLong(1);
            String server = result.getString(2);
            String database = result.getString(3);
            String schema = result.getString(4);
            String table = result.getString(5);
            boolean isMasterTab = result.getBoolean(6);
            UnitTable unitTable = new UnitTable(designID, participantID, repTableID, tableID, server, database, schema, table, isMasterTab);
            result.close();
            return unitTable;
        }
        result.close();
        return null;
    }

    private static long tablesInstalled(ConDataBase dbCon, String schema, String name) throws SQLException {
        String SELECT_INSTALLED_TABLE_COUNT = "select count(*) from " + dbCon.buildTableQualifier("REPLICATION_UNITS") + ", " + dbCon.buildTableQualifier("REPLICATION_TABLES") + " where " + "REPLICATION_TABLES" + "." + "TABLE_SCHEMA" + " = ? and " + "REPLICATION_TABLES" + "." + "TABLE_NAME" + " = ? and " + "REPLICATION_UNITS" + "." + "UNIT_ID" + " = " + "REPLICATION_TABLES" + "." + "UNIT_ID" + " and " + "REPLICATION_UNITS" + "." + "UNIT_TYPE" + " != " + 1;
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SELECT_INSTALLED_TABLE_COUNT);
        stmt.setString(1, schema);
        stmt.setString(2, name);
        stmt.execute();
        ResultSet result = stmt.executeQuery();
        long count = -1L;
        if (result != null && result.next()) {
            count = result.getLong(1);
        }
        if (result != null) {
            result.close();
        }
        return count;
    }

    private static void unmarkTablesOfPaticipantUnit(ConDataBase dbCon, Participant participant) throws SQLException {
        String minDBUnit = dbCon.isMinDB() ? ", UNIT_ID" : "";
        String SQL = "select TABLE_SCHEMA, TABLE_NAME, SHADOW_TABLE_NAME, VERSION_TABLE_NAME, AUDIT_TABLE_NAME" + minDBUnit + " from " + dbCon.buildTableQualifier("REPLICATION_TABLES") + " where " + "UNIT_ID" + " = ?" + " order by " + "UNIT_ID" + " asc, " + "TABLE_SCHEMA" + " asc, " + "TABLE_NAME" + " asc";
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        DesignSQLLayer.setNumericParam(1, stmt, dbCon, participant.getParticipantID());
        stmt.execute();
        ResultSet result = stmt.executeQuery();
        if (result == null) {
            return;
        }
        while (result.next()) {
            String schema = result.getString(1);
            String name = result.getString(2);
            String shadowTableName = result.getString(3);
            String versionTableName = result.getString(4);
            String auditTableName = result.getString(5);
            if (participant.getParticipantType() != 2 && participant.getParticipantType() != 0) continue;
            long installed = 1L;
            if (participant.isMaster()) {
                installed = DesignSQLLayer.tablesInstalled(dbCon, schema, name);
            }
            if (installed >= 2L) continue;
            if (dbCon.isMinDB()) {
                SQLBuilder.unMarkMinTableForRep((Connection)dbCon.getConnection(), (String)dbCon.getSyncSchema(), (String)schema, (String)name, (String)shadowTableName, (String)versionTableName, (String)auditTableName);
                continue;
            }
            SQLBuilder.unMarkMaxTableForRep((Connection)dbCon.getConnection(), (String)dbCon.getSyncSchema(), (String)schema, (String)name, (String)shadowTableName, (String)versionTableName, (String)auditTableName);
        }
        result.close();
    }

    public static void deleteUnitNode(ConDataBase dbCon, long designID) throws Exception {
        Vector repPart = DesignSQLLayer.selectParticipants(dbCon, designID, true, true);
        String SQL = "delete from " + dbCon.buildTableQualifier("RD_PARTICIPANT") + " where DESIGN_ID=?";
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        DesignSQLLayer.setNumericParam(1, stmt, dbCon, designID);
        stmt.execute();
        for (int i = 0; i < repPart.size(); ++i) {
            Participant part = (Participant)repPart.get(i);
            DesignSQLLayer.deleteColumnGroups(dbCon, part.getParticipantID(), -1L);
            DesignSQLLayer.deleteColumns(dbCon, part.getParticipantID(), -1L);
            DesignSQLLayer.deleteParticipantConfig(dbCon, part.getHost(), part.getDataBase());
            if (!part.isMaster()) continue;
            DesignSQLLayer.deleteDestAuth(dbCon, part);
        }
        DesignSQLLayer.deleteAllTablesOfDesignNode(dbCon, designID);
    }

    public static void deleteParticipant(ConDataBase dbCon, Participant part) throws SQLException {
        String SQL = "delete from " + dbCon.buildTableQualifier("RD_PARTICIPANT") + " where DESIGN_ID=? and PARTICIPANT_ID=?";
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        DesignSQLLayer.setNumericParam(1, stmt, dbCon, part.getDesignID());
        DesignSQLLayer.setNumericParam(2, stmt, dbCon, part.getParticipantID());
        stmt.execute();
        DesignSQLLayer.deleteAllTablesOfParticipant(dbCon, part.getDesignID(), part.getParticipantID());
        DesignSQLLayer.deleteParticipantConfig(dbCon, part.getHost(), part.getDataBase());
    }

    public static void unInstallReplicationUnit(ConDataBase dbConSource, ConDataBase dbConTarget, Participant participant, boolean maintainClientCount) throws SQLException {
        DesignSQLLayer.unmarkTablesOfPaticipantUnit(dbConTarget, participant);
        String DELETE_UNIT = "delete from " + dbConTarget.buildTableQualifier("REPLICATION_UNITS") + " where " + "UNIT_ID" + " = ?";
        PreparedStatement stmt = dbConTarget.getConnection().prepareStatement(DELETE_UNIT);
        DesignSQLLayer.setNumericParam(1, stmt, dbConTarget, participant.getParticipantID());
        stmt.executeUpdate();
        String DELETE_TABLES = "delete from " + dbConTarget.buildTableQualifier("REPLICATION_TABLES") + " where " + "UNIT_ID" + " = ?";
        PreparedStatement stmt2 = dbConTarget.getConnection().prepareStatement(DELETE_TABLES);
        DesignSQLLayer.setNumericParam(1, stmt2, dbConTarget, participant.getParticipantID());
        stmt2.executeUpdate();
        String DELETE_COLS = "delete from " + dbConTarget.buildTableQualifier("REPLICATION_TABLE_COLUMNS") + " where " + "UNIT_ID" + " = ?";
        PreparedStatement stmt3 = dbConTarget.getConnection().prepareStatement(DELETE_COLS);
        DesignSQLLayer.setNumericParam(1, stmt3, dbConTarget, participant.getParticipantID());
        stmt3.executeUpdate();
        String DELETE_CONSTRAINTS = "delete from " + dbConSource.buildTableQualifier("REPLICATION_CLIENT_CONSTRAINT") + " where " + "CLIENT_ID" + " = ?";
        PreparedStatement stmt4 = dbConSource.getConnection().prepareStatement(DELETE_CONSTRAINTS);
        DesignSQLLayer.setNumericParam(1, stmt4, dbConTarget, participant.getParticipantID());
        stmt4.executeUpdate();
        DELETE_CONSTRAINTS = "delete from " + dbConTarget.buildTableQualifier("REPLICATION_CLIENT_CONSTRAINT") + " where " + "CLIENT_ID" + " = ?";
        PreparedStatement stmt5 = dbConTarget.getConnection().prepareStatement(DELETE_CONSTRAINTS);
        DesignSQLLayer.setNumericParam(1, stmt5, dbConTarget, participant.getParticipantID());
        stmt5.executeUpdate();
        if (!participant.isMaster() && maintainClientCount) {
            long installedClientCount = DesignSQLLayer.selectInstalledClientCount(dbConSource, participant.getDesignID());
            DesignSQLLayer.alterClientCount(dbConSource, --installedClientCount, participant.getDesignID());
        }
    }

    public static void installReplicationUnit(ConDataBase dbConSource, ConDataBase dbConTarget, Participant participant) throws Exception {
        for (int i = 0; i < participant.getParticipantName().length(); ++i) {
            if (Character.isJavaIdentifierPart(participant.getParticipantName().charAt(i))) continue;
            throw new SQLException("Character '" + participant.getParticipantName().charAt(i) + "'" + " not allowed in unit name: " + participant.getParticipantName());
        }
        String INSERT_UNIT = "insert into " + dbConTarget.buildTableQualifier("REPLICATION_UNITS") + " VALUES (?,?,?,?,?,?,?,?,?,?)";
        long installedClientCount = 0L;
        if (participant.isMaster()) {
            installedClientCount = DesignSQLLayer.selectInstalledClientCount(dbConSource, participant.getDesignID());
        }
        String[] pass = null;
        if (participant.getParticipantType() == 2 || participant.getParticipantType() == 1) {
            pass = DesignSQLLayer.selectMsgDestPasswords(dbConSource, participant.getDesignID(), participant.isMaster());
        }
        if (participant.getParticipantType() == 0) {
            pass = DesignSQLLayer.selectMsgDestPasswords(dbConSource, participant.getDesignID(), !participant.isMaster());
        }
        PreparedStatement stmt = dbConTarget.getConnection().prepareStatement(INSERT_UNIT);
        DesignSQLLayer.setNumericParam(1, stmt, dbConTarget, participant.getParticipantID());
        stmt.setString(2, participant.getParticipantName());
        stmt.setInt(3, participant.getParticipantType());
        stmt.setBoolean(4, participant.isMaster());
        stmt.setString(5, participant.getInDest());
        if (pass != null && pass[0] != null && participant.getInDest() != null) {
            stmt.setString(6, pass[0]);
        } else {
            stmt.setNull(6, 12);
        }
        stmt.setString(7, participant.getOutDest());
        if (pass != null && pass[1] != null && participant.getOutDest() != null) {
            stmt.setString(8, pass[1]);
        } else {
            stmt.setNull(8, 12);
        }
        DesignSQLLayer.setNumericParam(9, stmt, dbConTarget, installedClientCount);
        stmt.setInt(10, SyncManMessage.getMessageVersion());
        stmt.execute();
        if (!participant.isMaster()) {
            installedClientCount = DesignSQLLayer.selectInstalledClientCount(dbConSource, participant.getDesignID());
            DesignSQLLayer.alterClientCount(dbConSource, ++installedClientCount, participant.getDesignID());
        }
        Vector tables = participant.getTables(dbConSource);
        for (int i = 0; i < tables.size(); ++i) {
            UnitTable table = (UnitTable)tables.get(i);
            long count = DesignSQLLayer.unitTableCount(dbConSource, participant, table);
            if (count > 1L) {
                throw new Exception(table.getSchema() + "." + table.getName() + " usage count is " + count + " by the client " + participant.getHost() + "." + participant.getDataBase());
            }
            DesignSQLLayer.installTableOfParticipant(dbConSource, dbConTarget, participant, table);
        }
    }

    /*
     * Loose catch block
     */
    public static void insertRepTable(ConDataBase dbCon, String schema, String name) throws Exception {
        block20: {
            int sqlType = 1111;
            int precision = -1;
            int scale = -1;
            int pos = -1;
            int keyPos = -1;
            String typeName = "";
            long repTableID = GenUID.getNext();
            ReplicationTable newRepTable = new ReplicationTable(repTableID, dbCon.getHost(), dbCon.getDataBase(), schema, name);
            String columnName = null;
            Hashtable<String, Integer> primKeys = new Hashtable<String, Integer>();
            DatabaseMetaData dbMeta = dbCon.getConnection().getMetaData();
            ResultSet result = dbMeta.getColumns(null, schema, name, null);
            ResultSet resultKey = dbMeta.getPrimaryKeys(null, schema, name);
            long columnGroupID = newRepTable.getColumnGroups().size();
            ColumnGroup blobColumnGroup = new ColumnGroup("Blob Columns", columnGroupID);
            newRepTable.addColumnGroup(blobColumnGroup);
            while (resultKey.next()) {
                columnName = resultKey.getString("COLUMN_NAME");
                keyPos = resultKey.getInt("KEY_SEQ");
                primKeys.put(columnName, new Integer(keyPos));
            }
            while (result.next()) {
                columnName = result.getString("COLUMN_NAME");
                typeName = result.getString("TYPE_NAME");
                sqlType = result.getInt("DATA_TYPE");
                precision = result.getInt("COLUMN_SIZE");
                scale = result.getInt("DECIMAL_DIGITS");
                pos = result.getInt("ORDINAL_POSITION");
                Integer temp = (Integer)primKeys.get(columnName);
                keyPos = temp != null ? temp : -1;
                long columnID = GenUID.getNext();
                Column col = new Column(columnID, columnName, sqlType, typeName, precision, scale, pos, keyPos, 0, "", "");
                newRepTable.addColumn(col);
                if (col.sqlType() != -4 && col.sqlType() != -1) continue;
                if (newRepTable.versionedColumnGroup() == null) {
                    newRepTable.setVersionedColumnGroup(blobColumnGroup, true);
                }
                newRepTable.assignColumnToColumnGroup(blobColumnGroup, col);
            }
            if (newRepTable.keyColumnGroup().columnCount() < 1 && blobColumnGroup.columnCount() < 1 && newRepTable.singleColumnGroup().columnCount() < 1) {
                throw new Exception("No columns available for table " + schema + "." + name);
            }
            if (blobColumnGroup.columnCount() < 1) {
                newRepTable.removeColumnGroup(blobColumnGroup);
            }
            DesignSQLLayer.insertRepTable(dbCon, newRepTable);
            Object var25_22 = null;
            try {
                if (result != null) {
                    result.close();
                }
            }
            catch (SQLException ex) {
                // empty catch block
            }
            try {
                if (resultKey != null) {
                    resultKey.close();
                }
                break block20;
            }
            catch (SQLException ex) {}
            break block20;
            {
                catch (Exception ex) {
                    throw new Exception("Addition of columns for table " + schema + "." + name + "  failed due to:" + ex.toString());
                }
            }
            catch (Throwable throwable) {
                Object var25_23 = null;
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (SQLException ex) {
                    // empty catch block
                }
                try {
                    if (resultKey != null) {
                        resultKey.close();
                    }
                }
                catch (SQLException ex) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private static void insertRepTable(ConDataBase dbCon, ReplicationTable repTable) throws SQLException {
        String SQL = "insert into " + dbCon.buildTableQualifier("RD_REP_TABLE") + " VALUES (?,?,?,?,?)";
        long tableID = repTable.getTableID();
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        stmt.setString(1, repTable.getHost());
        stmt.setString(2, repTable.getDataBase());
        stmt.setString(3, repTable.getSchema());
        stmt.setString(4, repTable.getName());
        DesignSQLLayer.setNumericParam(5, stmt, dbCon, tableID);
        stmt.execute();
        DesignSQLLayer.insertColumnGroup(dbCon, -1L, repTable.getTableID(), repTable.singleColumnGroup());
        DesignSQLLayer.insertColumnGroup(dbCon, -1L, repTable.getTableID(), repTable.keyColumnGroup());
        for (int cgs = 0; cgs < repTable.getColumnGroups().size(); ++cgs) {
            ColumnGroup temp = (ColumnGroup)repTable.getColumnGroups().get(cgs);
            DesignSQLLayer.insertColumnGroup(dbCon, -1L, repTable.getTableID(), temp);
        }
    }

    private static void insertColumnGroup(ConDataBase dbCon, long participantID, long tableID, ColumnGroup cg) throws SQLException {
        String SQL = "insert into " + dbCon.buildTableQualifier("RD_TABLE_COLUMN_GROUP") + " VALUES (?,?,?,?,?,?,?,?)";
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        DesignSQLLayer.setNumericParam(1, stmt, dbCon, participantID);
        DesignSQLLayer.setNumericParam(2, stmt, dbCon, tableID);
        DesignSQLLayer.setNumericParam(3, stmt, dbCon, cg.columnGroupID());
        stmt.setString(4, cg.columnGroupName());
        stmt.setBoolean(5, cg.keyCols());
        stmt.setBoolean(6, cg.versioned());
        stmt.setBoolean(7, cg.forReplication());
        stmt.setBoolean(8, cg.containsBlobColumn());
        stmt.execute();
        Enumeration enumCols = cg.columns();
        while (enumCols.hasMoreElements()) {
            Column col = (Column)enumCols.nextElement();
            DesignSQLLayer.insertColumnOfColumngGroup(dbCon, participantID, tableID, cg.columnGroupID(), col);
        }
    }

    public static void alterColumnGroup(ConDataBase dbCon, long participantID, long tableID, ColumnGroup cg) throws SQLException {
        String SQL = "update " + dbCon.buildTableQualifier("RD_TABLE_COLUMN_GROUP") + " set FOR_REPLICATION=? where";
        if (participantID > 0L) {
            SQL = SQL + " PARTICIPANT_ID=? ";
            if (tableID > 0L) {
                SQL = SQL + "and ";
            }
        }
        if (tableID > 0L) {
            SQL = SQL + " TABLE_ID=? ";
        }
        if (tableID < 0L && participantID < 0L) {
            throw new SQLException("Please specify at least a participantID or a tableID.");
        }
        SQL = SQL + " and COLUMN_GROUP_ID=?";
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        stmt.setBoolean(1, cg.forReplication());
        if (participantID > 0L) {
            DesignSQLLayer.setNumericParam(2, stmt, dbCon, participantID);
            if (tableID > 0L) {
                DesignSQLLayer.setNumericParam(3, stmt, dbCon, tableID);
                DesignSQLLayer.setNumericParam(4, stmt, dbCon, cg.columnGroupID());
            } else {
                DesignSQLLayer.setNumericParam(3, stmt, dbCon, cg.columnGroupID());
            }
        } else {
            DesignSQLLayer.setNumericParam(2, stmt, dbCon, tableID);
            DesignSQLLayer.setNumericParam(3, stmt, dbCon, cg.columnGroupID());
        }
        stmt.execute();
    }

    private static void insertColumnOfColumngGroup(ConDataBase dbCon, long participantID, long tableID, long columnGroupID, Column column) throws SQLException {
        PreparedStatement stmt = null;
        try {
            String SQL = "insert into " + dbCon.buildTableQualifier("RD_TABLE_COLUMN") + " values (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            stmt = dbCon.getConnection().prepareStatement(SQL);
            DesignSQLLayer.setNumericParam(1, stmt, dbCon, participantID);
            DesignSQLLayer.setNumericParam(2, stmt, dbCon, tableID);
            DesignSQLLayer.setNumericParam(3, stmt, dbCon, columnGroupID);
            DesignSQLLayer.setNumericParam(4, stmt, dbCon, column.columnID());
            stmt.setString(5, column.columnName());
            stmt.setInt(6, column.sqlType());
            stmt.setString(7, column.typeName());
            stmt.setInt(8, column.precision());
            stmt.setInt(9, column.scale());
            stmt.setInt(10, column.pos());
            stmt.setInt(11, column.keyPos());
            stmt.setInt(12, column.constraintType());
            stmt.setString(13, column.constraintValue1());
            stmt.setString(14, column.constraintValue2());
            stmt.execute();
        }
        catch (SQLException ex) {
            throw new SQLException("Addition of columns for table id " + tableID + "  failed due to:" + ex.toString());
        }
    }

    public static void setUnitTableSchemas(ConDataBase dbCon, long participantID, String schema) throws SQLException {
        String SQL = "update  " + dbCon.buildTableQualifier("RD_PARTICIPANT_TABLE") + " set TABLE_SCHEMA = ? where PARTICIPANT_ID =?";
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        stmt.setString(1, schema);
        DesignSQLLayer.setNumericParam(2, stmt, dbCon, participantID);
        stmt.execute();
    }

    public static void insertUnitTable(ConDataBase dbCon, UnitTable table) throws SQLException {
        String SQL = "insert into " + dbCon.buildTableQualifier("RD_PARTICIPANT_TABLE") + " values (?,?,?,?,?,?,?,?,?)";
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        DesignSQLLayer.setNumericParam(1, stmt, dbCon, table.getDesignID());
        DesignSQLLayer.setNumericParam(2, stmt, dbCon, table.getParticipantID());
        DesignSQLLayer.setNumericParam(3, stmt, dbCon, table.getRepTableID());
        DesignSQLLayer.setNumericParam(4, stmt, dbCon, table.getTableID());
        stmt.setString(5, table.getHost());
        stmt.setString(6, table.getDataBase());
        stmt.setString(7, table.getSchema());
        stmt.setString(8, table.getName());
        stmt.setBoolean(9, table.getIsMasterTable());
        stmt.execute();
        for (int i = 0; i < table.getColumnGroups().size(); ++i) {
            ColumnGroup cg = (ColumnGroup)table.getColumnGroups().get(i);
            DesignSQLLayer.insertColumnGroup(dbCon, table.getParticipantID(), table.getTableID(), cg);
        }
    }

    public static void deleteRepTable(ConDataBase dbCon, long tableID) throws SQLException {
        String SQL = "delete from " + dbCon.buildTableQualifier("RD_REP_TABLE") + " where REP_TABLE_ID=?";
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        DesignSQLLayer.setNumericParam(1, stmt, dbCon, tableID);
        stmt.execute();
        DesignSQLLayer.deleteColumnGroups(dbCon, -1L, tableID);
        DesignSQLLayer.deleteColumns(dbCon, -1L, tableID);
    }

    private static long unitTableCount(ConDataBase dbCon, Participant part, UnitTable table) throws SQLException {
        long count = -1L;
        String SQL = "select count(*) from " + dbCon.buildTableQualifier("RD_PARTICIPANT") + " where SERVER_NODE=? and DATA_BASE=? and PARTICIPANT_ID IN" + "(select PARTICIPANT_ID from " + dbCon.buildTableQualifier("RD_PARTICIPANT_TABLE") + " where TABLE_SCHEMA=? and TABLE_NAME=?" + " and IS_MASTER_TABLE=0)";
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        stmt.setString(1, part.getHost());
        stmt.setString(2, part.getDataBase());
        stmt.setString(3, table.getSchema());
        stmt.setString(4, table.getName());
        stmt.execute();
        ResultSet result = stmt.executeQuery();
        if (result.next()) {
            count = result.getLong(1);
        }
        result.close();
        return count;
    }

    public static long selectTableUsageCount(ConDataBase dbCon, long repTableID) throws SQLException {
        long count = -1L;
        String SQL = "select count(*) from " + dbCon.buildTableQualifier("RD_PARTICIPANT_TABLE") + " where REP_TABLE_ID=?";
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        DesignSQLLayer.setNumericParam(1, stmt, dbCon, repTableID);
        stmt.execute();
        ResultSet result = stmt.executeQuery();
        if (result.next()) {
            count = result.getLong(1);
        }
        result.close();
        return count;
    }

    public static void deleteTablesOfDesignNode(ConDataBase dbCon, long designID, long tableID) throws SQLException {
        String SQL = "delete from " + dbCon.buildTableQualifier("RD_PARTICIPANT_TABLE") + " where DESIGN_ID=? and TABLE_ID=?";
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        DesignSQLLayer.setNumericParam(1, stmt, dbCon, designID);
        DesignSQLLayer.setNumericParam(2, stmt, dbCon, tableID);
        stmt.execute();
        DesignSQLLayer.deleteColumnGroups(dbCon, -1L, tableID);
        DesignSQLLayer.deleteColumns(dbCon, -1L, tableID);
    }

    private static void deleteAllTablesOfParticipant(ConDataBase dbCon, long designID, long participantID) throws SQLException {
        String SQL = "delete from " + dbCon.buildTableQualifier("RD_PARTICIPANT_TABLE") + " WHERE DESIGN_ID=? and PARTICIPANT_ID=?";
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        DesignSQLLayer.setNumericParam(1, stmt, dbCon, designID);
        DesignSQLLayer.setNumericParam(2, stmt, dbCon, participantID);
        DesignSQLLayer.deleteColumnGroups(dbCon, participantID, -1L);
        DesignSQLLayer.deleteColumns(dbCon, participantID, -1L);
        stmt.execute();
    }

    public static void deleteAllTablesOfDesignNode(ConDataBase dbCon, long designID) throws SQLException {
        String SQL = "delete from " + dbCon.buildTableQualifier("RD_PARTICIPANT_TABLE") + " where DESIGN_ID=?";
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        DesignSQLLayer.setNumericParam(1, stmt, dbCon, designID);
        stmt.execute();
    }

    private static void deleteColumnGroups(ConDataBase dbCon, long participantID, long tableID) throws SQLException {
        String SQL = "delete from " + dbCon.buildTableQualifier("RD_TABLE_COLUMN_GROUP") + " WHERE";
        if (participantID > 0L) {
            SQL = SQL + " PARTICIPANT_ID=? ";
            if (tableID > 0L) {
                SQL = SQL + "and ";
            }
        }
        if (tableID > 0L) {
            SQL = SQL + " TABLE_ID=?";
        }
        if (tableID < 0L && participantID < 0L) {
            throw new SQLException("Please specify at least a participantID or a tableID.");
        }
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        if (participantID > 0L) {
            DesignSQLLayer.setNumericParam(1, stmt, dbCon, participantID);
            if (tableID > 0L) {
                DesignSQLLayer.setNumericParam(2, stmt, dbCon, tableID);
            }
        } else {
            DesignSQLLayer.setNumericParam(1, stmt, dbCon, tableID);
        }
        stmt.execute();
    }

    private static void deleteColumns(ConDataBase dbCon, long participantID, long tableID) throws SQLException {
        String SQL = "delete from " + dbCon.buildTableQualifier("RD_TABLE_COLUMN") + " WHERE";
        if (participantID > 0L) {
            SQL = SQL + " PARTICIPANT_ID=? ";
            if (tableID > 0L) {
                SQL = SQL + "and ";
            }
        }
        if (tableID > 0L) {
            SQL = SQL + " TABLE_ID=?";
        }
        if (tableID < 0L && participantID < 0L) {
            throw new SQLException("Please specify at least a participantID or a tableID.");
        }
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        if (participantID > 0L) {
            DesignSQLLayer.setNumericParam(1, stmt, dbCon, participantID);
            if (tableID > 0L) {
                DesignSQLLayer.setNumericParam(2, stmt, dbCon, tableID);
            }
        } else {
            DesignSQLLayer.setNumericParam(1, stmt, dbCon, tableID);
        }
        stmt.execute();
    }

    public static int alterUnitTable(ConDataBase dbCon, UnitTable table) throws SQLException {
        String SQL = "update " + dbCon.buildTableQualifier("RD_PARTICIPANT_TABLE") + " set TABLE_SCHEMA=?,TABLE_NAME=?" + "where DESIGN_ID=? and PARTICIPANT_ID=? and TABLE_ID=?";
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        stmt.setString(1, table.getSchema());
        stmt.setString(2, table.getName());
        DesignSQLLayer.setNumericParam(3, stmt, dbCon, table.getDesignID());
        DesignSQLLayer.setNumericParam(4, stmt, dbCon, table.getParticipantID());
        DesignSQLLayer.setNumericParam(5, stmt, dbCon, table.getTableID());
        return stmt.executeUpdate();
    }

    public static int alterParticipant(ConDataBase dbCon, Participant part) throws Exception {
        String SQL = "update " + dbCon.buildTableQualifier("RD_PARTICIPANT") + " set PARTICIPANT_NAME=?,PARTICIPANT_TYPE=?,SERVER_NODE=?,DATA_BASE=?," + "REP_USER=?,REP_PASSWORD=?,IS_INSTALLED=?" + "where DESIGN_ID=? and PARTICIPANT_ID=?";
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        stmt.setString(1, part.getParticipantName());
        stmt.setInt(2, part.getParticipantType());
        stmt.setString(3, part.getHost());
        stmt.setString(4, part.getDataBase());
        String cRepUser = "";
        cRepUser = dbCon.getCryptObject().crypt(part.getUser());
        stmt.setString(5, cRepUser);
        String cRepPassWord = "";
        cRepPassWord = dbCon.getCryptObject().crypt(part.getPassWord());
        stmt.setString(6, cRepPassWord);
        stmt.setBoolean(7, part.isInstalled());
        DesignSQLLayer.setNumericParam(8, stmt, dbCon, part.getDesignID());
        DesignSQLLayer.setNumericParam(9, stmt, dbCon, part.getParticipantID());
        return stmt.executeUpdate();
    }

    public static int alterInstalledFlagForParticipant(ConDataBase dbCon, Participant part) throws SQLException {
        String SQL = "update " + dbCon.buildTableQualifier("RD_PARTICIPANT") + " set IS_INSTALLED=?" + "where DESIGN_ID=? and PARTICIPANT_ID=?";
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        stmt.setBoolean(1, part.isInstalled());
        DesignSQLLayer.setNumericParam(2, stmt, dbCon, part.getDesignID());
        DesignSQLLayer.setNumericParam(3, stmt, dbCon, part.getParticipantID());
        return stmt.executeUpdate();
    }

    public static void alterRepTable(ConDataBase dbCon, ReplicationTable table) throws SQLException {
        DesignSQLLayer.deleteColumnGroups(dbCon, -1L, table.getTableID());
        DesignSQLLayer.deleteColumns(dbCon, -1L, table.getTableID());
        DesignSQLLayer.insertColumnGroup(dbCon, -1L, table.getTableID(), table.singleColumnGroup());
        DesignSQLLayer.insertColumnGroup(dbCon, -1L, table.getTableID(), table.keyColumnGroup());
        for (int i = 0; i < table.getColumnGroups().size(); ++i) {
            ColumnGroup cg = (ColumnGroup)table.getColumnGroups().get(i);
            DesignSQLLayer.insertColumnGroup(dbCon, -1L, table.getTableID(), cg);
        }
    }

    public static void insertParticipant(ConDataBase dbCon, Participant part, boolean copyTablesFromMaster) throws Exception {
        String SQL = "insert into " + dbCon.buildTableQualifier("RD_PARTICIPANT") + " values (?,?,?,?,?,?,?,?,?,?,?)";
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        DesignSQLLayer.setNumericParam(1, stmt, dbCon, part.getDesignID());
        DesignSQLLayer.setNumericParam(2, stmt, dbCon, part.getParticipantID());
        stmt.setString(3, part.getParticipantName());
        stmt.setInt(4, part.getParticipantType());
        stmt.setString(5, part.getHost());
        stmt.setString(6, part.getDataBase());
        String cRepUser = "";
        cRepUser = dbCon.getCryptObject().crypt(part.getUser());
        stmt.setString(7, cRepUser);
        String cRepPassWord = "";
        cRepPassWord = dbCon.getCryptObject().crypt(part.getPassWord());
        stmt.setString(8, cRepPassWord);
        stmt.setBoolean(9, part.isMaster());
        stmt.setBoolean(10, part.isInstalled());
        stmt.setInt(11, SyncManMessage.getMessageVersion());
        stmt.execute();
        if (copyTablesFromMaster) {
            Vector repPart = DesignSQLLayer.selectParticipants(dbCon, part.getDesignID(), true, false);
            if (repPart.size() > 1) {
                throw new Exception("More than one master participant <" + part.getDesignID() + ">");
            }
            Participant partMaster = (Participant)repPart.get(0);
            Vector tables = DesignSQLLayer.selectUnitTables(dbCon, partMaster.getDesignID(), partMaster.getParticipantID());
            for (int j = 0; j < tables.size(); ++j) {
                UnitTable table = (UnitTable)tables.get(j);
                DesignSQLLayer.selectColumnGroupsOfTable(dbCon, table.getParticipantID(), table.getTableID());
                table.loadColumnGroups(dbCon);
                table.setParticipantID(part.getParticipantID());
                table.setIsMasterTable(false);
                DesignSQLLayer.insertUnitTable(dbCon, table);
            }
        }
        ParticipantConfig config = new ParticipantConfig(part.getHost(), part.getDataBase(), "com.sap.dbtech.jdbc.DriverSapDB", false);
        DesignSQLLayer.insertParticipantConfigWithCheck(dbCon, config);
        if (part.isMaster()) {
            DesignSQLLayer.insertDestAuth(dbCon, part);
        }
    }

    private static void deleteDestAuth(ConDataBase dbConSource, Participant participant) throws SQLException {
        String DELETE_DEST_AUTH = "delete from " + dbConSource.buildTableQualifier("RD_PARTICIPANT_AUTH") + " where " + "DESIGN_ID" + "=?";
        PreparedStatement stmt = dbConSource.getConnection().prepareStatement(DELETE_DEST_AUTH);
        stmt.setLong(1, participant.getDesignID());
        stmt.execute();
    }

    private static void insertDestAuth(ConDataBase dbConSource, Participant participant) throws Exception {
        String INSERT_DEST_AUTH = "insert into " + dbConSource.buildTableQualifier("RD_PARTICIPANT_AUTH") + " VALUES (?,?,?,?)";
        PreparedStatement stmt = dbConSource.getConnection().prepareStatement(INSERT_DEST_AUTH);
        byte[] pw = new byte[16];
        Random random = new Random();
        random.setSeed(System.currentTimeMillis());
        String writePass = DesignSQLLayer.selectTheOneAnyOnlyMsgDestWritePass(dbConSource);
        if (writePass == null) {
            random.nextBytes(pw);
            writePass = Convert.bytesToHexStr(pw);
        }
        stmt.setLong(1, participant.getDesignID());
        if (participant.getParticipantType() == 2 || participant.getParticipantType() == 1) {
            random.nextBytes(pw);
            stmt.setBoolean(2, true);
            stmt.setString(3, Convert.bytesToHexStr(pw));
            stmt.setString(4, writePass);
            stmt.execute();
        }
        if (participant.getParticipantType() == 2 || participant.getParticipantType() == 0) {
            random.nextBytes(pw);
            stmt.setBoolean(2, false);
            stmt.setString(3, Convert.bytesToHexStr(pw));
            stmt.setString(4, writePass);
            stmt.execute();
        }
    }

    private static void installTableOfParticipant(ConDataBase dbConSource, ConDataBase dbConTarget, Participant participant, UnitTable table) throws Exception {
        DatabaseMetaData dbMeta = dbConTarget.getConnection().getMetaData();
        ResultSet result = dbMeta.getTables(null, table.getSchema(), table.getName(), null);
        if (!result.next()) {
            result.close();
            throw new SQLException("Table " + table.getSchema() + "." + table.getName() + " does not exist on " + dbMeta.getURL());
        }
        result.close();
        String dbTableID = "";
        String shadowTableName = "";
        String auditTableName = "";
        String versionTableName = "";
        Vector<ColumnDesc> repColumns = null;
        Vector<ColumnDesc> repAnyColumns = null;
        table.loadColumnGroups(dbConSource);
        repColumns = DesignSQLLayer.createReplicationColumns(table.getColumnGroups());
        if (table.getIsMasterTable()) {
            Vector cols = DesignSQLLayer.selectColumnsOfUnitTable(dbConSource, -1L, table.getRepTableID(), true);
            repAnyColumns = new Vector<ColumnDesc>();
            for (int i = 0; i < cols.size(); ++i) {
                Column col = (Column)cols.get(i);
                ColumnDesc anyColDesc = DesignSQLLayer.isColumnForAnyReplication(dbConSource, table, col);
                if (anyColDesc == null) continue;
                repAnyColumns.add(anyColDesc);
            }
        } else {
            repAnyColumns = repColumns;
        }
        if (participant.getParticipantType() == 2 || participant.getParticipantType() == 0) {
            if (dbConTarget.isMaxDB()) {
                dbTableID = DesignSQLLayer.selectTableID(dbConTarget, table.getSchema(), table.getName());
            }
            if (dbConTarget.isMinDB()) {
                dbTableID = Long.toString(table.getTableID());
            }
            shadowTableName = "_R_" + dbTableID;
            auditTableName = "_R_A_" + dbTableID;
            versionTableName = "_R_V_" + dbTableID;
            long isInstalled = 0L;
            if (participant.isMaster()) {
                isInstalled = DesignSQLLayer.tablesInstalled(dbConTarget, table.getSchema(), table.getName());
            }
            if (isInstalled < 1L) {
                if (dbConTarget.isMinDB()) {
                    SQLBuilder.markMinDBTableForRep((Connection)dbConTarget.getConnection(), (String)dbConTarget.getUser(), (String)dbConTarget.getSyncSchema(), (String)table.getSchema(), (String)table.getName(), repAnyColumns, (long)participant.getParticipantID(), (boolean)participant.isMaster(), (String)shadowTableName, (String)versionTableName, (String)auditTableName);
                } else if (dbConTarget.isMaxDB()) {
                    SQLBuilder.markMaxDBTableForRep((Connection)dbConTarget.getConnection(), (String)dbConTarget.getUser(), (String)dbConTarget.getSyncSchema(), (String)table.getSchema(), (String)table.getName(), repAnyColumns, (long)participant.getParticipantID(), (boolean)participant.isMaster(), (String)shadowTableName, (String)versionTableName, (String)auditTableName);
                } else {
                    throw new SQLException("Invalid database type");
                }
            }
        }
        String INSERT_TABLE = "insert into " + dbConTarget.buildTableQualifier("REPLICATION_TABLES") + "(" + "UNIT_ID" + ", " + "TABLE_ID" + ", " + "TABLE_SCHEMA" + ", " + "TABLE_NAME" + ", " + "SHADOW_TABLE_NAME" + ", " + "VERSION_TABLE_NAME" + ", " + "AUDIT_TABLE_NAME" + ")" + " values (?,?,?,?,?,?,?)";
        PreparedStatement stmt = dbConTarget.getConnection().prepareStatement(INSERT_TABLE);
        DesignSQLLayer.setNumericParam(1, stmt, dbConTarget, participant.getParticipantID());
        DesignSQLLayer.setNumericParam(2, stmt, dbConTarget, table.getTableID());
        stmt.setString(3, table.getSchema());
        stmt.setString(4, table.getName());
        stmt.setString(5, shadowTableName);
        stmt.setString(6, versionTableName);
        stmt.setString(7, auditTableName);
        stmt.execute();
        for (int i = 0; i < repColumns.size(); ++i) {
            ColumnDesc col = (ColumnDesc)repColumns.get(i);
            DesignSQLLayer.insertReplicationColumn(dbConTarget, table, col);
            if (participant.isMaster() || col.constraintType() == 0) continue;
            DesignSQLLayer.insertClientColumnConstraint(dbConSource, table, col);
            if (dbConSource.getConnection().getMetaData().getURL().equalsIgnoreCase(dbConTarget.getConnection().getMetaData().getURL())) continue;
            DesignSQLLayer.insertClientColumnConstraint(dbConTarget, table, col);
        }
    }

    private static void insertClientColumnConstraint(ConDataBase dbCon, UnitTable table, ColumnDesc column) throws SQLException {
        String SQL = "insert into " + dbCon.buildTableQualifier("REPLICATION_CLIENT_CONSTRAINT") + "(" + "CLIENT_ID" + ", " + "TABLE_ID" + ", " + "COLUMN_ID" + ", " + "CONSTRAINT_TYPE" + ", " + "CONSTRAINT_VALUE1" + ", " + "CONSTRAINT_VALUE2" + ")" + " values (?,?,?,?,?,?)";
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        DesignSQLLayer.setNumericParam(1, stmt, dbCon, table.getParticipantID());
        DesignSQLLayer.setNumericParam(2, stmt, dbCon, table.getTableID());
        DesignSQLLayer.setNumericParam(3, stmt, dbCon, column.columnID());
        stmt.setInt(4, column.constraintType());
        stmt.setString(5, column.constraintValue1());
        stmt.setString(6, column.constraintValue2());
        stmt.execute();
    }

    private static void insertReplicationColumn(ConDataBase dbCon, UnitTable table, ColumnDesc column) throws SQLException {
        DatabaseMetaData dbMeta = dbCon.getConnection().getMetaData();
        ResultSet result = dbMeta.getColumns(null, table.getSchema(), table.getName(), column.columnName());
        if (!result.next()) {
            result.close();
            throw new SQLException("Column " + column.columnName() + " of Table " + table.getSchema() + "." + table.getName() + " does not exist on " + dbMeta.getURL());
        }
        result.close();
        long tableID = table.getTableID();
        PreparedStatement stmt = null;
        try {
            String SQL = "insert into " + dbCon.buildTableQualifier("REPLICATION_TABLE_COLUMNS") + "(" + "UNIT_ID" + ", " + "TABLE_ID" + ", " + "COLUMN_ID" + ", " + "COLUMN_NAME" + ", " + "SQL_TYPE" + ", " + "COL_PRECISION" + ", " + "SCALE" + ", " + "KEY_POS" + ", " + "COLUMN_GROUP_ID" + ", " + "COLUMN_GROUP_VERSIONED" + ")" + " values (?,?,?,?,?,?,?,?,?,?)";
            stmt = dbCon.getConnection().prepareStatement(SQL);
            DesignSQLLayer.setNumericParam(1, stmt, dbCon, table.getParticipantID());
            DesignSQLLayer.setNumericParam(2, stmt, dbCon, tableID);
            DesignSQLLayer.setNumericParam(3, stmt, dbCon, column.columnID());
            stmt.setString(4, column.columnName());
            stmt.setInt(5, column.sqlType());
            stmt.setInt(6, column.precision());
            stmt.setInt(7, column.scale());
            stmt.setInt(8, column.keyPos());
            DesignSQLLayer.setNumericParam(9, stmt, dbCon, column.columnGroupID());
            stmt.setBoolean(10, column.versioned());
            stmt.execute();
        }
        catch (SQLException ex) {
            throw new SQLException("Addition of columns for table id " + tableID + "  failed due to:" + ex.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String selectTableID(ConDataBase dbCon, String schema, String name) throws SQLException {
        String ret = null;
        ResultSet result = null;
        try {
            try {
                String cmd = "select tableid from domain.tables where schemaname =? and tablename =?";
                PreparedStatement stmt = dbCon.getConnection().prepareStatement(cmd);
                stmt.setString(1, schema);
                stmt.setString(2, name);
                stmt.execute();
                result = stmt.getResultSet();
                if (result.next()) {
                    ret = Convert.bytesToHexStr(result.getBytes(1));
                }
            }
            catch (SQLException ex) {
                throw new SQLException("Table ID for table " + schema + "." + name + "  failed due to:" + ex.toString());
            }
            Object var8_8 = null;
            {
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (result == null) throw throwable;
                result.close();
                throw throwable;
            }
            catch (SQLException ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException ex) {}
        if (result != null) {
            result.close();
        }
        if (ret != null) return ret;
        throw new SQLException("Table ID for table " + schema + "." + name + "  failed due to NULL value");
    }

    public static long getTimeStamp(Connection dbCon) throws SQLException {
        long databaseTimeStamp = 0L;
        String SQL = "SELECT year(timestamp), month(timestamp), day(timestamp), hour(timestamp), minute(timestamp), second(timestamp), microsecond(timestamp)/1000 FROM dual";
        PreparedStatement stmt = dbCon.prepareStatement(SQL);
        ResultSet result = stmt.executeQuery();
        if (!result.next()) {
            if (result != null) {
                result.close();
            }
            throw new SQLException("No valid Result for Database Time.");
        }
        databaseTimeStamp = new GregorianCalendar(result.getInt(1), result.getInt(2) - 1, result.getInt(3), result.getInt(4), result.getInt(5), result.getInt(6)).getTime().getTime() + (long)result.getInt(7);
        result.close();
        return databaseTimeStamp;
    }

    private static Vector createReplicationColumns(Vector getColumnGroups) {
        Vector<ColumnDesc> cols = new Vector<ColumnDesc>();
        for (int cgCount = 0; cgCount < getColumnGroups.size(); ++cgCount) {
            ColumnGroup cg = (ColumnGroup)getColumnGroups.get(cgCount);
            if (!cg.forReplication()) continue;
            Enumeration enumCols = cg.columns();
            while (enumCols.hasMoreElements()) {
                ColumnDesc colTest;
                Column col = (Column)enumCols.nextElement();
                int i = 0;
                for (i = 0; i < cols.size() && (colTest = (ColumnDesc)cols.get(i)).pos() <= col.pos(); ++i) {
                }
                cols.add(i, new ColumnDesc(col.columnName(), col.columnID(), cg.columnGroupID(), col.sqlType(), col.typeName(), col.precision(), col.scale(), col.pos(), col.keyPos(), cg.versioned(), col.constraintType(), col.constraintValue1(), col.constraintValue2()));
            }
        }
        return cols;
    }

    public static void createRepUser(Connection dbCon, String user, String password) throws SQLException {
        String SQL = "create user " + user + " password " + password + " resource not exclusive replication";
        PreparedStatement stmt = dbCon.prepareStatement(SQL);
        stmt.execute();
    }

    public static void dropRepUser(Connection dbCon, String user) throws SQLException {
        String SQL = "drop user \"" + user + "\"";
        PreparedStatement stmt = dbCon.prepareStatement(SQL);
        stmt.execute();
    }

    public static Vector selectRepSystemTables(ConDataBase dbCon) throws Exception {
        Vector<InstalledRepTable> tables = new Vector<InstalledRepTable>();
        String SQL = "select TABLE_SCHEMA,TABLE_NAME,AUDIT_TABLE_NAME,SHADOW_TABLE_NAME,VERSION_TABLE_NAME from " + dbCon.buildTableQualifier("REPLICATION_TABLES");
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        ResultSet result = stmt.executeQuery();
        if (result == null) {
            return tables;
        }
        while (result.next()) {
            String schema = result.getString(1);
            String name = result.getString(2);
            String audit = result.getString(3);
            String shadow = result.getString(4);
            String version = result.getString(5);
            if (audit == null || audit.length() <= 0 || shadow == null || shadow.length() <= 0 || version == null || version.length() <= 0) continue;
            InstalledRepTable table = new InstalledRepTable(schema, name, shadow, version, audit);
            tables.add(table);
        }
        result.close();
        return tables;
    }

    public static long selectTableCount(ConDataBase dbCon, String name) throws SQLException {
        String SQL = "select count (*) from " + dbCon.buildTableQualifier(name);
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        ResultSet result = stmt.executeQuery();
        if (result == null) {
            return 0L;
        }
        long shadowCount = 0L;
        while (result.next()) {
            shadowCount = result.getLong(1);
        }
        result.close();
        return shadowCount;
    }

    public static Vector selectDistinctParticipants(ConDataBase dbCon) throws SQLException {
        Vector<Participant> parts = new Vector<Participant>();
        String SQL = "select distinct SERVER_NODE,DATA_BASE,REP_USER,REP_PASSWORD,IS_MASTER from " + dbCon.buildTableQualifier("RD_PARTICIPANT");
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        ResultSet result = stmt.executeQuery();
        while (result.next()) {
            String host = result.getString(1);
            String database = result.getString(2);
            String cRepUser = result.getString(3);
            String cRepPassword = result.getString(4);
            boolean isMaster = result.getBoolean(5);
            String repUser = "";
            String repPassword = "";
            try {
                repUser = dbCon.getCryptObject().decrypt(cRepUser);
                repPassword = isMaster ? dbCon.getPassWord() : dbCon.getCryptObject().decrypt(cRepPassword);
            }
            catch (Exception ex) {
                throw new SQLException(ex.toString());
            }
            Participant part = new Participant(-1L, -1L, "", -1, host, database, repUser, repPassword, isMaster, false);
            parts.add(part);
        }
        result.close();
        return parts;
    }

    public static Vector selectParticipantsOfTable(ConDataBase dbCon, String schema, String name) throws SQLException {
        Vector<Participant> parts = new Vector<Participant>();
        String SQL = "select " + dbCon.buildTableQualifier("RD_PARTICIPANT") + ".DESIGN_ID," + dbCon.buildTableQualifier("RD_PARTICIPANT") + ".PARTICIPANT_ID,PARTICIPANT_NAME,PARTICIPANT_TYPE," + "SERVER_NODE,DATA_BASE,REP_USER,REP_PASSWORD," + "IS_MASTER,IS_INSTALLED from " + dbCon.buildTableQualifier("RD_PARTICIPANT") + "," + dbCon.buildTableQualifier("RD_PARTICIPANT_TABLE") + " where " + dbCon.buildTableQualifier("RD_PARTICIPANT") + ".DESIGN_ID=" + dbCon.buildTableQualifier("RD_PARTICIPANT_TABLE") + ".DESIGN_ID" + " and " + dbCon.buildTableQualifier("RD_PARTICIPANT") + ".PARTICIPANT_ID=" + dbCon.buildTableQualifier("RD_PARTICIPANT_TABLE") + ".PARTICIPANT_ID" + " and " + dbCon.buildTableQualifier("RD_PARTICIPANT_TABLE") + ".table_schema=? " + " and " + dbCon.buildTableQualifier("RD_PARTICIPANT_TABLE") + ".table_name=? ";
        PreparedStatement stmt = dbCon.getConnection().prepareStatement(SQL);
        stmt.setString(1, schema);
        stmt.setString(2, name);
        ResultSet result = stmt.executeQuery();
        if (result == null) {
            return parts;
        }
        while (result.next()) {
            long designID = result.getLong(1);
            long participantID = result.getLong(2);
            String unitName = result.getString(3);
            int unitType = result.getInt(4);
            String host = result.getString(5);
            String database = result.getString(6);
            String cRepUser = result.getString(7);
            String repUser = "";
            String cRepPassword = result.getString(8);
            String repPassword = "";
            try {
                repPassword = dbCon.getCryptObject().decrypt(cRepPassword);
                repUser = dbCon.getCryptObject().decrypt(cRepUser);
            }
            catch (Exception ex) {
                throw new SQLException(ex.toString());
            }
            boolean isMaster = result.getBoolean(9);
            boolean isInstalled = result.getBoolean(10);
            Participant part = new Participant(designID, participantID, unitName, unitType, host, database, repUser, repPassword, isMaster, isInstalled);
            parts.add(part);
        }
        result.close();
        return parts;
    }

    public static void tableForReplication(ConDataBase dbCon, long designID, ReplicationTable repTable) throws Exception {
        Participant part = null;
        Vector repPart = DesignSQLLayer.selectParticipants(dbCon, designID, true, true);
        UnitTable table = repTable.createUnitTable(designID, -1L);
        for (int i = 0; i < repPart.size(); ++i) {
            part = (Participant)repPart.get(i);
            table.setParticipantID(part.getParticipantID());
            table.setIsMasterTable(part.isMaster());
            DesignSQLLayer.insertUnitTable(dbCon, table);
        }
    }

    public static void createDestinations(ConDataBase dbCon, ConMessageServer msCon, boolean asyncUse) throws Exception {
        Vector masterParticipants = DesignSQLLayer.selectParticipants(dbCon, -1L, true, false);
        for (int j = 0; j < masterParticipants.size(); ++j) {
            Participant masterParticipant = (Participant)masterParticipants.get(j);
            Vector repPart = DesignSQLLayer.selectParticipants(dbCon, masterParticipant.getDesignID(), true, true);
            String exceptionStatus = "";
            for (int i = 0; i < repPart.size(); ++i) {
                Participant part = (Participant)repPart.get(i);
                try {
                    DesignSQLLayer.createOneDestination(dbCon, msCon, part, asyncUse);
                    continue;
                }
                catch (Exception ex) {
                    exceptionStatus = exceptionStatus + "Could not create message destination for :'" + part.getParticipantName() + "' due to " + ex.toString() + LINE_SEP;
                }
            }
            if (exceptionStatus.length() <= 0) continue;
            throw new Exception(exceptionStatus);
        }
    }

    public static void createOneDestination(ConDataBase dbCon, ConMessageServer msCon, Participant part, boolean asyncUse) throws Exception {
        String[] pass = null;
        String msg = "";
        if (part.isInstalled()) {
            if (part.getParticipantType() == 2) {
                if (!part.isMaster()) {
                    pass = DesignSQLLayer.selectMsgDestPasswords(dbCon, part.getDesignID(), false);
                    DesignSQLLayer.createDurableSubscriptions(msCon, part, pass[0], asyncUse);
                } else {
                    pass = DesignSQLLayer.selectMsgDestPasswords(dbCon, part.getDesignID(), true);
                    msCon.send(Resources.getString("MessageServer.cmd_create_queue") + " " + part.getInDest() + " " + SQLBuilder.makeMsgSvrPassword((String)pass[0], (String)part.getInDest()) + "," + SQLBuilder.makeMsgSvrPassword((String)pass[1], (String)"com.sap.sdb.syncMan.util.0CAFFE"), true);
                    msg = Resources.getString("MessageServer.cmd_create_queue") + part.getInDest() + Resources.getString("MessageServer.on_message_server");
                    if (asyncUse) {
                        SQLBuilder.writeProtAsync((String)msg, (boolean)false);
                    } else {
                        SQLBuilder.writeProt((String)msg, (boolean)false);
                    }
                    pass = DesignSQLLayer.selectMsgDestPasswords(dbCon, part.getDesignID(), false);
                    msCon.send(Resources.getString("MessageServer.cmd_create_topic") + " " + part.getOutDest() + " " + SQLBuilder.makeMsgSvrPassword((String)pass[0], (String)part.getOutDest()) + "," + SQLBuilder.makeMsgSvrPassword((String)pass[1], (String)"com.sap.sdb.syncMan.util.0CAFFE"), true);
                    msg = Resources.getString("MessageServer.cmd_create_topic") + part.getOutDest() + Resources.getString("MessageServer.on_message_server");
                    if (asyncUse) {
                        SQLBuilder.writeProtAsync((String)msg, (boolean)false);
                    } else {
                        SQLBuilder.writeProt((String)msg, (boolean)false);
                    }
                }
            } else if (part.getParticipantType() == 1) {
                if (part.isMaster()) {
                    pass = DesignSQLLayer.selectMsgDestPasswords(dbCon, part.getDesignID(), true);
                    msCon.send(Resources.getString("MessageServer.cmd_create_queue") + " " + part.getInDest() + " " + SQLBuilder.makeMsgSvrPassword((String)pass[0], (String)part.getInDest()) + "," + SQLBuilder.makeMsgSvrPassword((String)pass[1], (String)"com.sap.sdb.syncMan.util.0CAFFE"), true);
                    msg = Resources.getString("MessageServer.cmd_create_queue") + part.getInDest() + Resources.getString("MessageServer.on_message_server");
                    if (asyncUse) {
                        SQLBuilder.writeProtAsync((String)msg, (boolean)false);
                    } else {
                        SQLBuilder.writeProt((String)msg, (boolean)false);
                    }
                } else {
                    pass = DesignSQLLayer.selectMsgDestPasswords(dbCon, part.getDesignID(), false);
                    DesignSQLLayer.createDurableSubscriptions(msCon, part, pass[0], asyncUse);
                }
            } else if (part.getParticipantType() == 0 && part.isMaster()) {
                pass = DesignSQLLayer.selectMsgDestPasswords(dbCon, part.getDesignID(), false);
                msCon.send(Resources.getString("MessageServer.cmd_create_topic") + " " + part.getOutDest() + " " + SQLBuilder.makeMsgSvrPassword((String)pass[0], (String)part.getOutDest()) + "," + SQLBuilder.makeMsgSvrPassword((String)pass[1], (String)"com.sap.sdb.syncMan.util.0CAFFE"), true);
                msg = Resources.getString("MessageServer.cmd_create_topic") + part.getOutDest() + Resources.getString("MessageServer.on_message_server");
                if (asyncUse) {
                    SQLBuilder.writeProtAsync((String)msg, (boolean)false);
                } else {
                    SQLBuilder.writeProt((String)msg, (boolean)false);
                }
            }
        }
    }

    private static void createDurableSubscriptions(ConMessageServer msCon, Participant part, String msgReadPass, boolean asyncUse) throws Exception {
        String subscription = String.valueOf(part.getParticipantID());
        if (!(part.getParticipantType() != 2 && part.getParticipantType() != 1 || part.isMaster())) {
            msCon.createDurableTopicSubscriber(part.getInDest(), subscription, SQLBuilder.makeMsgSvrPassword((String)msgReadPass, (String)part.getInDest()), part.getParticipantID());
            String msg = Resources.getString("MessageServer.create_durable_topic_subscriber") + subscription + Resources.getString("MessageServer.on_message_server_for") + part.getParticipantName();
            if (asyncUse) {
                SQLBuilder.writeProtAsync((String)msg, (boolean)false);
            } else {
                SQLBuilder.writeProt((String)msg, (boolean)false);
            }
        }
    }

    public static long parseDesignID(String name) {
        int temp = name.lastIndexOf("_");
        if (temp < 1) {
            return -1L;
        }
        String unit = name.substring(temp + 1, name.length());
        return Long.parseLong(unit);
    }

    public static boolean checkParticipantParameters(ConDataBase dbCon, Participant part) throws SQLException {
        if (part.isMaster()) {
            part.setPassWord(dbCon.getPassWord());
        }
        ParticipantConfig config = null;
        config = part.getConfig();
        if (config == null) {
            config = DesignSQLLayer.selectParticipantConfig(dbCon, part.getHost(), part.getDataBase());
            if (config == null) {
                return false;
            }
            part.setConfig(config);
        }
        boolean needDB = true;
        if (config.jdbcDriver().startsWith("com.sap.sdb.minDB")) {
            needDB = false;
        }
        return part.getHost().length() >= 1 && (!needDB || part.getDataBase().length() >= 1) && part.getUser().length() >= 1 && part.getPassWord().length() >= 1;
    }

    private static void setNumericParam(int i, PreparedStatement stmt, ConDataBase dbCon, long value) throws SQLException {
        if (dbCon.isMySQL()) {
            if (dbCon.getDatabaseMajorVersion() < 5) {
                stmt.setString(1, Long.toString(value));
            } else {
                stmt.setLong(i, value);
            }
        } else {
            stmt.setLong(i, value);
        }
    }
}

