/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.design;

import com.sap.sdb.syncMan.design.Column;
import java.util.Enumeration;
import java.util.Vector;

public class ColumnGroup {
    private boolean mContainsBlobColumn = false;
    private boolean mForReplication = false;
    private boolean mVersioned = false;
    private boolean mKeyCols = false;
    private String mName = null;
    private long mColumnGroupID = -1L;
    private Vector mColumns = null;

    public ColumnGroup(String name, long columnGroupID) {
        this.mName = name;
        this.mColumnGroupID = columnGroupID;
        this.mColumns = new Vector();
        this.mKeyCols = false;
        this.mForReplication = true;
    }

    public boolean forReplication() {
        return this.mForReplication;
    }

    public void setForReplication(boolean forReplication) {
        this.mForReplication = forReplication;
    }

    public long columnGroupID() {
        return this.mColumnGroupID;
    }

    public boolean versioned() {
        return this.mVersioned;
    }

    public void setVersioned(boolean versioned) {
        this.mVersioned = versioned;
    }

    public boolean keyCols() {
        return this.mKeyCols;
    }

    public void setKeyCols(boolean keyCols) {
        this.mKeyCols = keyCols;
    }

    protected void addColumn(Column col) throws Exception {
        Column colTest;
        if (this.mColumns.contains(col)) {
            throw new Exception("Column already in Column Group");
        }
        int i = 0;
        for (i = 0; i < this.mColumns.size() && (colTest = (Column)this.mColumns.get(i)).pos() <= col.pos(); ++i) {
        }
        this.mColumns.add(i, col);
        if (col.sqlType() == -4 || col.sqlType() == -1) {
            this.mContainsBlobColumn = true;
        }
    }

    public boolean containsBlobColumn() {
        return this.mContainsBlobColumn;
    }

    public ColumnGroup cloneColumnGroup() throws Exception {
        ColumnGroup cg = new ColumnGroup(this.mName, this.mColumnGroupID);
        cg.setForReplication(this.mForReplication);
        cg.setVersioned(this.mVersioned);
        cg.setKeyCols(this.mKeyCols);
        Enumeration enumCG = this.mColumns.elements();
        while (enumCG.hasMoreElements()) {
            Column col = (Column)enumCG.nextElement();
            cg.addColumn((Column)col.cloneColumn());
        }
        return cg;
    }

    public String columnGroupName() {
        return this.mName;
    }

    protected boolean removeColumn(Column col) throws Exception {
        boolean ret = this.mColumns.remove(col);
        if (!ret) {
            throw new Exception("Column not in Column Group");
        }
        if ((col.sqlType() == -4 || col.sqlType() == -1) && this.mContainsBlobColumn) {
            this.checkForOtherBlobColumns();
        }
        return ret;
    }

    protected boolean containsColumn(Column col) {
        return this.mColumns.contains(col);
    }

    public Enumeration columns() {
        return this.mColumns.elements();
    }

    public int columnCount() {
        return this.mColumns.size();
    }

    public Column getColumnByName(String name) {
        Column col = null;
        for (int i = 0; i < this.mColumns.size(); ++i) {
            Column temp = (Column)this.mColumns.get(i);
            if (!temp.columnName().equals(name)) continue;
            return temp;
        }
        return col;
    }

    public Column getColumn(int index) {
        return (Column)this.mColumns.get(index);
    }

    public String toString() {
        return this.mName;
    }

    private void checkForOtherBlobColumns() {
        for (int i = 0; i < this.mColumns.size(); ++i) {
            Column col = (Column)this.mColumns.get(i);
            if (col.sqlType() != -4 && col.sqlType() != -1) continue;
            this.mContainsBlobColumn = true;
            return;
        }
        this.mContainsBlobColumn = false;
    }
}

