/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.utilities.webdav.protocol;

import com.sap.sapdb.testframe.utilities.webdav.protocol.Handler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.net.URL;
import sun.net.www.protocol.http.HttpURLConnection;

public class WebDAVHttpConnection
extends HttpURLConnection {
    private static final String[] methods = new String[]{"GET", "POST", "HEAD", "OPTIONS", "PUT", "DELETE", "MKCOL", "COPY", "MOVE", "PROPFIND", "PROPPATCH", "LOCK", "UNLOCK"};

    protected WebDAVHttpConnection(URL u, Handler handler) throws IOException {
        super(u, handler);
    }

    public WebDAVHttpConnection(URL u, String host, int port) throws IOException {
        super(u, host, port);
    }

    public synchronized InputStream getInputStream() throws IOException {
        InputStream is = null;
        try {
            is = super.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return is;
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        OutputStream os = null;
        String savedMethod = this.method;
        this.method = this.method.equals("GET") || this.method.equals("PUT") || this.method.equals("POST") || this.method.equals("PROPFIND") || this.method.equals("PROPPATCH") || this.method.equals("MKCOL") || this.method.equals("MOVE") || this.method.equals("COPY") || this.method.equals("LOCK") ? "PUT" : "DELETE";
        os = super.getOutputStream();
        this.method = savedMethod;
        return os;
    }

    public void setRequestMethod(String method) throws ProtocolException {
        if (this.connected) {
            throw new ProtocolException("Cannot reset method once connected");
        }
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].equals(method)) continue;
            this.method = method;
            return;
        }
        throw new ProtocolException("Invalid WebDAV method: " + method);
    }
}

