/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.utilities;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Zipper {
    private File zipFile;
    private Vector sourceFiles = new Vector();
    private String zipcomment;
    private boolean deleteSourceFiles = false;
    private File rootDirectory;

    public Zipper() {
        this(null, null);
    }

    public Zipper(File zipfile) throws IllegalArgumentException {
        this(zipfile, null);
    }

    public Zipper(File zipfile, File rootDirectory) {
        this.setZipFile(zipfile);
        this.setRootDirectory(rootDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void zip() throws IOException {
        if (this.zipFile == null) throw new FileNotFoundException("zipFile can't be null");
        if (this.zipFile.exists()) {
            if (!this.zipFile.isFile()) throw new IOException("zipFile must be a file");
            if (!this.zipFile.canWrite()) {
                throw new IOException("Can't write to zipfile");
            }
        } else if (!this.zipFile.createNewFile()) {
            throw new IOException("Couldn't create zipfile");
        }
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(new FileOutputStream(this.zipFile));
            if (this.zipcomment != null) {
                zos.setComment(this.zipcomment);
            }
            for (int i = 0; i < this.sourceFiles.size(); ++i) {
                byte[] buff = new byte[1024];
                File currfile = (File)this.sourceFiles.get(i);
                if (!currfile.isDirectory()) {
                    int bytesread;
                    BufferedInputStream bis = new BufferedInputStream(new FileInputStream(currfile));
                    zos.putNextEntry(new ZipEntry(this.getRelativePath(currfile, this.getRootDirectory())));
                    while ((bytesread = bis.read(buff)) != -1) {
                        zos.write(buff, 0, bytesread);
                    }
                    bis.close();
                }
                if (!this.deleteSourceFiles) continue;
                currfile.delete();
            }
            return;
        }
        finally {
            if (zos != null) {
                zos.close();
            }
        }
    }

    public boolean addFiles(File[] filearr) {
        boolean res = false;
        for (int i = 0; i < filearr.length; ++i) {
            if (!this.addFile(filearr[i])) continue;
            res = true;
        }
        return res;
    }

    public boolean addFile(File file) {
        if (file != null && file.exists() && file.canRead()) {
            if (file.isDirectory()) {
                boolean res = true;
                File[] subfiles = file.listFiles();
                for (int i = 0; i < subfiles.length && (res = this.addFile(subfiles[i])); ++i) {
                }
                this.sourceFiles.add(file);
                return res;
            }
            this.sourceFiles.add(file);
            return true;
        }
        return false;
    }

    public boolean removeFile(File file) {
        boolean compareResult = false;
        boolean removedSth = false;
        for (int i = 0; i < this.sourceFiles.size(); ++i) {
            File currfile = (File)this.sourceFiles.get(i);
            do {
                if (!(compareResult = file.equals(currfile))) continue;
                this.sourceFiles.remove(i);
                removedSth = true;
            } while ((currfile = currfile.getParentFile()) != null);
        }
        return removedSth;
    }

    public File getZipFile() {
        return this.zipFile;
    }

    public void setZipFile(File file) {
        this.zipFile = file;
    }

    public String getZipcomment() {
        return this.zipcomment;
    }

    public void setZipcomment(String comment) {
        this.zipcomment = comment;
    }

    public boolean deletesSourceFiles() {
        return this.deleteSourceFiles;
    }

    public void setDeleteSourceFiles(boolean deleteSourceFiles) {
        this.deleteSourceFiles = deleteSourceFiles;
    }

    public File getRootDirectory() {
        return this.rootDirectory;
    }

    public void setRootDirectory(File file) {
        this.rootDirectory = file;
    }

    private String getRelativePath(File theFile, File rootDir) {
        String filePath = theFile.getAbsolutePath();
        if (rootDir == null) {
            return filePath;
        }
        String theRootPath = rootDir.getAbsolutePath();
        if (filePath.startsWith(theRootPath)) {
            return filePath.substring(theRootPath.length() + 1);
        }
        return filePath;
    }
}

