/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.utilities;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.utilities.Sut2JavaParser;
import com.sap.sapdb.testframe.utilities.Sut2JavaScanner;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Sut2Java
extends TestCase {
    private String mBuffer;
    private String mColumnNames;
    private String mValues;
    private boolean mFirstRow;
    private FileWriter mFileWriter;
    private PrintWriter mPrintWriter;
    private int mStepNumber = 1;
    private String SQLCommand = "";
    private String SQLQuery = "";
    private boolean mNewlineWanted;
    private static boolean mDebugOn;
    private int mCommandCounter = 0;
    private int mNumberOfExecuteMethods = 1;
    private int mMaxStatementsPerMethod;
    private String mClassName;
    private String mInputFilename;
    private String mOutputFilename;

    public Sut2Java() throws TestDatabaseException, SQLException {
        this.resetValues();
        mDebugOn = false;
    }

    void addToBuffer(String NextValue) {
        this.mBuffer = this.mBuffer + NextValue;
    }

    void addValue(String ColumnValue) {
        this.mValues = this.mValues + ", " + ColumnValue;
        if (mDebugOn) {
            Sut2Java.printDebug("*** Adding short value: " + ColumnValue);
        }
    }

    void addValue(String ColumnName, String ColumnValue) {
        this.mValues = this.mValues + ", " + ColumnValue;
        this.mColumnNames = this.mColumnNames + ", " + ColumnName;
        if (mDebugOn) {
            Sut2Java.printDebug("*** Adding values: " + ColumnName + ", " + ColumnValue);
        }
    }

    void clearBuffer() {
        this.mBuffer = "";
    }

    private void generateNextExecuteMethod() {
        ++this.mCommandCounter;
        if (this.mCommandCounter < this.mMaxStatementsPerMethod) {
            return;
        }
        this.mCommandCounter = 0;
        ++this.mNumberOfExecuteMethods;
        this.printResult("   }                                                                                     ");
        this.printResult(" \tcatch (Exception e)                                                                   ");
        this.printResult("   {                                                                                     ");
        this.printResult("      this.handleExceptions(e);                                                          ");
        this.printResult("   }                                                                                     ");
        this.printResult("}                                                                                        ");
        this.printResult("                                                                                         ");
        this.printResult("private void execute" + this.mNumberOfExecuteMethods + "()                                    ");
        this.printResult("{                                                                                        ");
        this.printResult("   try                                                                                   ");
        this.printResult("   {                                                                                     ");
    }

    public static void prepare() throws TestCaseException {
    }

    void printCheck() {
        if (this.SQLCommand != "") {
            this.printResult(this.SQLCommand);
            this.SQLCommand = "";
        }
        if (this.SQLQuery != "") {
            this.printResult(this.SQLQuery);
            this.SQLQuery = "";
        }
        this.printResult("      checkQuery(stm, ref, \"Check" + this.mStepNumber + "\");");
        this.printResult("      ref.clear();");
        this.mNewlineWanted = true;
        ++this.mStepNumber;
        if (this.mStepNumber % 5 == 0) {
            System.out.print(".");
        }
        this.mBuffer = "";
        ++this.mCommandCounter;
        this.generateNextExecuteMethod();
    }

    static void printDebug(String DebugMessage) {
        if (mDebugOn) {
            System.out.println(DebugMessage);
        }
    }

    void printError(String QueryString) {
        if (this.SQLCommand != "") {
            if (this.mNewlineWanted) {
                this.printResult("");
            }
            this.printResult("      // check if the command produces the error code " + QueryString.trim());
            this.printResult("      stm.enableExceptions(false);");
            this.printResult(this.SQLCommand);
            this.printResult("      checkErrorCode(stm, " + QueryString.trim() + ", \"Check" + this.mStepNumber + "\");");
            this.printResult("      stm.enableExceptions(true);");
            this.mNewlineWanted = true;
            this.SQLCommand = "";
            ++this.mStepNumber;
            this.mCommandCounter += 4;
        }
        if (this.SQLQuery != "") {
            if (this.mNewlineWanted) {
                this.printResult("");
            }
            this.printResult("      // check if the query produces the error code " + QueryString.trim());
            this.printResult("      stm.enableExceptions(false);");
            this.printResult(this.SQLQuery);
            this.printResult("      checkErrorCode(stm, " + QueryString.trim() + ", \"Check" + this.mStepNumber + "\");");
            this.printResult("      stm.enableExceptions(true);");
            this.mNewlineWanted = true;
            this.SQLQuery = "";
            ++this.mStepNumber;
            this.mCommandCounter += 4;
        }
        this.generateNextExecuteMethod();
    }

    void printHeader() {
        SimpleDateFormat DForm = new SimpleDateFormat("dd.MM.yyyy");
        this.printResult("package Tests;                                                                              ");
        this.printResult("import java.sql.*;                                                                          ");
        this.printResult("import com.sap.sapdb.testframe.testcase.*;                                                       ");
        this.printResult("                                                                                            ");
        this.printResult("/**                                                                                         ");
        this.printResult(" * Generated java class for SQL tests.<p>                                                   ");
        this.printResult(" * This class is generated with Sut2Java on the <p>                                         ");
        this.printResult(" * " + DForm.format(new Date()) + "<p>                                                      ");
        this.printResult(" * from the SUT file                                                                        ");
        this.printResult(" * <pre>                                                                                    ");
        this.printResult(" * " + this.mInputFilename + "                                                                        ");
        this.printResult(" * </pre>                                                                                   ");
        this.printResult(" *                                                                                          ");
        this.printResult(" * <b>Important:</b> The generated SQL commands in the {@link run()}-method must            ");
        this.printResult(" * be checked manually before this class can replace the SUT!<p>                            ");
        this.printResult(" * Please use this class only as a template for the correct Single User Test.               ");
        this.printResult(" *                                                                                          ");
        this.printResult(" * @author: Tim Woehrle                                                                     ");
        this.printResult(" */                                                                                         ");
        this.printResult("public class " + this.mClassName + " extends com.sap.sapdb.testframe.testcase.TestCase {              ");
        this.printResult("/**                                                                                         ");
        this.printResult(" * Default constructor.                                                                     ");
        this.printResult(" * @exception com.sap.sapdb.testframe.driver.TestDatabaseException The exception description.    ");
        this.printResult(" * @exception java.sql.SQLException The exception description.                              ");
        this.printResult(" */                                                                                         ");
        this.printResult("                                                                                            ");
        this.printResult("   java.sql.ResultSet res;                                                                  ");
        this.printResult("   Connection con;                                                                          ");
        this.printResult("   TestStatement stm;                                                                       ");
        this.printResult("   VerificationDataSorted ref;                                                              ");
        this.printResult("                                                                                            ");
        this.printResult("protected " + this.mClassName + "() throws com.sap.sapdb.testframe.driver.TestDatabaseException,        ");
        this.printResult("   java.sql.SQLException {                                                                  ");
        this.printResult("   super();                                                                                 ");
        this.printResult("}                                                                                           ");
        this.printResult("/**                                                                                         ");
        this.printResult(" * Implement test preparation code here.                                                    ");
        this.printResult(" */                                                                                         ");
        this.printResult("public static void prepare() throws TestCaseException                                       ");
        this.printResult("{                                                                                           ");
        this.printResult("}                                                                                           ");
        this.printResult("                                                                                            ");
        this.printResult("public void execute1()                                                                           ");
        this.printResult("{                                                                                           ");
        this.printResult("                                                                                            ");
        this.printResult("   try                                                                                      ");
        this.printResult("   {                                                                                        ");
        this.printResult("                                                                                            ");
    }

    void printHostVariable(String HostVariable) {
        this.printResult("   !!! Warning: host variable " + HostVariable + " cannot be processed automatically !!!");
    }

    void printResult(String Message2) {
        if (mDebugOn) {
            System.out.println(Message2);
        }
        this.mPrintWriter.println(Message2);
    }

    void printShortValues() {
        if (this.mFirstRow || this.mNewlineWanted) {
            this.printResult("");
        }
        this.mNewlineWanted = false;
        if (this.SQLCommand != "") {
            this.printResult(this.SQLCommand);
            this.SQLCommand = "";
            this.mCommandCounter += 2;
        }
        if (this.SQLQuery != "") {
            this.printResult("      // Execute a query and compare it to reference values.");
            this.printResult(this.SQLQuery);
            this.SQLQuery = "";
            this.mCommandCounter += 2;
        }
        if (this.mFirstRow) {
            this.mFirstRow = false;
            this.printResult("      ref.add(\"[" + this.mColumnNames.substring(2) + "]\");");
            this.mColumnNames = "";
        } else {
            this.printResult("      ref.add(\"(" + this.mValues.substring(2) + ")\");");
        }
        ++this.mCommandCounter;
        this.mValues = "";
    }

    void printSqlCommand() {
        if (this.mNewlineWanted) {
            this.printResult("");
        }
        this.mNewlineWanted = false;
        if (this.SQLCommand != "") {
            this.printResult(this.SQLCommand);
            this.SQLCommand = "";
        }
        if (this.SQLQuery != "") {
            this.printResult(this.SQLQuery);
            this.SQLQuery = "";
        }
        this.SQLCommand = "      stm.executeUpdate(\"" + this.mBuffer.trim() + "\");";
        this.mBuffer = "";
        this.generateNextExecuteMethod();
    }

    void printSqlQuery() {
        if (this.SQLCommand != "") {
            this.printResult(this.SQLCommand);
            this.SQLCommand = "";
        }
        if (this.SQLQuery != "") {
            this.printResult(this.SQLQuery);
            this.SQLQuery = "";
        }
        this.SQLQuery = "      res = stm.executeQuery(\"SELECT " + this.mBuffer.trim() + "\");";
        this.mBuffer = "";
        this.generateNextExecuteMethod();
    }

    void printTrailer() {
        if (this.SQLCommand != "") {
            this.printResult(this.SQLCommand);
            this.SQLCommand = "";
        }
        if (this.SQLQuery != "") {
            this.printResult(this.SQLQuery);
            this.SQLQuery = "";
        }
        this.printResult("   }                                                                                        ");
        this.printResult("   catch (Exception e)                                                                      ");
        this.printResult("   {                                                                                        ");
        this.printResult("      this.handleExceptions(e);                                                             ");
        this.printResult("   }                                                                                        ");
        this.printResult("}                                                                                           ");
        this.printResult("                                                                                            ");
        this.printResult("/**                                                                                         ");
        this.printResult(" * Generated method for the test execution.<p>                                              ");
        this.printResult(" * It contains the converted SQL calls from                                                 ");
        this.printResult(" * <pre>                                                                                    ");
        this.printResult(" * " + this.mInputFilename + "                                                                   ");
        this.printResult(" * </pre>                                                                                   ");
        this.printResult(" *                                                                                          ");
        this.printResult(" * and the definition of reference data.<p>                                                 ");
        this.printResult(" *                                                                                          ");
        this.printResult(" * <b>TODO:</b> Check if:                                                                   ");
        this.printResult(" * <li>all necessary SQL commands are converted to executexxx()-calls</li>                  ");
        this.printResult(" * <li>the reference data are correct and complete</li>                                     ");
        this.printResult(" * <li>The fetching of result sets is correct</li>                                          ");
        this.printResult(" */                                                                                         ");
        this.printResult("public void run()                                                                           ");
        this.printResult("{                                                                                           ");
        this.printResult("                                                                                            ");
        this.printResult("   try                                                                                      ");
        this.printResult("   {                                                                                        ");
        this.printResult("      con = this.getDatabase().connect(this.getUser(), this.getPassword());                 ");
        this.printResult("      stm = new TestStatement(this, con);                                                   ");
        this.printResult("      ref = new VerificationDataSorted();                                                   ");
        this.printResult("                                                                                            ");
        for (int i = 0; i < this.mNumberOfExecuteMethods; ++i) {
            this.printResult("      execute" + (i + 1) + "();                                                               ");
        }
        this.printResult("                                                                                            ");
        this.printResult("   } catch (Exception e)                                                                    ");
        this.printResult("   {                                                                                        ");
        this.printResult("      this.handleExceptions(e);                                                             ");
        this.printResult("   }                                                                                        ");
        this.printResult("                                                                                            ");
        this.printResult("}                                                                                           ");
        this.printResult("}                                                                                           ");
    }

    void printValues() {
        if (this.mFirstRow || this.mNewlineWanted) {
            this.printResult("");
        }
        this.mNewlineWanted = false;
        if (this.SQLCommand != "") {
            this.printResult(this.SQLCommand);
            this.SQLCommand = "";
        }
        if (this.SQLQuery != "") {
            this.printResult("      // Execute a query and compare it to reference values.");
            this.printResult(this.SQLQuery);
            this.SQLQuery = "";
            this.mCommandCounter += 2;
        }
        if (this.mFirstRow) {
            this.mFirstRow = false;
            this.printResult("      ref.add(\"[" + this.mColumnNames.substring(2) + "]\");");
            this.mColumnNames = "";
            this.mCommandCounter += 2;
        }
        this.printResult("      ref.add(\"(" + this.mValues.substring(2) + ")\");");
        ++this.mCommandCounter;
        this.mValues = "";
    }

    void resetValues() {
        this.mBuffer = "";
        this.mColumnNames = "";
        this.mValues = "";
        this.mFirstRow = true;
    }

    public void run() {
        try {
            FileInputStream InputFile;
            mDebugOn = Sut2Java.getParameterBoolean("DebugOn", true);
            this.mMaxStatementsPerMethod = Sut2Java.getParameterInt("MaxStatementsPerMethod", 200);
            this.mInputFilename = Sut2Java.getParameterString("InputFileName", "C:\\A.punix");
            if (this.mInputFilename.equals("")) {
                Sut2Java.addGlobalMessage("WrongParameters", 'E', "Missing name of the .vdnts-File (Parameter FileName)");
                return;
            }
            int StartPos = this.mInputFilename.lastIndexOf("\\");
            int EndPos = this.mInputFilename.lastIndexOf(".");
            this.mClassName = Sut2Java.getParameterString("ClassName", "");
            if (this.mClassName.equals("")) {
                this.mClassName = this.mInputFilename.substring(StartPos + 1, EndPos);
            }
            this.mOutputFilename = Sut2Java.getParameterString("OutputFileName", "");
            if (this.mOutputFilename.equals("")) {
                this.mOutputFilename = this.mInputFilename.substring(0, StartPos + 1) + this.mClassName + ".java";
            }
            try {
                InputFile = new FileInputStream(this.mInputFilename);
            }
            catch (FileNotFoundException e) {
                Sut2Java.addGlobalMessage("FileNotFound", 'E', "The SUT file '" + this.mInputFilename + "' doesn't exist.");
                return;
            }
            try {
                this.mFileWriter = new FileWriter(this.mOutputFilename, false);
            }
            catch (FileNotFoundException e) {
                Sut2Java.addGlobalMessage("FileNotAccessible", 'E', "The output file '" + this.mOutputFilename + "' is not accessible.");
                return;
            }
            this.mPrintWriter = new PrintWriter(this.mFileWriter);
            this.printHeader();
            Sut2JavaScanner Scanner = new Sut2JavaScanner(InputFile);
            Sut2JavaParser Parser = new Sut2JavaParser();
            Parser.yyparse(Scanner, this);
            this.printTrailer();
        }
        catch (Sut2JavaParser.yyException e) {
            this.printTrailer();
        }
        catch (Exception e) {
            Sut2Java.addGlobalMessage("General error", 'E', e.getMessage());
        }
        this.mPrintWriter.close();
    }

    public static void setDebug(boolean EnableDebug) {
        mDebugOn = EnableDebug;
    }
}

