/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.utilities;

class InternalCombination {
    private int mMaximalCombinations = -1;
    private int[][] mCombinations = null;
    private int[] mIntArray = null;
    private int mArrayLength = -1;

    InternalCombination() {
    }

    public InternalCombination(int[] pIntArray) {
        this(pIntArray, pIntArray.length);
    }

    public InternalCombination(int[] pIntArray, int pArrayLength) {
        this();
        this.mIntArray = pIntArray;
        this.mArrayLength = pArrayLength;
        this.mMaximalCombinations = this.determineCombinations();
    }

    public static int calculateCombinations(int pQuanLen) {
        int li = 1;
        for (int i = 0; i < pQuanLen; ++i) {
            li *= pQuanLen - i;
        }
        return li;
    }

    public int determineCombinations() {
        if (this.mMaximalCombinations != -1) {
            return this.mMaximalCombinations;
        }
        int li = 1;
        for (int i = 0; i < this.mArrayLength; ++i) {
            li *= this.mArrayLength - i;
        }
        return li;
    }

    public int getArrayLength() {
        return this.mArrayLength;
    }

    public int[][] getCombinations() {
        if (this.mCombinations == null) {
            this.mCombinations = this.getCombinationsInternal(this.mArrayLength, this.mIntArray);
        }
        return this.mCombinations;
    }

    private int[][] getCombinationsInternal(int pQuanLen, int[] pQuan) {
        int lComb = 0;
        int[][] ri = new int[this.determineCombinations()][pQuanLen];
        if (pQuanLen < 1) {
            return null;
        }
        if (pQuanLen == 1) {
            ri[0][0] = pQuan[0];
            return ri;
        }
        if (pQuanLen == 2) {
            ri[0][0] = pQuan[0];
            ri[0][1] = pQuan[1];
            ri[1][0] = pQuan[1];
            ri[1][1] = pQuan[0];
            return ri;
        }
        int[] tempQuan = new int[pQuanLen - 1];
        int noOfCombs = InternalCombination.calculateCombinations(pQuanLen - 1);
        for (int i = 0; i < pQuanLen; ++i) {
            int k = 0;
            for (int j = 0; j < pQuanLen; ++j) {
                if (i == j) continue;
                tempQuan[k++] = pQuan[j];
            }
            int[][] rComb = this.getCombinationsInternal(pQuanLen - 1, tempQuan);
            for (int j = 0; j < noOfCombs; ++j) {
                ri[lComb][0] = pQuan[i];
                for (int l = 0; l < pQuanLen - 1; ++l) {
                    ri[lComb][l + 1] = rComb[j][l];
                }
                ++lComb;
            }
        }
        return ri;
    }

    public static void main(String[] args) {
        int[] y = new int[]{1, 2, 3, 4};
        int no = y.length;
        InternalCombination c = new InternalCombination(y, no);
        int[][] res = c.getCombinations();
        boolean checkError = true;
        boolean error = false;
        if (checkError) {
            int j;
            int i;
            String[] s = new String[c.determineCombinations()];
            for (i = 0; i < c.determineCombinations(); ++i) {
                for (j = 0; j < no; ++j) {
                    System.out.print(res[i][j]);
                    s[i] = s[i] + res[i][j];
                }
                System.out.println("");
            }
            for (i = 0; i < s.length; ++i) {
                for (j = i + 1; j < s.length; ++j) {
                    if (!s[i].equals(s[j])) continue;
                    error = true;
                    break;
                }
                if (error) break;
            }
        }
        System.out.println("No of Combinations: " + c.determineCombinations());
        if (error) {
            System.out.println("ERROR - Combination doubled");
        } else {
            System.out.println("SUCCESS - No duplicates");
        }
    }
}

