/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.utilities;

import java.text.ParseException;

public class Conversion {
    private Conversion() {
    }

    public static byte[] stringToHex(String s) throws ParseException {
        if (s == null) {
            return new byte[0];
        }
        if (s.startsWith("X")) {
            s = s.substring(1);
        }
        if (!s.matches("\\p{XDigit}*")) {
            throw new ParseException("Binary value " + s + " contains non hexa decimal characters. Only 0-9 a-f A-F are allowed", 0);
        }
        if (s.length() % 2 != 0) {
            throw new ParseException("Binary value must have an even length.", s.length() - 1);
        }
        int leng = s.length() / 2;
        byte[] bytearray = new byte[leng];
        for (int i = 0; i < leng; ++i) {
            bytearray[i] = (byte)Integer.parseInt(s.substring(i * 2, i * 2 + 2), 16);
        }
        return bytearray;
    }

    public static String hexToString(byte[] bytearr) {
        if (bytearr == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int k = 0; k < bytearr.length; ++k) {
            if ((bytearr[k] & 0xFF) < 10) {
                sb.append("0");
            }
            sb.append(Integer.toString(bytearr[k] & 0xFF, 16));
        }
        return sb.toString();
    }

    public static int getSQLTypeFromString(String typename) {
        String dataTypeS = typename.toUpperCase();
        int dataType = dataTypeS.equals("BOOLEAN") ? 16 : (dataTypeS.equals("INTEGER") || dataTypeS.equals("INT") ? 4 : (dataTypeS.equals("SMALLINT") ? 5 : (dataTypeS.startsWith("FIXED") || dataTypeS.startsWith("DECIMAL") || dataTypeS.startsWith("NUMERIC") ? 3 : (dataTypeS.startsWith("FLOAT") ? 6 : (dataTypeS.startsWith("REAL") ? 7 : (dataTypeS.startsWith("CHAR") ? 1 : (dataTypeS.startsWith("VARCHAR") ? 12 : (dataTypeS.equals("LONG") || dataTypeS.equals("LONGVARCHAR") ? -1 : (dataTypeS.equals("LONGVARBINARY") ? -4 : (dataTypeS.startsWith("DATE") ? 91 : (dataTypeS.startsWith("TIMESTAMP") ? 93 : (dataTypeS.startsWith("TIME") ? 92 : 1111))))))))))));
        return dataType;
    }

    public static String getStringFromSQLType(int dataType) {
        String typename;
        switch (dataType) {
            case 4: {
                typename = "INTEGER";
                break;
            }
            case 5: {
                typename = "SMALLINT";
                break;
            }
            case 3: {
                typename = "FIXED";
                break;
            }
            case 2: {
                typename = "FIXED";
                break;
            }
            case 6: {
                typename = "FLOAT";
                break;
            }
            case 1: {
                typename = "CHAR";
                break;
            }
            case 12: {
                typename = "VARCHAR";
                break;
            }
            case -1: {
                typename = "LONGVARCHAR";
                break;
            }
            case -4: {
                typename = "LONGVARBINARY";
                break;
            }
            case 91: {
                typename = "DATE";
                break;
            }
            case 93: {
                typename = "TIMESTAMP";
                break;
            }
            case 92: {
                typename = "TIME";
                break;
            }
            case 2004: {
                typename = "BLOB";
                break;
            }
            case 2005: {
                typename = "CLOB";
                break;
            }
            case 16: {
                typename = "BOOLEAN";
                break;
            }
            case -7: {
                typename = "BOOLEAN";
                break;
            }
            default: {
                typename = "OTHER";
            }
        }
        return typename;
    }
}

