/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.testcase;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestResultDatabase;
import com.sap.sapdb.testframe.testcase.ExplainObject;
import com.sap.sapdb.testframe.testcase.VerificationData;
import com.sap.sapdb.testframe.testcase.VerificationDataComplete;
import com.sap.sapdb.testframe.testcase.VerificationDataSorted;
import com.sap.sapdb.testframe.testcase.VerificationDataSubset;
import com.sap.sapdb.testframe.testcase.VerificationItem;
import com.sap.sapdb.testframe.testcase.VerificationItemData;
import com.sap.sapdb.testframe.testcase.VerificationObjectKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

abstract class VerificationObject
extends VerificationObjectKey {
    private HashMap mResultObjectItems;
    private String mDatabaseTable;
    static final String ERROR_SQL_EXCEPTION = "SQLException";
    boolean mStoredOneTime;
    private boolean mModifiedAfterLastStore;
    private String[] mSortedObjectItems = new String[500];
    private TestResultDatabase mDatabase;
    private boolean mSaveOnFinalize = false;
    private int mItemsWritten = 0;
    private PrintWriter mOutputScreen;
    private static final char NO_VERIFICATION_DATA = '0';
    private String mDatabaseTableData;

    VerificationObject(String pTestId, String pDbSys, TestResultDatabase pDatabase) {
        super(pTestId, pDbSys, -1);
        this.mDatabase = pDatabase;
        this.mStoredOneTime = false;
        this.mModifiedAfterLastStore = false;
        this.mResultObjectItems = new HashMap();
    }

    public Iterator compareItem(VerificationObject pCompareObject, String pStep) {
        try {
            return this.getItem(pStep).compare(pCompareObject.getItem(pStep));
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public boolean equalsItem(VerificationObject pCompareObject, String pStep) {
        try {
            return this.getItem(pStep).equals(pCompareObject.getItem(pStep));
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public final void finalize() {
        if (this.mOutputScreen != null) {
            this.mOutputScreen.close();
        }
        if (this.isSaveOnFinalize()) {
            try {
                this.save();
            }
            catch (Exception e) {
                System.out.println("Error saving verification object");
                e.printStackTrace();
            }
        }
    }

    TestResultDatabase getDatabase() {
        return this.mDatabase;
    }

    String getDatabaseTable() {
        return this.mDatabaseTable;
    }

    String getDatabaseTableData() {
        return this.mDatabaseTableData;
    }

    public VerificationItem getItem(String pStepNo) {
        VerificationItemData lData = (VerificationItemData)this.mResultObjectItems.get(pStepNo);
        if (lData == null) {
            return null;
        }
        return new VerificationItem(this.getTestId(), this.getDbSysName(), pStepNo, this.getVersion(), lData.getResultCounter(), lData.getSqlStatement(), lData.getExplainObject(), lData.getRuntime(), lData.getExecutionTime(), lData.getErrorIndicator(), lData.getExceptionText(), lData.getVerificationData());
    }

    public boolean isSaveOnFinalize() {
        return this.mSaveOnFinalize;
    }

    public int itemCount() {
        return this.mResultObjectItems.size();
    }

    public int print() throws IOException {
        if (this.mOutputScreen == null) {
            this.mOutputScreen = new PrintWriter(System.out, true);
        }
        int i = this.write(this.mOutputScreen);
        return i;
    }

    public synchronized void putItem(String pStepNo, int pResultSetCounter, String pSqlStatement, ExplainObject pExplainObject, long pRuntime, long pExecutionTime, String pErrorIndicator, String pExceptionText, VerificationData pVData) {
        if (this.mResultObjectItems.put(pStepNo, new VerificationItemData(pResultSetCounter, pSqlStatement, pExplainObject, pRuntime, pExecutionTime, pErrorIndicator, pExceptionText, pVData)) != null) {
            throw new RuntimeException("Duplicate key entries in result set. Check statements for unique STEP's!!! Step: " + pStepNo);
        }
        this.mSortedObjectItems[this.mResultObjectItems.size() - 1] = pStepNo;
        this.mModifiedAfterLastStore = true;
    }

    public synchronized void putItem(String pStepNo, VerificationItemData pData) {
        if (this.mResultObjectItems.put(pStepNo, pData) != null) {
            throw new RuntimeException("Duplicate key entries in result set. Check statements for unique STEP's!!! Step: " + pStepNo);
        }
        this.mSortedObjectItems[this.mResultObjectItems.size() - 1] = pStepNo;
        this.mModifiedAfterLastStore = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int save() throws SQLException, TestDatabaseException {
        int n;
        String lVDataType = String.valueOf('0');
        Connection lConnect = null;
        Statement lDStmt = null;
        Statement lStmt = null;
        Statement lStmt1 = null;
        int i = 0;
        if (!this.mModifiedAfterLastStore) {
            return 0;
        }
        try {
            try {
                lConnect = this.mDatabase.connect();
                lConnect.setAutoCommit(false);
                lDStmt = lConnect.createStatement();
                String lSql = "Delete from " + this.getDatabaseTable() + " where TESTID = '" + this.getTestId() + "' and DBSYSNAME = '" + this.getDbSysName() + "' and VERSION = " + this.getVersion();
                lDStmt.executeUpdate(lSql);
                lSql = "Delete from " + this.getDatabaseTableData() + " where TESTID = '" + this.getTestId() + "' and DBSYSNAME = '" + this.getDbSysName() + "' and VERSION = " + this.getVersion();
                lDStmt.executeUpdate(lSql);
                lSql = "Insert into " + this.getDatabaseTable() + " values ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )";
                lStmt = lConnect.prepareStatement(lSql);
                lStmt.setString(1, this.getTestId());
                lStmt.setString(2, this.getDbSysName());
                lStmt.setInt(3, this.getVersion());
                lSql = "Insert into " + this.getDatabaseTableData() + " values ( ?, ?, ?, ?, ?, ? )";
                lStmt1 = lConnect.prepareStatement(lSql);
                lStmt1.setString(1, this.getTestId());
                lStmt1.setString(2, this.getDbSysName());
                lStmt1.setInt(3, this.getVersion());
                Iterator It = this.mResultObjectItems.entrySet().iterator();
                while (It.hasNext()) {
                    ++i;
                    Map.Entry ME = It.next();
                    String lStepNo = (String)ME.getKey();
                    VerificationItemData lResultItemData = (VerificationItemData)ME.getValue();
                    lStmt.setString(4, lStepNo);
                    lStmt.setString(5, lResultItemData.getSqlStatement());
                    lStmt.setInt(6, lResultItemData.getResultCounter());
                    lStmt.setLong(7, lResultItemData.getRuntime());
                    lStmt.setLong(8, lResultItemData.getExecutionTime());
                    lStmt.setString(9, lResultItemData.getErrorIndicator());
                    lStmt.setString(10, lResultItemData.getExceptionText());
                    VerificationData lVData = lResultItemData.getVerificationData();
                    lVDataType = lVData != null ? String.valueOf(lVData.getOperatorType()) : String.valueOf('0');
                    lStmt.setString(11, lVDataType);
                    ExplainTransformObject lBis = this.transformExplainToInputStream(lResultItemData.getExplainObject());
                    if (lBis != null) {
                        lStmt.setInt(12, lBis.getLen());
                        lStmt.setBinaryStream(13, lBis.getBis(), lBis.getLen());
                    } else {
                        lStmt.setNull(12, 4);
                        lStmt.setNull(13, -4);
                    }
                    if (lVData != null) {
                        boolean lExecutedData = false;
                        lStmt1.setString(4, lStepNo);
                        int j = 0;
                        Iterator lIt = lVData.iterator();
                        while (lIt.hasNext()) {
                            lStmt1.setInt(5, j++);
                            lStmt1.setString(6, (String)lIt.next());
                            lStmt1.addBatch();
                            if (j > 0 && j % 1000 == 0) {
                                lExecutedData = true;
                                lStmt1.executeBatch();
                                lStmt1.clearBatch();
                                continue;
                            }
                            lExecutedData = false;
                        }
                        if (!lExecutedData) {
                            lStmt1.executeBatch();
                        }
                    }
                    lStmt.executeUpdate();
                }
                lConnect.commit();
                this.mStoredOneTime = true;
                this.mModifiedAfterLastStore = false;
                n = i;
                Object var18_20 = null;
            }
            catch (SQLException e) {
                lConnect.rollback();
                throw e;
            }
            catch (Exception e) {
                lConnect.rollback();
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var18_21 = null;
            lDStmt.close();
            lStmt.close();
            lStmt1.close();
            lConnect.close();
            throw throwable;
        }
        lDStmt.close();
        lStmt.close();
        lStmt1.close();
        lConnect.close();
        return n;
    }

    public synchronized int selectFromDatabase() throws SQLException, TestDatabaseException {
        int i = 0;
        VerificationData lVData = null;
        int lVDataType = 48;
        Connection lConnect = null;
        Statement lStmt = null;
        try {
            lConnect = this.mDatabase.connect();
            lStmt = lConnect.createStatement();
            String lSql = "Select * from " + this.getDatabaseTable() + " where TESTID = '" + this.getTestId() + "' and " + "DBSYSNAME = '" + this.getDbSysName() + "' and " + "VERSION = '" + this.getVersion() + "'";
            ResultSet lResultSet = lStmt.executeQuery(lSql);
            while (lResultSet.next()) {
                String lStepNo = lResultSet.getString(4).trim();
                String lStatement = lResultSet.getString(5).trim();
                int lResultCounter = lResultSet.getInt(6);
                long lRuntime = lResultSet.getLong(7);
                long lExecutionTime = lResultSet.getLong(8);
                String lErrorIndicator = lResultSet.getString(9);
                String lExceptionText = lResultSet.getString(10);
                lVDataType = lResultSet.getString(11).charAt(0);
                if (lVDataType != 48) {
                    if (lVDataType == 99) {
                        lVData = new VerificationDataComplete();
                    } else if (lVDataType == 115) {
                        lVData = new VerificationDataSorted();
                    } else if (lVDataType == 117) {
                        lVData = new VerificationDataSubset();
                    }
                } else {
                    lVData = null;
                }
                int llen = lResultSet.getInt(12);
                InputStream lIs = lResultSet.getBinaryStream(13);
                ExplainObject lExplainObject = null;
                if (lIs != null) {
                    lExplainObject = this.transformInputStreamToExplain(lIs, llen);
                    try {
                        lIs.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                ++i;
                if (lVData != null) {
                    lSql = "Select DATA from " + this.getDatabaseTableData() + " where TESTID = '" + this.getTestId() + "' and DBSYSNAME = '" + this.getDbSysName() + "' and VERSION = '" + this.getVersion() + "' and STEP = '" + lStepNo + "'";
                    ResultSet lResultSet1 = lStmt.executeQuery(lSql);
                    while (lResultSet1.next()) {
                        lVData.add(lResultSet1.getString(1));
                    }
                }
                this.putItem(lStepNo, lResultCounter, lStatement, lExplainObject, lRuntime, lExecutionTime, lErrorIndicator, lExceptionText, lVData);
            }
            int n = i;
            return n;
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            try {
                lStmt.close();
            }
            catch (SQLException se) {}
            try {
                lConnect.close();
            }
            catch (SQLException se) {}
        }
    }

    void setDatabaseTable(String newDatabaseTable) {
        this.mDatabaseTable = newDatabaseTable;
    }

    void setDatabaseTableData(String newDatabaseTableData) {
        this.mDatabaseTableData = newDatabaseTableData;
    }

    public void setSaveOnFinalize(boolean newSaveOnFinalize) {
        this.mSaveOnFinalize = newSaveOnFinalize;
    }

    private ExplainTransformObject transformExplainToInputStream(ExplainObject pExplainObject) {
        if (pExplainObject == null) {
            return null;
        }
        try {
            ByteArrayOutputStream ostream = new ByteArrayOutputStream();
            ObjectOutputStream p = new ObjectOutputStream(ostream);
            p.writeObject(pExplainObject);
            p.flush();
            ByteArrayInputStream istream = new ByteArrayInputStream(ostream.toByteArray());
            int flen = ostream.size();
            ostream.close();
            p.close();
            return new ExplainTransformObject(istream, flen);
        }
        catch (IOException e) {
            System.out.println("Error transforming Explain object.\n");
            e.printStackTrace();
            return null;
        }
    }

    private ExplainObject transformInputStreamToExplain(InputStream pIs, int pLen) {
        if (pIs == null) {
            return null;
        }
        try {
            int size;
            byte[] byteBuffer = new byte[pLen];
            ByteArrayInputStream lBis = null;
            while ((size = pIs.read(byteBuffer)) != -1) {
                lBis = new ByteArrayInputStream(byteBuffer);
            }
            ObjectInputStream lOis = new ObjectInputStream(lBis);
            ExplainObject rEO = null;
            try {
                rEO = (ExplainObject)lOis.readObject();
            }
            catch (ClassNotFoundException e) {
                System.out.println("Error deserializing Explain object from stream");
                return null;
            }
            lBis.close();
            lOis.close();
            return rEO;
        }
        catch (IOException e) {
            System.out.println("Error transforming Explain object");
            return null;
        }
    }

    public synchronized int write(PrintWriter pIoDevice) {
        int i = 0;
        if (this.itemCount() == 0) {
            return i;
        }
        if (this.mItemsWritten == 0) {
            pIoDevice.println("Test ID            : " + this.getTestId());
            pIoDevice.println("DB Sys Name        : " + this.getDbSysName());
            pIoDevice.println("Result Version     : " + this.getVersion());
            pIoDevice.println("*************************************************************************");
        }
        for (i = this.mItemsWritten; i < this.mResultObjectItems.size(); ++i) {
            Iterator lIt;
            VerificationItem lWriteItem = this.getItem(this.mSortedObjectItems[i]);
            pIoDevice.println("Step No            : " + lWriteItem.getStepNo());
            if (lWriteItem.getSqlStatement().trim() != "") {
                pIoDevice.println("SQL Statement      : " + lWriteItem.getSqlStatement());
            }
            pIoDevice.println("Result Counter     : " + lWriteItem.getResultCounter());
            pIoDevice.println("Runtime[ms]        : " + lWriteItem.getRuntime());
            if (lWriteItem.getErrorIndicator().trim() != "") {
                pIoDevice.println("Error indidcator   : " + lWriteItem.getErrorIndicator());
            }
            if (lWriteItem.getExceptionText().trim() != "") {
                pIoDevice.println("Exception text     : " + lWriteItem.getExceptionText());
            }
            if (lWriteItem.getExplainObject() != null && (lIt = lWriteItem.getExplainObject().iteratorPretty()) != null) {
                while (lIt.hasNext()) {
                    pIoDevice.println(lIt.next().toString());
                }
            }
            if (lWriteItem.getData().getVerificationData() != null && (lIt = lWriteItem.getData().getVerificationData().iteratorPretty()) != null) {
                while (lIt.hasNext()) {
                    pIoDevice.println(lIt.next().toString());
                }
            }
            pIoDevice.println("*************************************************************************");
        }
        this.mItemsWritten = i;
        return i;
    }

    private static class ExplainTransformObject {
        private ByteArrayInputStream mbis = null;
        private int mlen = -1;

        public ExplainTransformObject(ByteArrayInputStream pbis, int plen) {
            this.mbis = pbis;
            this.mlen = plen;
        }

        public ByteArrayInputStream getBis() {
            return this.mbis;
        }

        public int getLen() {
            return this.mlen;
        }
    }
}

