/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.testcase;

import com.sap.sapdb.testframe.testcase.ExplainObject;
import com.sap.sapdb.testframe.testcase.VerificationData;
import com.sap.sapdb.testframe.testcase.VerificationItemData;
import com.sap.sapdb.testframe.testcase.VerificationItemKey;
import java.util.ArrayList;
import java.util.Iterator;

class VerificationItem
extends VerificationItemKey {
    private VerificationItemData mData;
    private static final int RUN_TIME_FACTOR = 10;

    public VerificationItem(String pTestId, String pDbSysName, String pStepNo, int pVersion, int pResultSetCounter, String pSqlStatement, ExplainObject pExplainObject, long pRuntime, long pExecutionTime, String pErrorIndicator, String pExceptionText, VerificationData pVData) {
        super(pTestId, pDbSysName, pVersion, pStepNo);
        this.mData = new VerificationItemData(pResultSetCounter, pSqlStatement, pExplainObject, pRuntime, pExecutionTime, pErrorIndicator, pExceptionText, pVData);
    }

    public Iterator compare(VerificationItem pCompareItem) {
        ArrayList lDiff = new ArrayList();
        if (!this.equalsStatement(pCompareItem, lDiff)) {
            return lDiff.iterator();
        }
        this.equalsResultCounter(pCompareItem, lDiff);
        this.equalsRuntime(pCompareItem, lDiff);
        this.equalsErrorIndicator(pCompareItem, lDiff);
        this.equalsExceptionText(pCompareItem, lDiff);
        this.equalsExplainObject(pCompareItem, lDiff);
        if (lDiff.isEmpty()) {
            return null;
        }
        return lDiff.iterator();
    }

    public boolean equals(VerificationItem pResultObjectItem) {
        boolean lEqual = true;
        lEqual = this.equalsStatement(pResultObjectItem, null);
        if (lEqual) {
            lEqual = this.equalsResultCounter(pResultObjectItem, null);
        }
        if (lEqual) {
            lEqual = this.equalsRuntime(pResultObjectItem, null);
        }
        if (lEqual) {
            lEqual = this.equalsErrorIndicator(pResultObjectItem, null);
        }
        if (lEqual) {
            lEqual = this.equalsExceptionText(pResultObjectItem, null);
        }
        if (lEqual) {
            lEqual = this.equalsExplainObject(pResultObjectItem, null);
        }
        return lEqual;
    }

    public boolean equalsErrorIndicator(VerificationItem pResultObjectItem, ArrayList pDiffList) {
        boolean lEqual = true;
        if (this.getErrorIndicator() == null || pResultObjectItem.getErrorIndicator() == null) {
            return true;
        }
        if (!this.getErrorIndicator().trim().equals(pResultObjectItem.getErrorIndicator().trim())) {
            if (pDiffList != null) {
                pDiffList.add("Different error indicators. Reference: " + this.getErrorIndicator().trim() + " / Actual: " + pResultObjectItem.getErrorIndicator().trim());
            }
            lEqual = false;
        }
        return lEqual;
    }

    public boolean equalsExceptionText(VerificationItem pResultObjectItem, ArrayList pDiffList) {
        boolean lEqual = true;
        if (this.getExceptionText() == null || pResultObjectItem.getExceptionText() == null) {
            return true;
        }
        if (!this.getExceptionText().trim().equals(pResultObjectItem.getExceptionText().trim())) {
            if (pDiffList != null) {
                pDiffList.add("Different exceptions. Reference: " + this.getExceptionText().trim() + " / Actual: " + pResultObjectItem.getExceptionText().trim());
            }
            lEqual = false;
        }
        return lEqual;
    }

    public boolean equalsExplainObject(VerificationItem pResultObjectItem, ArrayList pDiffList) {
        boolean lEqual = true;
        if (this.getDbSysName().equals(pResultObjectItem.getDbSysName()) && this.getExplainObject() != null && pResultObjectItem.getExplainObject() != null && !this.getExplainObject().equals(pResultObjectItem.getExplainObject()) && pDiffList != null) {
            pDiffList.add("Different explains: " + this.getExplainObject().getEqualsMessage());
            lEqual = false;
        }
        return lEqual;
    }

    public boolean equalsResultCounter(VerificationItem pResultObjectItem, ArrayList pDiffList) {
        boolean lEqual = true;
        if (this.getResultCounter() != pResultObjectItem.getResultCounter()) {
            if (pDiffList != null) {
                pDiffList.add("Different result counters. Reference: " + this.getResultCounter() + " / Actual: " + pResultObjectItem.getResultCounter());
            }
            lEqual = false;
        }
        return lEqual;
    }

    public boolean equalsRuntime(VerificationItem pResultObjectItem, ArrayList pDiffList) {
        boolean lEqual = true;
        if (pResultObjectItem.getRuntime() == 0L || this.getRuntime() == 0L) {
            return true;
        }
        double r1 = pResultObjectItem.getRuntime() * 10L;
        double r2 = pResultObjectItem.getRuntime() / 10L;
        if ((double)this.getRuntime() > r1 || (double)this.getRuntime() < r2) {
            if (pDiffList != null) {
                pDiffList.add("Different runtimes. Reference: " + this.getRuntime() + " / Actual: " + pResultObjectItem.getRuntime());
            }
            lEqual = false;
        }
        return lEqual;
    }

    public boolean equalsStatement(VerificationItem pResultObjectItem, ArrayList pDiffList) {
        boolean lEqual = true;
        if (!this.getSqlStatement().trim().equals(pResultObjectItem.getSqlStatement().trim())) {
            if (pDiffList != null) {
                pDiffList.add("Different sql commands. Reference: " + this.getSqlStatement().trim());
            }
            lEqual = false;
        }
        return lEqual;
    }

    public VerificationItemData getData() {
        return this.mData;
    }

    public String getErrorIndicator() {
        return this.mData.getErrorIndicator();
    }

    public String getExceptionText() {
        return this.mData.getExceptionText();
    }

    public long getExecutionTime() {
        return this.mData.getExecutionTime();
    }

    public ExplainObject getExplainObject() {
        return this.mData.getExplainObject();
    }

    public int getResultCounter() {
        return this.mData.getResultCounter();
    }

    public long getRuntime() {
        return this.mData.getRuntime();
    }

    public String getSqlStatement() {
        return this.mData.getSqlStatement();
    }

    public void setData(VerificationItemData newData) {
        this.mData = newData;
    }

    public void setExecutionTime(long newExecutionTime) {
        this.mData.setExecutionTime(newExecutionTime);
    }

    public void setExplainObject(ExplainObject pExplainObject) {
        this.mData.setExplainObject(pExplainObject);
    }

    public void setResultCounter(int newResultCounter) {
        this.mData.setResultCounter(newResultCounter);
    }

    public void setRuntime(long newRuntime) {
        this.mData.setRuntime(newRuntime);
    }

    public void setSqlStatement(String newSqlStatement) {
        this.mData.setSqlStatement(newSqlStatement);
    }

    public String toString() {
        return super.toString();
    }
}

