/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.testcase;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestPreparedStatement;
import com.sap.sapdb.testframe.testcase.TestStatement;
import com.sap.sapdb.testframe.testcase.VerificationDataComplete;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Random;

public class VerificationDataPerformanceTest
extends TestCase {
    private static final String mExUser = "testteam";
    private static final String mExPassword = "testteam";
    private Connection lConnection = null;
    protected static final String mVersion = "0.1";

    public void run() {
        TestStatement stmt = null;
        TestPreparedStatement prepStmt = null;
        try {
            int i3;
            int i1;
            int j;
            VerificationDataComplete veri;
            int i;
            long end;
            long start;
            System.out.println(VerificationDataPerformanceTest.getTestClassId() + " in version " + mVersion + " started");
            this.addMessage(VerificationDataPerformanceTest.getTestClassId(), 'I', "Test in version 0.1 started.");
            this.lConnection = VerificationDataPerformanceTest.getDatabase().connect(VerificationDataPerformanceTest.getUser(), VerificationDataPerformanceTest.getPassword());
            stmt = new TestStatement(this, this.lConnection);
            stmt.enableExceptions(false);
            stmt.executeUpdate("Drop user testteam");
            stmt.enableExceptions(true);
            stmt.executeUpdate("Create user testteam password testteam resource not exclusive");
            stmt.close();
            this.lConnection.close();
            Random ran = new Random();
            this.lConnection = VerificationDataPerformanceTest.getDatabase().connect("testteam", "testteam");
            stmt = new TestStatement(this, this.lConnection);
            long time = 0L;
            int ROW_COUNT = 1000;
            int REPEATS = 100;
            for (int i2 = 0; i2 < 100; ++i2) {
                stmt.execute("create table tab1 (f1 fixed(8,2), f2 fixed(8,2), f3 fixed(8,2))");
                prepStmt = new TestPreparedStatement(this, this.lConnection, "Insert tab1 values (?,?,?)");
                VerificationDataComplete veri2 = new VerificationDataComplete();
                for (int j2 = 0; j2 < 1000; ++j2) {
                    float f1 = (float)ran.nextInt(100000) / 100.0f;
                    float f2 = (float)ran.nextInt(100000) / 100.0f;
                    float f3 = (float)ran.nextInt(100000) / 100.0f;
                    prepStmt.setBigDecimal(1, new BigDecimal(Float.toString(f1)));
                    prepStmt.setBigDecimal(2, new BigDecimal(Float.toString(f2)));
                    prepStmt.setBigDecimal(3, new BigDecimal(Float.toString(f3)));
                    prepStmt.addBatch();
                    veri2.add(f1 + ", " + f2 + ", " + f3);
                }
                prepStmt.executeBatch();
                start = System.currentTimeMillis();
                stmt.executeQuery("select * from tab1");
                this.checkQuery(stmt, veri2);
                end = System.currentTimeMillis();
                time += end - start;
                stmt.execute("drop table tab1");
            }
            System.out.println("1234.56 \t" + time);
            time = 0L;
            for (i = 0; i < 100; ++i) {
                stmt.execute("create table tab1 (f1 int, f2 int, f3 int)");
                prepStmt = new TestPreparedStatement(this, this.lConnection, "Insert tab1 values (?,?,?)");
                veri = new VerificationDataComplete();
                for (j = 0; j < 1000; ++j) {
                    i1 = ran.nextInt(100000);
                    int i2 = ran.nextInt(100000);
                    i3 = ran.nextInt(100000);
                    prepStmt.setInt(1, i1);
                    prepStmt.setInt(2, i2);
                    prepStmt.setInt(3, i3);
                    prepStmt.addBatch();
                    veri.add(i1 + ", " + i2 + ", " + i3);
                }
                prepStmt.executeBatch();
                start = System.currentTimeMillis();
                stmt.executeQuery("select * from tab1");
                this.checkQuery(stmt, veri);
                end = System.currentTimeMillis();
                time += end - start;
                stmt.execute("drop table tab1");
            }
            System.out.println("int \t" + time);
            time = 0L;
            for (i = 0; i < 100; ++i) {
                stmt.execute("create table tab1 (f1 fixed(30,0), f2 fixed(30,0), f3 fixed(30,0))");
                prepStmt = new TestPreparedStatement(this, this.lConnection, "Insert tab1 values (?,?,?)");
                veri = new VerificationDataComplete();
                for (j = 0; j < 1000; ++j) {
                    i1 = ran.nextInt(100000);
                    int i2 = ran.nextInt(100000);
                    i3 = ran.nextInt(100000);
                    prepStmt.setBigDecimal(1, new BigDecimal("123456789012345678" + i1));
                    prepStmt.setBigDecimal(2, new BigDecimal("123456789012345678" + i2));
                    prepStmt.setBigDecimal(3, new BigDecimal("123456789012345678" + i3));
                    prepStmt.addBatch();
                    veri.add("123456789012345678" + i1 + ", 123456789012345678" + i2 + ", 123456789012345678" + i3);
                }
                prepStmt.executeBatch();
                start = System.currentTimeMillis();
                stmt.executeQuery("select * from tab1");
                this.checkQuery(stmt, veri);
                end = System.currentTimeMillis();
                time += end - start;
                stmt.execute("drop table tab1");
            }
            System.out.println("long \t" + time);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

