/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.testcase;

import com.sap.sapdb.testframe.testcase.ColumnDescriptor;
import com.sap.sapdb.testframe.testcase.VerificationData;
import com.stevesoft.pat.Regex;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class VerificationDataComplete
extends VerificationData {
    public VerificationDataComplete() {
    }

    public VerificationDataComplete(String Set2) {
        super(Set2);
    }

    public VerificationDataComplete(ResultSet Set2) {
        super(Set2);
    }

    public static boolean checkResult(Statement pStatement, String pQuery, String pExpectedResult) throws SQLException {
        VerificationDataComplete ref = new VerificationDataComplete(pExpectedResult);
        ResultSet res = pStatement.executeQuery(pQuery);
        return ref.equals(res);
    }

    public boolean equals(ResultSet Set2) {
        return this.equalsSubstString(Set2, null);
    }

    public boolean equalsSubstString(ResultSet Set2, String expr) {
        int j = 0;
        int FoundRows = 0;
        Regex regexpr = null;
        try {
            int i;
            if (Set2 == null) {
                throw new RuntimeException("ResultSet is NULL.");
            }
            if (expr != null) {
                regexpr = Regex.perlCode((String)expr);
            }
            if (Set2.getType() != 1003) {
                this.checkResultCounter(Set2);
            }
            this.checkMetaData(Set2);
            if (Set2.getType() != 1003) {
                Set2.beforeFirst();
            }
            boolean[] AlreadyChecked = new boolean[this.mRowNumber];
            ResultSetMetaData MetaData = Set2.getMetaData();
            int[] columnTypes = new int[this.mColumnNumber];
            for (i = 0; i < this.mColumnNumber; ++i) {
                columnTypes[i] = MetaData.getColumnType(i + 1);
            }
            for (i = 0; i < this.mRowNumber; ++i) {
                AlreadyChecked[i] = false;
            }
            this.generateHashTable(regexpr);
            while (Set2.next()) {
                ++j;
                boolean RowFound = false;
                ArrayList<Object> resultSetRow = new ArrayList<Object>(this.mColumnNumber);
                for (i = 0; i < this.mColumnNumber; ++i) {
                    if (MetaData.getColumnType(i + 1) == 4) {
                        int integer = Set2.getInt(i + 1);
                        if (Set2.wasNull()) {
                            resultSetRow.add(null);
                            continue;
                        }
                        resultSetRow.add(new Integer(integer));
                        continue;
                    }
                    if (ColumnDescriptor.isNumeric(MetaData.getColumnType(i + 1))) {
                        resultSetRow.add(Set2.getBigDecimal(i + 1));
                        continue;
                    }
                    if (ColumnDescriptor.isString(MetaData.getColumnType(i + 1))) {
                        resultSetRow.add(Set2.getString(i + 1));
                        continue;
                    }
                    if (!ColumnDescriptor.isBinary(MetaData.getColumnType(i + 1))) continue;
                    resultSetRow.add(ColumnDescriptor.hex2String(Set2.getBytes(i + 1)).toUpperCase());
                }
                RowFound = this.findRowWithHash(resultSetRow, i, AlreadyChecked, columnTypes, expr, regexpr);
                if (!RowFound) {
                    try {
                        Iterator it = this.notHashableRows.iterator();
                        while (it.hasNext()) {
                            int rowNumber = (Integer)it.next();
                            ArrayList DataRow = (ArrayList)this.mValues.get(rowNumber);
                            if (AlreadyChecked[rowNumber]) continue;
                            for (i = 0; i < this.mColumnNumber; ++i) {
                                if (ColumnDescriptor.isNumeric(MetaData.getColumnType(i + 1))) {
                                    this.compareNumber(Set2, i + 1, j, DataRow.get(i));
                                    continue;
                                }
                                if (ColumnDescriptor.isString(MetaData.getColumnType(i + 1))) {
                                    if (expr != null) {
                                        this.compareString(Set2, i + 1, j, (String)DataRow.get(i), expr);
                                        continue;
                                    }
                                    this.compareString(Set2, i + 1, j, (String)DataRow.get(i));
                                    continue;
                                }
                                if (ColumnDescriptor.isBinary(MetaData.getColumnType(i + 1))) {
                                    this.compareBinary(Set2, i + 1, j, (String)DataRow.get(i));
                                    continue;
                                }
                                throw new RuntimeException("Unsupported data type: <" + ColumnDescriptor.getTypeName(MetaData.getColumnType(i + 1)) + ">.");
                            }
                            RowFound = true;
                            AlreadyChecked[rowNumber] = true;
                            if (!RowFound) continue;
                            break;
                        }
                    }
                    catch (RuntimeException e) {
                        // empty catch block
                    }
                }
                if (!RowFound) {
                    throw new RuntimeException("Wrong result: row <" + j + "> in current resultset not found in the reference data. Row:\n" + this.resultSetRowToString(Set2, j));
                }
                ++FoundRows;
            }
            if (j != FoundRows) {
                throw new RuntimeException("Wrong result: only <" + FoundRows + "> out of <" + j + "> rows match.");
            }
            if (j != this.mResultCounter) {
                throw new RuntimeException("Wrong number of results: Expecting <" + this.mResultCounter + "> rows, but found <" + j + ">.");
            }
            if (Set2.getType() == 1003 && this.mRowNumber != 0 && FoundRows == 0) {
                throw new RuntimeException("Wrong result: <" + this.mRowNumber + "> expected rows; but ResultSet seems to be empty.");
            }
        }
        catch (RuntimeException e) {
            this.mErrorMessage = e.getLocalizedMessage();
            if (e.toString().indexOf("IndexOutOfBoundsException") != -1) {
                this.mErrorMessage = e.toString() + "\npossible reason: too few values in a verification data row ";
            }
            if (e.toString().indexOf("ClassCastException") != -1) {
                this.mErrorMessage = e.toString() + "\npossible reason: different datatypes between database result and verificationdata object ";
            }
            return false;
        }
        catch (Exception e) {
            this.mErrorMessage = "General error: " + e.getMessage();
            return false;
        }
        this.mErrorMessage = "No errors";
        return true;
    }

    public boolean equals(VerificationData Set2) {
        return this.equalsSubstString(Set2, null);
    }

    public boolean equalsSubstString(VerificationData Set2, String expr) {
        ArrayList DataRow = null;
        boolean RowFound = false;
        int j = 0;
        Regex regexpr = null;
        try {
            if (Set2 == null) {
                throw new RuntimeException("VerificationData object is NULL.");
            }
            if (Set2.getOperatorType() != this.getOperatorType()) {
                throw new RuntimeException("The given VerificationData object (" + Set2.getClass().getName().substring(Set2.getClass().getName().lastIndexOf(".") + 1) + ") " + "type is different to the current (" + this.getClass().getName().substring(this.getClass().getName().lastIndexOf(".") + 1) + ") type. " + "\nNo comparison possible!");
            }
            this.checkResultCounter(Set2);
            this.checkMetaData(Set2);
            int[] columnTypes = new int[this.mColumnNumber];
            for (int i = 0; i < this.mColumnNumber; ++i) {
                columnTypes[i] = ((ColumnDescriptor)Set2.getColumnDescriptions().get(i)).getType();
            }
            boolean[] AlreadyChecked = new boolean[this.mRowNumber];
            int FoundRows = 0;
            for (int a = 0; a < this.mRowNumber; ++a) {
                AlreadyChecked[a] = false;
            }
            if (expr != null) {
                regexpr = Regex.perlCode((String)expr);
            }
            this.generateHashTable(regexpr);
            for (j = 0; j < Set2.getRows().size(); ++j) {
                ArrayList resultRow = (ArrayList)Set2.getRows().get(j);
                RowFound = this.findRowWithHash(resultRow, j, AlreadyChecked, columnTypes, expr, regexpr);
                if (!RowFound) {
                    Iterator it = this.notHashableRows.iterator();
                    while (it.hasNext()) {
                        int rowNumber = (Integer)it.next();
                        if (AlreadyChecked[rowNumber]) continue;
                        DataRow = (ArrayList)this.mValues.get(rowNumber);
                        AlreadyChecked[rowNumber] = RowFound = this.compareDataRows(resultRow, DataRow, j, columnTypes, expr);
                        if (!RowFound) continue;
                        break;
                    }
                }
                if (!RowFound) {
                    throw new RuntimeException("Wrong result: row <" + (j + 1) + "> not found in the reference data. Row:\n" + this.verificationDataRowToString(Set2, j));
                }
                ++FoundRows;
            }
            if (j != FoundRows) {
                throw new RuntimeException("Wrong result: only <" + FoundRows + "> out of <" + j + "> rows match.");
            }
        }
        catch (RuntimeException e) {
            this.mErrorMessage = e.getLocalizedMessage();
            if (e.toString().indexOf("IndexOutOfBoundsException") != -1) {
                this.mErrorMessage = e.toString() + "\npossible reason: too few values in a verification data row or column description";
            }
            if (e.toString().indexOf("ClassCastException") != -1) {
                this.mErrorMessage = e.toString() + "\npossible reason: different datatypes between database result and verificationdata object ";
            }
            return false;
        }
        catch (Exception e) {
            this.mErrorMessage = "General error: " + e.getMessage();
            return false;
        }
        this.mErrorMessage = "No errors";
        return true;
    }

    public char getOperatorType() {
        return 'c';
    }

    protected boolean findRowWithHash(ArrayList resultSetRow, int resultRow, boolean[] alreadyChecked, int[] columnTypes, String regexString, Regex regexpr) {
        Integer hashKey = VerificationDataComplete.createRowHash(resultSetRow, this.mColumnNumber, regexpr);
        List ll = (List)this.rowHash.get(hashKey);
        ArrayList DataRow = null;
        if (ll != null) {
            Iterator it = ll.iterator();
            while (it.hasNext()) {
                int rowNumber = (Integer)it.next();
                DataRow = (ArrayList)this.mValues.get(rowNumber);
                if (!this.compareDataRows(resultSetRow, DataRow, resultRow, columnTypes, regexString)) continue;
                alreadyChecked[rowNumber] = true;
                it.remove();
                if (ll.isEmpty()) {
                    this.rowHash.remove(hashKey);
                }
                return true;
            }
        }
        return false;
    }

    protected boolean compareDataRows(ArrayList dataRow1, ArrayList dataRow2, int row, int[] columnTypes, String expr) {
        try {
            for (int column = 0; column < this.mColumnNumber; ++column) {
                if (ColumnDescriptor.isNumeric(columnTypes[column])) {
                    this.compareNumber(dataRow1.get(column), column, row, dataRow2.get(column));
                    continue;
                }
                if (ColumnDescriptor.isString(columnTypes[column])) {
                    if (expr != null) {
                        this.compareString(dataRow1.get(column), column, row, (String)dataRow2.get(column), expr);
                        continue;
                    }
                    this.compareString(dataRow1.get(column), column, row, (String)dataRow2.get(column));
                    continue;
                }
                if (ColumnDescriptor.isBinary(columnTypes[column])) {
                    this.compareBinary(dataRow1.get(column), column, row, (String)dataRow2.get(column));
                    continue;
                }
                throw new RuntimeException("Unsupported data type: <" + ColumnDescriptor.getTypeName(columnTypes[column]) + ">.");
            }
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }
}

