/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.testcase;

import com.sap.dbtech.jdbc.trace.ResultSet;
import com.sap.sapdb.testframe.driver.TestStatementMonitor;
import com.sap.sapdb.testframe.driver.TestStatementMonitorException;
import com.sap.sapdb.testframe.testcase.ExplainObject;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.VerificationItemData;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.StringTokenizer;

public class TestStatement
implements Statement {
    VerificationItemData mResultItemData;
    Statement mStatement;
    private final boolean mSystemOut = false;
    TestCase mTestCase;
    private static final int INTERRUPT_COUNTER = 5000;
    private boolean FETCH_EVERY_FIELD = false;
    private boolean mIsRunningOnSAP = true;
    private boolean mExceptionsOn = true;
    private boolean mExplainOn = true;
    private boolean mVerifyPossible = true;
    private boolean mAutoFetch = true;
    private Exception mException;
    private boolean mResultSetIsScrollable = false;
    Connection mConnection;
    private int mActiveStmtNo = -1;
    TestStatementMonitor mMonitor;
    String mParseId;

    TestStatement(TestCase pTestCase) {
        this.mTestCase = pTestCase;
        this.mResultItemData = new VerificationItemData();
        this.mIsRunningOnSAP = this.mTestCase != null && TestCase.getDatabase() != null && TestCase.getDatabase().getSys().trim().equals("SAP");
    }

    public TestStatement(TestCase pTestCase, Connection pConnection) throws SQLException {
        this(pTestCase);
        this.mStatement = pConnection.createStatement();
        this.mConnection = pConnection;
    }

    public TestStatement(TestCase pTestCase, Connection pConnection, int pResultSetType, int pResultSetConcurrency) throws SQLException {
        this(pTestCase);
        this.mStatement = pConnection.createStatement(pResultSetType, pResultSetConcurrency);
        this.mConnection = pConnection;
        if (pResultSetType != 1003) {
            this.mResultSetIsScrollable = true;
        }
    }

    public void addBatch(String pSql) throws SQLException {
        this.mStatement.addBatch(pSql);
    }

    void afterExecution(boolean pIsResultSet) throws SQLException {
        java.sql.ResultSet lResultSet = null;
        Object lResultObject = null;
        int lColumnCount = 0;
        int lRowCounter = 0;
        boolean lHasMoreResults = false;
        if (this.mTestCase != null && this.mActiveStmtNo != -1) {
            this.mTestCase.resetActiveStatement(this.mActiveStmtNo);
        }
        if (!pIsResultSet) {
            lRowCounter = this.mStatement.getUpdateCount();
            lHasMoreResults = this.mStatement.getMoreResults();
        } else {
            boolean lIsResultSet;
            if (this.mResultSetIsScrollable && this.mAutoFetch) {
                lResultSet = this.mStatement.getResultSet();
                if (lResultSet != null) {
                    lColumnCount = lResultSet.getMetaData().getColumnCount();
                    while (lResultSet.next()) {
                        if (++lRowCounter % 5000 == 0 && this.mTestCase != null && this.mTestCase.isInterrupted()) {
                            return;
                        }
                        if (!this.FETCH_EVERY_FIELD) continue;
                        for (int i = 1; i <= lColumnCount; ++i) {
                            lResultObject = lResultSet.getObject(i);
                        }
                    }
                }
                this.mResultItemData.setRuntime(System.currentTimeMillis() - this.mResultItemData.getExecutionTime());
                if (this.mMonitor != null) {
                    try {
                        this.mMonitor.fill(TestStatementMonitor.getParseId((PreparedStatement)this.mStatement));
                    }
                    catch (TestStatementMonitorException tsme) {
                        // empty catch block
                    }
                }
                if (lResultSet != null) {
                    lResultSet.beforeFirst();
                }
            } else {
                lRowCounter = -1;
            }
            lHasMoreResults = !(lIsResultSet = this.mStatement.getMoreResults()) ? this.mStatement.getUpdateCount() != -1 : true;
        }
        if (lHasMoreResults) {
            throw new SQLException("TestStatements can not support more than one result set per execution");
        }
        this.mResultItemData.setResultCounter(lRowCounter);
        this.explain(this.getResultData().getSqlStatement());
    }

    void forceReadResultCounter() throws SQLException {
        java.sql.ResultSet lResultSet = null;
        int lRowCounter = -1;
        lResultSet = this.mStatement.getResultSet();
        if (lResultSet != null) {
            while (lResultSet.next()) {
                ++lRowCounter;
            }
            if (lRowCounter != -1) {
                ++lRowCounter;
            }
        }
        this.mResultItemData.setResultCounter(lRowCounter);
    }

    void afterExecutionExceptionOccured(SQLException pE) throws SQLException {
        if (this.mTestCase != null && this.mActiveStmtNo != -1) {
            this.mTestCase.resetActiveStatement(this.mActiveStmtNo);
        }
        this.mException = pE;
        this.mResultItemData.setExceptionText(pE.getMessage());
        this.mResultItemData.setErrorIndicator("SQLException");
        this.mResultItemData.setResultCounter(-1);
        if (this.getExceptionHandling()) {
            throw pE;
        }
    }

    void beforeExecution() {
        if (this.mTestCase != null) {
            this.mTestCase.setLastStatement(this);
        }
        this.mResultItemData.setExecutionTime(System.currentTimeMillis());
        this.mResultItemData.setExplainObject(null);
        this.mResultItemData.setResultCounter(0);
        this.mResultItemData.setRuntime(0L);
        this.mResultItemData.setErrorIndicator("");
        this.mResultItemData.setExceptionText("");
        this.mException = null;
        this.mActiveStmtNo = this.mTestCase != null ? this.mTestCase.setActiveStatement(this) : -1;
    }

    private void beforeExecutionOnlyStatement(String pSql) {
        this.mResultItemData.setSqlStatement(pSql);
    }

    public void cancel() throws SQLException {
        this.mStatement.cancel();
    }

    public void clearBatch() throws SQLException {
        this.mStatement.clearBatch();
    }

    public void clearWarnings() throws SQLException {
        this.mStatement.clearWarnings();
    }

    VerificationItemData cloneResultData() {
        if (this.mVerifyPossible) {
            return new VerificationItemData(this.mResultItemData.getResultCounter(), this.mResultItemData.getSqlStatement(), this.mResultItemData.getExplainObject(), this.mResultItemData.getRuntime(), this.mResultItemData.getExecutionTime(), this.mResultItemData.getErrorIndicator(), this.mResultItemData.getExceptionText(), this.mResultItemData.getVerificationData());
        }
        throw new RuntimeException("Can't return Result Data from a batch processed statement");
    }

    public void close() throws SQLException {
        this.mStatement.close();
    }

    public final void enableExceptions(boolean pExceptionsOn) {
        this.mExceptionsOn = pExceptionsOn;
    }

    public final void enableExplain(boolean pExplainOn) {
        this.mExplainOn = pExplainOn;
    }

    public boolean execute(String pSql) throws SQLException {
        this.mVerifyPossible = true;
        this.beforeExecutionOnlyStatement(pSql);
        this.beforeExecution();
        try {
            boolean lIsResultSet = this.mStatement.execute(this.getResultData().getSqlStatement());
            this.afterExecution(lIsResultSet);
            return lIsResultSet;
        }
        catch (SQLException e) {
            this.afterExecutionExceptionOccured(e);
            return false;
        }
    }

    public int[] executeBatch() throws SQLException {
        this.mVerifyPossible = false;
        if (this.mTestCase != null) {
            this.mTestCase.setLastStatement(this);
            this.mActiveStmtNo = this.mTestCase.setActiveStatement(this);
        } else {
            this.mActiveStmtNo = -1;
        }
        int[] li = this.mStatement.executeBatch();
        if (this.mTestCase != null && this.mActiveStmtNo != -1) {
            this.mTestCase.resetActiveStatement(this.mActiveStmtNo);
        }
        return li;
    }

    public java.sql.ResultSet executeQuery(String pSql) throws SQLException {
        this.mVerifyPossible = true;
        this.beforeExecutionOnlyStatement(pSql);
        this.beforeExecution();
        try {
            java.sql.ResultSet lResultSet = this.mStatement.executeQuery(this.getResultData().getSqlStatement());
            this.afterExecution(true);
            return lResultSet;
        }
        catch (SQLException e) {
            this.afterExecutionExceptionOccured(e);
            return null;
        }
    }

    public int executeUpdate(String pSql) throws SQLException {
        this.mVerifyPossible = true;
        this.beforeExecutionOnlyStatement(pSql);
        this.beforeExecution();
        try {
            int lResultCounter = this.mStatement.executeUpdate(this.getResultData().getSqlStatement());
            this.afterExecution(false);
            return lResultCounter;
        }
        catch (SQLException e) {
            this.afterExecutionExceptionOccured(e);
            return -1;
        }
    }

    public int executeUpdate(String pSql, int pErrorCode) throws SQLException {
        int lResultCounter;
        block2: {
            lResultCounter = 0;
            try {
                lResultCounter = this.executeUpdate(pSql);
            }
            catch (SQLException e) {
                if (e.getErrorCode() == pErrorCode) break block2;
                throw e;
            }
        }
        return lResultCounter;
    }

    public int executeUpdateIgnoreErrors(String pSql) {
        int lResultCounter = 0;
        try {
            lResultCounter = this.executeUpdate(pSql);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return lResultCounter;
    }

    boolean explain(String pSql) {
        String S;
        if (!this.mExplainOn) {
            return false;
        }
        StringTokenizer ST = new StringTokenizer(pSql);
        boolean lWithExplain = false;
        if (this.mIsRunningOnSAP && (S = ST.nextToken()) != null) {
            if (S.trim().equalsIgnoreCase("SELECT")) {
                lWithExplain = true;
            } else if (S.trim().equalsIgnoreCase("EXPLAIN")) {
                lWithExplain = true;
            }
        }
        if (lWithExplain) {
            try {
                this.mResultItemData.setExplainObject(new ExplainObject(pSql, this.mConnection));
            }
            catch (Exception e) {
                System.err.println("Explain failed: \n\n");
                e.printStackTrace(System.err);
                return false;
            }
        }
        return true;
    }

    public boolean getAutoFetch() {
        return this.mAutoFetch;
    }

    public Connection getConnection() throws SQLException {
        return this.mStatement.getConnection();
    }

    public Exception getException() {
        return this.mException;
    }

    public final boolean getExceptionHandling() {
        return this.mExceptionsOn;
    }

    public ExplainObject getExplainObject() {
        return this.mResultItemData.getExplainObject();
    }

    public int getFetchDirection() throws SQLException {
        return this.mStatement.getFetchDirection();
    }

    public int getFetchSize() throws SQLException {
        return this.mStatement.getFetchSize();
    }

    public int getMaxFieldSize() throws SQLException {
        return this.mStatement.getMaxFieldSize();
    }

    public int getMaxRows() throws SQLException {
        return this.mStatement.getMaxRows();
    }

    public boolean getMoreResults() throws SQLException {
        return this.mStatement.getMoreResults();
    }

    public int getQueryTimeout() throws SQLException {
        return this.mStatement.getQueryTimeout();
    }

    public final int getResultCounter() {
        return this.mResultItemData.getResultCounter();
    }

    public VerificationItemData getResultData() {
        if (this.mVerifyPossible) {
            return this.mResultItemData;
        }
        throw new RuntimeException("Can't return Result Data from a batch processed statement");
    }

    public java.sql.ResultSet getResultSet() throws SQLException {
        if (this.mStatement.getResultSet() instanceof ResultSet) {
            try {
                if (this.mResultSetIsScrollable) {
                    this.mStatement.getResultSet().beforeFirst();
                }
                return this.mStatement.getResultSet();
            }
            catch (NullPointerException npe) {
                return null;
            }
        }
        return this.mStatement.getResultSet();
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.mStatement.getResultSetConcurrency();
    }

    public int getResultSetType() throws SQLException {
        return this.mStatement.getResultSetType();
    }

    public long getRuntime() {
        return this.mResultItemData.getRuntime();
    }

    public String getSqlString() {
        return this.mResultItemData.getSqlStatement();
    }

    public int getUpdateCount() throws SQLException {
        return this.mStatement.getUpdateCount();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.mStatement.getWarnings();
    }

    boolean isExceptionsOn() {
        return this.mExceptionsOn;
    }

    boolean isExplainOn() {
        return this.mExplainOn;
    }

    public boolean isScrollable() {
        return this.mResultSetIsScrollable;
    }

    public void setIsScrollable(boolean pIsScrollable) {
        this.mResultSetIsScrollable = pIsScrollable;
    }

    public void setAutoFetch(boolean pAutoFetch) {
        this.mAutoFetch = pAutoFetch;
    }

    public void setCursorName(String name) throws SQLException {
        this.mStatement.setCursorName(name);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.mStatement.setEscapeProcessing(enable);
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.mStatement.setFetchDirection(direction);
    }

    public void setFetchSize(int rows) throws SQLException {
        this.mStatement.setFetchSize(rows);
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.mStatement.setMaxFieldSize(max);
    }

    public void setMaxRows(int max) throws SQLException {
        this.mStatement.setMaxRows(max);
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.mStatement.setQueryTimeout(seconds);
    }

    public boolean execute(String arg0, int arg1) throws SQLException {
        return false;
    }

    public boolean execute(String arg0, int[] arg1) throws SQLException {
        return false;
    }

    public boolean execute(String arg0, String[] arg1) throws SQLException {
        return false;
    }

    public int executeUpdate(String arg0, int[] arg1) throws SQLException {
        return 0;
    }

    public int executeUpdate(String arg0, String[] arg1) throws SQLException {
        return 0;
    }

    public java.sql.ResultSet getGeneratedKeys() throws SQLException {
        return null;
    }

    public boolean getMoreResults(int arg0) throws SQLException {
        return false;
    }

    public int getResultSetHoldability() throws SQLException {
        return 0;
    }
}

