/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.testcase;

import com.sap.sapdb.testframe.testcase.ExplainConstants;
import com.sap.sapdb.testframe.testcase.ExplainDataIterator;
import com.sap.sapdb.testframe.testcase.ExplainDataIteratorPretty;
import com.sap.sapdb.testframe.testcase.ExplainException;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.StringTokenizer;

public class ExplainData
implements Serializable,
ExplainConstants {
    private ArrayList mExplainData = new ArrayList();
    private ArrayList mTableItems = null;
    private String mResultStatus = null;
    private String mCostvalue = null;
    private transient String mTable = null;
    private transient String mStrategy = null;
    private transient String mPagecount = null;
    private transient ArrayList mStrategyInfo = null;
    private transient String mColumn = null;
    private String mStrategyList = null;
    private static final long serialVersionUID = 24L;

    ExplainData() {
        this.mTableItems = new ArrayList();
        this.mTable = null;
        this.mStrategy = null;
        this.mPagecount = null;
        this.mStrategyInfo = null;
        this.mColumn = null;
        this.mResultStatus = null;
        this.mCostvalue = null;
    }

    ExplainData(ResultSet rs) {
        try {
            this.fill(rs);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    void add() throws ExplainException {
        ArrayList<String> Table2 = new ArrayList<String>();
        if (this.mTable == null) {
            throw new ExplainException("Table is not specified");
        }
        Table2.add(this.mTable.trim());
        if (!this.mTableItems.isEmpty()) {
            ListIterator it = this.mTableItems.listIterator();
            while (it.hasNext()) {
                Table2.add((String)it.next());
            }
        }
        this.mExplainData.add(Table2);
        this.mTable = null;
        this.mStrategy = null;
        this.mPagecount = null;
        this.mStrategyInfo = null;
        this.mColumn = null;
        this.mTableItems = new ArrayList();
    }

    void addStrategy(String pStrategy) {
        this.mStrategy = pStrategy;
        this.mTableItems.add(this.getStrategyObject());
        this.mStrategy = null;
        this.mPagecount = null;
        this.mStrategyInfo = null;
        this.mColumn = null;
    }

    void addStrategy(String pStrategy, String pColumn) {
        this.mStrategy = pStrategy;
        this.mColumn = pColumn;
        this.mTableItems.add(this.getStrategyObject());
        this.mStrategy = null;
        this.mPagecount = null;
        this.mStrategyInfo = null;
        this.mColumn = null;
    }

    void addStrategy(String pStrategy, String pColumn, ArrayList pStrategyInfo) {
        this.mStrategy = pStrategy;
        this.mColumn = pColumn;
        this.mStrategyInfo = pStrategyInfo;
        this.mTableItems.add(this.getStrategyObject());
        this.mStrategy = null;
        this.mPagecount = null;
        this.mStrategyInfo = null;
        this.mColumn = null;
    }

    void addStrategy(String pStrategy, String pColumn, boolean pOnlyIndex, boolean pDistinctOptimization, boolean pTemporaryInversion, boolean pMoreQualifications) {
        this.mStrategy = pStrategy;
        this.mColumn = pColumn;
        if (pOnlyIndex || pDistinctOptimization || pMoreQualifications || pTemporaryInversion) {
            this.mStrategyInfo = new ArrayList();
            if (pOnlyIndex) {
                this.mStrategyInfo.add("ONLY INDEX");
            }
            if (pDistinctOptimization) {
                this.mStrategyInfo.add("DISTINCT OPTIMIZATION");
            }
            if (pTemporaryInversion) {
                this.mStrategyInfo.add("TEMPORARY INVERSION");
            }
            if (pMoreQualifications) {
                this.mStrategyInfo.add("MORE QUALIFICATIONS");
            }
        } else {
            this.mStrategyInfo = null;
        }
        this.mTableItems.add(this.getStrategyObject());
        this.mStrategy = null;
        this.mPagecount = null;
        this.mStrategyInfo = null;
        this.mColumn = null;
    }

    void addStrategy(String pStrategy, boolean pOnlyIndex, boolean pDistinctOptimization, boolean pTemporaryInversion, boolean pMoreQualifications) {
        this.addStrategy(pStrategy, null, pOnlyIndex, pDistinctOptimization, pTemporaryInversion, pMoreQualifications);
    }

    void addTable(String pTable) {
        this.mTable = pTable;
    }

    void clear() {
        this.mExplainData.clear();
        this.mResultStatus = null;
        this.mCostvalue = null;
    }

    ExplainData copy() throws ExplainException {
        ExplainData Copy = new ExplainData();
        ExplainDataIterator it = this.iterator();
        while (it.hasNext()) {
            it.next();
            Copy.addTable(it.getTable());
            while (it.hasNextItem()) {
                it.nextItem();
                if (it.getStrategyInfo() != null && !it.getStrategyInfo().isEmpty()) {
                    ArrayList StrategyInfo = new ArrayList();
                    ListIterator its = it.getStrategyInfo().listIterator();
                    while (its.hasNext()) {
                        StrategyInfo.add(its.next());
                    }
                    Copy.addStrategy(it.getStrategy(), it.getColumn(), StrategyInfo);
                    continue;
                }
                Copy.addStrategy(it.getStrategy(), it.getColumn());
            }
            Copy.add();
        }
        Copy.mResultStatus = this.mResultStatus;
        Copy.mCostvalue = this.mCostvalue;
        return Copy;
    }

    private void fill(ResultSet rs) throws SQLException {
        ArrayList Table2 = null;
        ArrayList Strategy = null;
        ArrayList ActTable = null;
        ArrayList ActStrategy = null;
        while (rs.next()) {
            if (rs.isFirst()) {
                ActTable = this.parseTable(rs);
                ActStrategy = this.parseStrategy(rs);
                continue;
            }
            if (rs.isLast()) {
                ActTable.add(ActStrategy);
                this.mExplainData.add(ActTable);
                this.parseEpilog(rs);
                break;
            }
            Table2 = this.parseTable(rs);
            if (Table2 != null) {
                ActTable.add(ActStrategy);
                this.mExplainData.add(ActTable);
                ActTable = Table2;
                ActStrategy = this.parseStrategy(rs);
                continue;
            }
            Strategy = this.parseStrategy(rs);
            if (Strategy == null) continue;
            ActTable.add(ActStrategy);
            ActStrategy = Strategy;
        }
    }

    String getCostvalue() {
        return this.mCostvalue;
    }

    ArrayList getData() {
        return this.mExplainData;
    }

    String getResultStatus() {
        return this.mResultStatus;
    }

    private ArrayList getStrategyObject() {
        ArrayList<Object> Strategy = new ArrayList<Object>();
        Strategy.add(this.mStrategy);
        Strategy.add(this.mPagecount);
        Strategy.add(this.mStrategyInfo);
        Strategy.add(this.mColumn);
        return Strategy;
    }

    ExplainDataIterator iterator() {
        return new ExplainDataIterator(this);
    }

    ExplainDataIteratorPretty iteratorPretty() {
        return new ExplainDataIteratorPretty(this);
    }

    private void parseEpilog(ResultSet rs) throws SQLException {
        String costvalue;
        StringTokenizer st;
        String result = rs.getString("STRATEGY").trim();
        if (result != null && result.length() != 0 && (st = new StringTokenizer(result, ",")).hasMoreTokens()) {
            this.mResultStatus = st.nextToken().trim();
        }
        if ((costvalue = rs.getString("PAGECOUNT").trim()) != null && costvalue.length() != 0) {
            this.mCostvalue = costvalue;
        }
    }

    private ArrayList parseStrategy(ResultSet rs) throws SQLException {
        String column;
        String strategy = rs.getString("STRATEGY").trim();
        if (strategy != null && strategy.length() == 0) {
            strategy = null;
        }
        if ((column = rs.getString("COLUMN_OR_INDEX").trim()) != null && column.length() == 0) {
            column = null;
        }
        if (strategy == null && column == null) {
            return null;
        }
        String pagecount = rs.getString("PAGECOUNT").trim();
        if (pagecount != null && pagecount.length() == 0) {
            pagecount = null;
        }
        ArrayList<Object> Strategy = new ArrayList<Object>();
        Strategy.add(strategy);
        Strategy.add(pagecount);
        ArrayList<String> StrategyInfo = rs.getString("O").trim().equals("*") || rs.getString("D").trim().equals("*") || rs.getString("T").trim().equals("*") || rs.getString("M").trim().equals("*") ? new ArrayList<String>() : null;
        if (rs.getString("O").trim().equals("*")) {
            StrategyInfo.add("ONLY INDEX");
        }
        if (rs.getString("D").trim().equals("*")) {
            StrategyInfo.add("DISTINCT OPTIMIZATION");
        }
        if (rs.getString("T").trim().equals("*")) {
            StrategyInfo.add("TEMPORARY INVERSION");
        }
        if (rs.getString("M").trim().equals("*")) {
            StrategyInfo.add("MORE QUALIFICATIONS");
        }
        Strategy.add(StrategyInfo);
        Strategy.add(column);
        return Strategy;
    }

    private ArrayList parseTable(ResultSet rs) throws SQLException {
        String table = rs.getString("TABLENAME").trim();
        if (table == null) {
            return null;
        }
        if (table != null && table.length() == 0) {
            return null;
        }
        ArrayList<String> Table2 = new ArrayList<String>();
        Table2.add(table);
        return Table2;
    }

    void setCostvalue(String pCostvalue) {
        this.mCostvalue = pCostvalue;
    }

    void setResultStatus(String pResult) {
        this.mResultStatus = pResult;
    }

    int size() {
        this.mExplainData.trimToSize();
        return this.mExplainData.size();
    }

    public String getStrategyList() {
        this.mStrategyList = "";
        if (!this.mExplainData.isEmpty()) {
            ListIterator it = this.mExplainData.listIterator();
            while (it.hasNext()) {
                this.mStrategyList = this.mStrategyList + it.next();
            }
        }
        return this.mStrategyList;
    }
}

