/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import java.util.Hashtable;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.xs.DatatypeValidator;
import org.apache.xerces.impl.dv.xs.DateTimeValidator;
import org.apache.xerces.impl.dv.xs.SchemaDateTimeException;

public class MonthDayDatatypeValidator
extends DateTimeValidator {
    private static final int MONTHDAY_SIZE = 7;

    public MonthDayDatatypeValidator() {
    }

    public MonthDayDatatypeValidator(DatatypeValidator base, Hashtable facets, boolean derivedByList, XMLErrorReporter reporter) {
        super(base, facets, derivedByList, reporter);
    }

    protected int[] parse(String str, int[] date) throws SchemaDateTimeException {
        this.resetBuffer(str);
        if (date == null) {
            date = new int[8];
        }
        this.resetDateObj(date);
        date[0] = 2000;
        if (this.fBuffer.charAt(0) != '-' || this.fBuffer.charAt(1) != '-') {
            throw new SchemaDateTimeException("Invalid format for gMonthDay: " + str);
        }
        date[1] = this.parseInt(this.fStart + 2, this.fStart + 4);
        this.fStart += 4;
        if (this.fBuffer.charAt(this.fStart++) != '-') {
            throw new SchemaDateTimeException("Invalid format for gMonthDay: " + str);
        }
        date[2] = this.parseInt(this.fStart, this.fStart + 2);
        if (7 < this.fEnd) {
            int sign = this.findUTCSign(7, this.fEnd);
            if (sign < 0) {
                throw new SchemaDateTimeException("Error in month parsing:" + str);
            }
            this.getTimeZone(date, sign);
        }
        this.validateDateTime(date);
        if (date[7] != 0 && date[7] != 90) {
            this.normalize(date);
        }
        return date;
    }

    protected String dateToString(int[] date) {
        this.message.setLength(0);
        this.message.append('-');
        this.message.append('-');
        this.message.append(date[1]);
        this.message.append('-');
        this.message.append(date[2]);
        this.message.append((char)date[7]);
        return this.message.toString();
    }
}

