/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.impl.dv.xs.AbstractDatatypeValidator;
import org.apache.xerces.impl.dv.xs.AnySimpleType;
import org.apache.xerces.impl.dv.xs.AnyURIDatatypeValidator;
import org.apache.xerces.impl.dv.xs.Base64BinaryDatatypeValidator;
import org.apache.xerces.impl.dv.xs.BooleanDatatypeValidator;
import org.apache.xerces.impl.dv.xs.DatatypeValidator;
import org.apache.xerces.impl.dv.xs.DatatypeValidatorFactory;
import org.apache.xerces.impl.dv.xs.DateDatatypeValidator;
import org.apache.xerces.impl.dv.xs.DateTimeDatatypeValidator;
import org.apache.xerces.impl.dv.xs.DayDatatypeValidator;
import org.apache.xerces.impl.dv.xs.DecimalDatatypeValidator;
import org.apache.xerces.impl.dv.xs.DoubleDatatypeValidator;
import org.apache.xerces.impl.dv.xs.DurationDatatypeValidator;
import org.apache.xerces.impl.dv.xs.FloatDatatypeValidator;
import org.apache.xerces.impl.dv.xs.HexBinaryDatatypeValidator;
import org.apache.xerces.impl.dv.xs.IDDatatypeValidator;
import org.apache.xerces.impl.dv.xs.IDREFDatatypeValidator;
import org.apache.xerces.impl.dv.xs.ListDatatypeValidator;
import org.apache.xerces.impl.dv.xs.MonthDatatypeValidator;
import org.apache.xerces.impl.dv.xs.MonthDayDatatypeValidator;
import org.apache.xerces.impl.dv.xs.NOTATIONDatatypeValidator;
import org.apache.xerces.impl.dv.xs.QNameDatatypeValidator;
import org.apache.xerces.impl.dv.xs.StringDatatypeValidator;
import org.apache.xerces.impl.dv.xs.TimeDatatypeValidator;
import org.apache.xerces.impl.dv.xs.UnionDatatypeValidator;
import org.apache.xerces.impl.dv.xs.YearDatatypeValidator;
import org.apache.xerces.impl.dv.xs.YearMonthDatatypeValidator;
import org.apache.xerces.impl.xs.SchemaSymbols;

public class DatatypeValidatorFactoryImpl
implements DatatypeValidatorFactory {
    private static final boolean fDebug = false;
    private Hashtable fRegistry = new Hashtable(30);
    private Hashtable fDTDDatatypeRegistry;
    private Hashtable fSchemaDatatypeRegistry = new Hashtable(40);
    private byte fRegistryExpanded = 0;
    private byte fSchemaValidation = 0;
    static /* synthetic */ Class class$org$apache$xerces$impl$dv$xs$DatatypeValidator;
    static /* synthetic */ Class class$java$util$Hashtable;

    public DatatypeValidatorFactoryImpl() {
        this.fDTDDatatypeRegistry = new Hashtable(10);
    }

    public void initializeDTDRegistry() {
        if (this.fRegistryExpanded == 0) {
            this.fDTDDatatypeRegistry.put("string", new StringDatatypeValidator());
            this.fDTDDatatypeRegistry.put("ID", new IDDatatypeValidator());
            this.fDTDDatatypeRegistry.put("IDREF", new IDREFDatatypeValidator());
            this.fDTDDatatypeRegistry.put("NOTATION", new NOTATIONDatatypeValidator());
            this.createDTDDatatypeValidator("IDREFS", new IDREFDatatypeValidator(), null, true);
            Hashtable<String, String> facets = new Hashtable<String, String>(2);
            facets.put("specialToken", "NMTOKEN");
            facets.put(SchemaSymbols.ELT_WHITESPACE, "collapse");
            this.createDTDDatatypeValidator("NMTOKEN", new StringDatatypeValidator(), facets, false);
            this.createDTDDatatypeValidator("NMTOKENS", this.getDatatypeValidator("NMTOKEN"), null, true);
            this.fRegistryExpanded = 1;
        }
    }

    public void expandRegistryToFullSchemaSet() {
        this.fSchemaValidation = 1;
        if (this.fRegistryExpanded != 2) {
            this.fSchemaDatatypeRegistry.put("anySimpleType", new AnySimpleType());
            this.fSchemaDatatypeRegistry.put("boolean", new BooleanDatatypeValidator());
            this.fSchemaDatatypeRegistry.put("float", new FloatDatatypeValidator());
            this.fSchemaDatatypeRegistry.put("double", new DoubleDatatypeValidator());
            this.fSchemaDatatypeRegistry.put("decimal", new DecimalDatatypeValidator());
            this.fSchemaDatatypeRegistry.put("hexBinary", new HexBinaryDatatypeValidator());
            this.fSchemaDatatypeRegistry.put("base64Binary", new Base64BinaryDatatypeValidator());
            this.fSchemaDatatypeRegistry.put("anyURI", new AnyURIDatatypeValidator());
            this.fSchemaDatatypeRegistry.put("QName", new QNameDatatypeValidator());
            this.fSchemaDatatypeRegistry.put("duration", new DurationDatatypeValidator());
            this.fSchemaDatatypeRegistry.put("gDay", new DayDatatypeValidator());
            this.fSchemaDatatypeRegistry.put("time", new TimeDatatypeValidator());
            this.fSchemaDatatypeRegistry.put("dateTime", new DateTimeDatatypeValidator());
            this.fSchemaDatatypeRegistry.put("date", new DateDatatypeValidator());
            this.fSchemaDatatypeRegistry.put("gMonthDay", new MonthDayDatatypeValidator());
            this.fSchemaDatatypeRegistry.put("gYearMonth", new YearMonthDatatypeValidator());
            this.fSchemaDatatypeRegistry.put("gYear", new YearDatatypeValidator());
            this.fSchemaDatatypeRegistry.put("gMonth", new MonthDatatypeValidator());
            if (this.fRegistryExpanded == 0) {
                this.initializeDTDRegistry();
            }
            Hashtable<String, String> facets = new Hashtable<String, String>(2);
            facets.put(SchemaSymbols.ELT_WHITESPACE, "replace");
            this.createSchemaDatatypeValidator("normalizedString", this.getDatatypeValidator("string"), facets, false);
            facets.clear();
            facets.put(SchemaSymbols.ELT_WHITESPACE, "collapse");
            this.createSchemaDatatypeValidator("token", this.getDatatypeValidator("string"), facets, false);
            facets.clear();
            facets.put(SchemaSymbols.ELT_WHITESPACE, "collapse");
            facets.put(SchemaSymbols.ELT_PATTERN, "([a-zA-Z]{2}|[iI]-[a-zA-Z]+|[xX]-[a-zA-Z]+)(-[a-zA-Z]+)*");
            this.createSchemaDatatypeValidator("language", this.getDatatypeValidator("string"), facets, false);
            facets.clear();
            facets.put(SchemaSymbols.ELT_WHITESPACE, "collapse");
            facets.put("specialToken", "Name");
            this.createSchemaDatatypeValidator("Name", this.getDatatypeValidator("string"), facets, false);
            facets.clear();
            facets.put(SchemaSymbols.ELT_WHITESPACE, "collapse");
            facets.put("specialToken", "NCName");
            this.createSchemaDatatypeValidator("NCName", this.getDatatypeValidator("string"), facets, false);
            facets.clear();
            facets.put(SchemaSymbols.ELT_FRACTIONDIGITS, "0");
            this.createSchemaDatatypeValidator("integer", this.getDatatypeValidator("decimal"), facets, false);
            facets.clear();
            facets.put(SchemaSymbols.ELT_MAXINCLUSIVE, "0");
            this.createSchemaDatatypeValidator("nonPositiveInteger", this.getDatatypeValidator("integer"), facets, false);
            facets.clear();
            facets.put(SchemaSymbols.ELT_MAXINCLUSIVE, "-1");
            this.createSchemaDatatypeValidator("negativeInteger", this.getDatatypeValidator("nonPositiveInteger"), facets, false);
            facets.clear();
            facets.put(SchemaSymbols.ELT_MAXINCLUSIVE, "9223372036854775807");
            facets.put(SchemaSymbols.ELT_MININCLUSIVE, "-9223372036854775808");
            this.createSchemaDatatypeValidator("long", this.getDatatypeValidator("integer"), facets, false);
            facets.clear();
            facets.put(SchemaSymbols.ELT_MAXINCLUSIVE, "2147483647");
            facets.put(SchemaSymbols.ELT_MININCLUSIVE, "-2147483648");
            this.createSchemaDatatypeValidator("int", this.getDatatypeValidator("long"), facets, false);
            facets.clear();
            facets.put(SchemaSymbols.ELT_MAXINCLUSIVE, "32767");
            facets.put(SchemaSymbols.ELT_MININCLUSIVE, "-32768");
            this.createSchemaDatatypeValidator("short", this.getDatatypeValidator("int"), facets, false);
            facets.clear();
            facets.put(SchemaSymbols.ELT_MAXINCLUSIVE, "127");
            facets.put(SchemaSymbols.ELT_MININCLUSIVE, "-128");
            this.createSchemaDatatypeValidator("byte", this.getDatatypeValidator("short"), facets, false);
            facets.clear();
            facets.put(SchemaSymbols.ELT_MININCLUSIVE, "0");
            this.createSchemaDatatypeValidator("nonNegativeInteger", this.getDatatypeValidator("integer"), facets, false);
            facets.clear();
            facets.put(SchemaSymbols.ELT_MAXINCLUSIVE, "18446744073709551615");
            this.createSchemaDatatypeValidator("unsignedLong", this.getDatatypeValidator("nonNegativeInteger"), facets, false);
            facets.clear();
            facets.put(SchemaSymbols.ELT_MAXINCLUSIVE, "4294967295");
            this.createSchemaDatatypeValidator("unsignedInt", this.getDatatypeValidator("unsignedLong"), facets, false);
            facets.clear();
            facets.put(SchemaSymbols.ELT_MAXINCLUSIVE, "65535");
            this.createSchemaDatatypeValidator("unsignedShort", this.getDatatypeValidator("unsignedInt"), facets, false);
            facets.clear();
            facets.put(SchemaSymbols.ELT_MAXINCLUSIVE, "255");
            this.createSchemaDatatypeValidator("unsignedByte", this.getDatatypeValidator("unsignedShort"), facets, false);
            facets.clear();
            facets.put(SchemaSymbols.ELT_MININCLUSIVE, "1");
            this.createSchemaDatatypeValidator("positiveInteger", this.getDatatypeValidator("nonNegativeInteger"), facets, false);
            ((IDDatatypeValidator)this.getDatatypeValidator("ID")).setTokenType("ID(NCName)");
            ((IDREFDatatypeValidator)this.getDatatypeValidator("IDREF")).setTokenType("IDREF(NCName)");
            QNameDatatypeValidator.setNCNameValidator(this.getDatatypeValidator("NCName"));
            this.fRegistryExpanded = (byte)2;
        }
    }

    public void resetRegistry() {
        this.fRegistry.clear();
        this.fSchemaValidation = 0;
    }

    public DatatypeValidator createDatatypeValidator(String typeName, DatatypeValidator base, Hashtable facets, boolean list) {
        if (base == null) {
            return null;
        }
        DatatypeValidator simpleType = this.createXMLSchemaValidator(typeName, base, facets, list);
        this.registerUserDefinedValidator(typeName, simpleType);
        return simpleType;
    }

    public DatatypeValidator createDatatypeValidator(String typeName, Vector validators) {
        UnionDatatypeValidator simpleType = null;
        if (validators != null) {
            simpleType = new UnionDatatypeValidator(validators, null);
        }
        if (simpleType != null) {
            this.registerUserDefinedValidator(typeName, simpleType);
        }
        return simpleType;
    }

    public DatatypeValidator getDatatypeValidator(String type) {
        AbstractDatatypeValidator simpleType = null;
        if (type == null) {
            return null;
        }
        simpleType = (AbstractDatatypeValidator)this.fDTDDatatypeRegistry.get(type);
        if (simpleType == null && this.fSchemaValidation == 1 && (simpleType = (AbstractDatatypeValidator)this.fSchemaDatatypeRegistry.get(type)) == null) {
            return (DatatypeValidator)this.fRegistry.get(type);
        }
        return simpleType;
    }

    private DatatypeValidator createSchemaDatatypeValidator(String typeName, DatatypeValidator base, Hashtable facets, boolean list) {
        DatatypeValidator primitive = this.createXMLSchemaValidator(typeName, base, facets, list);
        this.registerXMLSchemaValidator(typeName, primitive);
        return primitive;
    }

    private DatatypeValidator createDTDDatatypeValidator(String typeName, DatatypeValidator base, Hashtable facets, boolean list) {
        DatatypeValidator primitive = this.createXMLSchemaValidator(typeName, base, facets, list);
        this.registerDTDValidator(typeName, primitive);
        return primitive;
    }

    private DatatypeValidator createXMLSchemaValidator(String typeName, DatatypeValidator base, Hashtable facets, boolean list) {
        DatatypeValidator simpleType = null;
        if (list) {
            simpleType = new ListDatatypeValidator(base, facets, list, null);
        } else {
            try {
                String value = (String)facets.get(SchemaSymbols.ELT_WHITESPACE);
                if (value != null && !(base instanceof StringDatatypeValidator) && !value.equals("collapse")) {
                    facets.remove(SchemaSymbols.ELT_WHITESPACE);
                }
                Class<?> validatorDef = base.getClass();
                Class[] validatorArgsClass = new Class[]{class$org$apache$xerces$impl$dv$xs$DatatypeValidator == null ? (class$org$apache$xerces$impl$dv$xs$DatatypeValidator = DatatypeValidatorFactoryImpl.class$("org.apache.xerces.impl.dv.xs.DatatypeValidator")) : class$org$apache$xerces$impl$dv$xs$DatatypeValidator, class$java$util$Hashtable == null ? (class$java$util$Hashtable = DatatypeValidatorFactoryImpl.class$("java.util.Hashtable")) : class$java$util$Hashtable, Boolean.TYPE};
                Object[] validatorArgs = new Object[]{base, facets, Boolean.FALSE};
                Constructor<?> validatorConstructor = validatorDef.getConstructor(validatorArgsClass);
                simpleType = (DatatypeValidator)DatatypeValidatorFactoryImpl.createDatatypeValidator(validatorConstructor, validatorArgs);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        return simpleType;
    }

    private void registerUserDefinedValidator(String typeName, DatatypeValidator simpleType) {
        if (simpleType != null) {
            this.fRegistry.put(typeName, simpleType);
        }
    }

    private void registerXMLSchemaValidator(String typeName, DatatypeValidator simpleType) {
        if (simpleType != null) {
            this.fSchemaDatatypeRegistry.put(typeName, simpleType);
        }
    }

    private void registerDTDValidator(String typeName, DatatypeValidator simpleType) {
        if (simpleType != null) {
            this.fDTDDatatypeRegistry.put(typeName, simpleType);
        }
    }

    private static Object createDatatypeValidator(Constructor validatorConstructor, Object[] arguments) {
        Object validator = null;
        try {
            validator = validatorConstructor.newInstance(arguments);
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        return validator;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

