/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.xerces.util.MessageFormatter;

public class DatatypeMessageProvider
implements MessageFormatter {
    public static final String DATATYPE_DOMAIN = "http://www.w3.org/TR/xml-schema-2";
    private Locale fLocale = null;
    private ResourceBundle fResourceBundle = null;
    private static int counter = 0;
    public static final int MSG_BAD_MAJORCODE = counter++;
    public static final int MSG_FORMAT_FAILURE = counter++;
    public static final int NOT_BOOLEAN = counter++;
    public static final int NOT_DECIMAL = counter++;
    public static final int NOT_FLOAT = counter++;
    public static final int NOT_DOUBLE = counter++;
    public static final int INVALID_ENUM_VALUE = counter++;
    public static final int OUT_OF_BOUNDS = counter++;
    public static final int NOT_ENUM_VALUE = counter++;
    public static final int FRACTION_GREATER_TOTALDIGITS = counter++;
    public static final int FRACTION_EXCEEDED = counter++;
    public static final int TOTALDIGITS_EXCEEDED = counter++;
    public static final int ILLEGAL_FACET_VALUE = counter++;
    public static final int ILLEGAL_ANYURI_FACET = counter++;
    public static final int ILLEGAL_BOOLEAN_FACET = counter++;
    public static final int ILLEGAL_BASE64_FACET = counter++;
    public static final int ILLEGAL_DATETIME_FACET = counter++;
    public static final int ILLEGAL_DECIMAL_FACET = counter++;
    public static final int ILLEGAL_DOUBLE_FACET = counter++;
    public static final int ILLEGAL_FLOAT_FACET = counter++;
    public static final int ILLEGAL_HEXBINARY_FACET = counter++;
    public static final int ILLEGAL_NOTATION_FACET = counter++;
    public static final int ILLEGAL_QNAME_FACET = counter++;
    public static final int ILLEGAL_STRING_FACET = counter++;
    public static final int ILLEGAL_LIST_FACET = counter++;
    public static final int ILLEGAL_UNION_FACET = counter++;
    public static final int ILLEGAL_ANYSIMPLETYPE_FACET = counter++;
    public static final int MSG_MAX_CODE = counter;
    public static final int MSG_NONE = 0;
    public static final String[] fgMessageKeys = new String[]{"BadMajorCode", "FormatFailed", "NotBoolean", "NotDecimal", "NotFloat", "NotDouble", "InvalidEnumValue", "OutOfBounds", "NotAnEnumValue", "FractionDigitsLargerThanTotalDigits", "FractionDigitsExceeded", "TotalDigitsExceeded", "IllegalFacetValue", "IllegalAnyURIFacet", "IllegalBooleanFacet", "IllegalBase64Facet", "IllegalDateTimeFacet", "IllegalDecimalFacet", "IllegalDoubleFacet", "IllegalFloatFacet", "IllegalHexBinaryFacet", "IllegalNotationFacet", "IllegalQNameFacet", "IllegalStringFacet", "IllegalListFacet", "IllegalUnionFacet", "IllegalAnySimpleTypeFacet"};

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    public Locale getLocale() {
        return this.fLocale;
    }

    public String formatMessage(Locale locale, String key, Object[] args) throws MissingResourceException {
        boolean throwex = false;
        if (this.fResourceBundle == null || locale != this.fLocale) {
            if (locale != null) {
                this.fResourceBundle = ResourceBundle.getBundle("org.apache.xerces.impl.msg.DatatypeMessages", locale);
            }
            if (this.fResourceBundle == null) {
                this.fResourceBundle = ResourceBundle.getBundle("org.apache.xerces.impl.msg.DatatypeMessages");
            }
        }
        int majorCode = -1;
        int i = 0;
        while (i < fgMessageKeys.length) {
            if (fgMessageKeys[i].equals(key)) {
                majorCode = i;
                break;
            }
            ++i;
        }
        if (majorCode == -1) {
            majorCode = MSG_BAD_MAJORCODE;
            throwex = true;
        }
        String msgKey = fgMessageKeys[majorCode];
        String msg = this.fResourceBundle.getString(msgKey);
        if (args != null) {
            try {
                msg = MessageFormat.format(msg, args);
            }
            catch (Exception e) {
                msg = this.fResourceBundle.getString(fgMessageKeys[MSG_FORMAT_FAILURE]);
                msg = msg + " " + this.fResourceBundle.getString(msgKey);
            }
        }
        if (throwex) {
            throw new RuntimeException(msg);
        }
        return msg;
    }
}

