/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.ElementImpl;
import org.w3c.dom.DOMException;

public class ElementNSImpl
extends ElementImpl {
    static final long serialVersionUID = -9142310625494392642L;
    static final String xmlURI = "http://www.w3.org/XML/1998/namespace";
    protected String namespaceURI;
    protected String localName;

    protected ElementNSImpl(CoreDocumentImpl ownerDocument, String namespaceURI, String qualifiedName) throws DOMException {
        super(ownerDocument, qualifiedName);
        int index = qualifiedName.indexOf(58);
        if (index < 0) {
            Object prefix = null;
            this.localName = qualifiedName;
        } else {
            String prefix = qualifiedName.substring(0, index);
            this.localName = qualifiedName.substring(index + 1);
            if (ownerDocument.errorChecking) {
                if (namespaceURI == null || this.localName.length() == 0 || this.localName.indexOf(58) >= 0) {
                    throw new DOMException(14, "DOM003 Namespace error");
                }
                if (prefix.equals("xml") ? !namespaceURI.equals(xmlURI) : index == 0) {
                    throw new DOMException(14, "DOM003 Namespace error");
                }
            }
        }
        this.namespaceURI = namespaceURI;
    }

    protected ElementNSImpl(CoreDocumentImpl ownerDocument, String value) {
        super(ownerDocument, value);
    }

    public String getNamespaceURI() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.namespaceURI;
    }

    public String getPrefix() {
        int index;
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return (index = this.name.indexOf(58)) < 0 ? null : this.name.substring(0, index);
    }

    public void setPrefix(String prefix) throws DOMException {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.ownerDocument().errorChecking) {
            if (this.isReadOnly()) {
                throw new DOMException(7, "DOM001 Modification not allowed");
            }
            if (!CoreDocumentImpl.isXMLName(prefix)) {
                throw new DOMException(5, "DOM002 Illegal character");
            }
            if (this.namespaceURI == null) {
                throw new DOMException(14, "DOM003 Namespace error");
            }
            if (prefix != null && prefix.equals("xml") && !this.namespaceURI.equals(xmlURI)) {
                throw new DOMException(14, "DOM003 Namespace error");
            }
        }
        this.name = prefix + ":" + this.localName;
    }

    public String getLocalName() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.localName;
    }
}

