/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.AttrNSImpl;
import org.apache.xerces.dom.CDATASectionImpl;
import org.apache.xerces.dom.ChildNode;
import org.apache.xerces.dom.CommentImpl;
import org.apache.xerces.dom.CoreDOMImplementationImpl;
import org.apache.xerces.dom.DeepNodeListImpl;
import org.apache.xerces.dom.DocumentFragmentImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xerces.dom.ElementDefinitionImpl;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.ElementNSImpl;
import org.apache.xerces.dom.EntityImpl;
import org.apache.xerces.dom.EntityReferenceImpl;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.dom.NodeListCache;
import org.apache.xerces.dom.NotationImpl;
import org.apache.xerces.dom.ParentNode;
import org.apache.xerces.dom.ProcessingInstructionImpl;
import org.apache.xerces.dom.TextImpl;
import org.apache.xerces.util.XMLChar;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

public class CoreDocumentImpl
extends ParentNode
implements Document {
    static final long serialVersionUID = 0L;
    protected DocumentTypeImpl docType;
    protected ElementImpl docElement;
    NodeListCache fFreeNLCache;
    protected String encoding;
    protected String version;
    protected boolean standalone;
    protected Hashtable identifiers;
    protected static int[] kidOK = new int[13];
    protected int changes = 0;
    protected boolean allowGrammarAccess;
    protected boolean errorChecking = true;

    public CoreDocumentImpl() {
        this(false);
    }

    public CoreDocumentImpl(boolean grammarAccess) {
        super(null);
        this.ownerDocument = this;
        this.allowGrammarAccess = grammarAccess;
    }

    public CoreDocumentImpl(DocumentType doctype) {
        this(doctype, false);
    }

    public CoreDocumentImpl(DocumentType doctype, boolean grammarAccess) {
        this(grammarAccess);
        if (doctype != null) {
            try {
                DocumentTypeImpl doctypeImpl = (DocumentTypeImpl)doctype;
            }
            catch (ClassCastException e) {
                throw new DOMException(4, "DOM005 Wrong document");
            }
            doctypeImpl.ownerDocument = this;
            this.appendChild(doctype);
        }
    }

    public final Document getOwnerDocument() {
        return null;
    }

    public short getNodeType() {
        return 9;
    }

    public String getNodeName() {
        return "#document";
    }

    public Node cloneNode(boolean deep) {
        CoreDocumentImpl newdoc = new CoreDocumentImpl();
        this.cloneNode(newdoc, deep);
        return newdoc;
    }

    protected void cloneNode(CoreDocumentImpl newdoc, boolean deep) {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        if (deep) {
            Hashtable reversedIdentifiers = null;
            if (this.identifiers != null) {
                reversedIdentifiers = new Hashtable();
                Enumeration elementIds = this.identifiers.keys();
                while (elementIds.hasMoreElements()) {
                    Object elementId = elementIds.nextElement();
                    reversedIdentifiers.put(this.identifiers.get(elementId), elementId);
                }
            }
            ChildNode kid = this.firstChild;
            while (kid != null) {
                newdoc.appendChild(newdoc.importNode(kid, true, reversedIdentifiers));
                kid = kid.nextSibling;
            }
        }
        newdoc.allowGrammarAccess = this.allowGrammarAccess;
        newdoc.errorChecking = this.errorChecking;
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        short type = newChild.getNodeType();
        if (this.errorChecking && (type == 1 && this.docElement != null || type == 10 && this.docType != null)) {
            throw new DOMException(3, "DOM006 Hierarchy request error");
        }
        super.insertBefore(newChild, refChild);
        if (type == 1) {
            this.docElement = (ElementImpl)newChild;
        } else if (type == 10) {
            this.docType = (DocumentTypeImpl)newChild;
        }
        return newChild;
    }

    public Node removeChild(Node oldChild) throws DOMException {
        super.removeChild(oldChild);
        short type = oldChild.getNodeType();
        if (type == 1) {
            this.docElement = null;
        } else if (type == 10) {
            this.docType = null;
        }
        return oldChild;
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        super.replaceChild(newChild, oldChild);
        short type = oldChild.getNodeType();
        if (type == 1) {
            this.docElement = (ElementImpl)newChild;
        } else if (type == 10) {
            this.docType = (DocumentTypeImpl)newChild;
        }
        return oldChild;
    }

    public Attr createAttribute(String name) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(name)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        return new AttrImpl(this, name);
    }

    public CDATASection createCDATASection(String data) throws DOMException {
        return new CDATASectionImpl(this, data);
    }

    public Comment createComment(String data) {
        return new CommentImpl(this, data);
    }

    public DocumentFragment createDocumentFragment() {
        return new DocumentFragmentImpl(this);
    }

    public Element createElement(String tagName) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(tagName)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        return new ElementImpl(this, tagName);
    }

    public EntityReference createEntityReference(String name) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(name)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        return new EntityReferenceImpl(this, name);
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(target)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        return new ProcessingInstructionImpl(this, target, data);
    }

    public Text createTextNode(String data) {
        return new TextImpl(this, data);
    }

    public DocumentType getDoctype() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this.docType;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean getStandalone() {
        return this.standalone;
    }

    public Element getDocumentElement() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this.docElement;
    }

    public NodeList getElementsByTagName(String tagname) {
        return new DeepNodeListImpl(this, tagname);
    }

    public DOMImplementation getImplementation() {
        return CoreDOMImplementationImpl.getDOMImplementation();
    }

    public void setErrorChecking(boolean check) {
        this.errorChecking = check;
    }

    public void setStrictErrorChecking(boolean check) {
        this.errorChecking = check;
    }

    public void setEncoding(String value) {
        this.encoding = value;
    }

    public void setVersion(String value) {
        this.version = value;
    }

    public void setStandalone(boolean value) {
        this.standalone = value;
    }

    public boolean getErrorChecking() {
        return this.errorChecking;
    }

    public boolean getStrictErrorChecking() {
        return this.errorChecking;
    }

    void setMutationEvents(boolean set) {
    }

    boolean getMutationEvents() {
        return false;
    }

    public DocumentType createDocumentType(String qualifiedName, String publicID, String systemID) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(qualifiedName)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        return new DocumentTypeImpl(this, qualifiedName, publicID, systemID);
    }

    public Entity createEntity(String name) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(name)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        return new EntityImpl(this, name);
    }

    public Notation createNotation(String name) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(name)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        return new NotationImpl(this, name);
    }

    public ElementDefinitionImpl createElementDefinition(String name) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(name)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        return new ElementDefinitionImpl(this, name);
    }

    public Node importNode(Node source, boolean deep) throws DOMException {
        return this.importNode(source, deep, null);
    }

    private Node importNode(Node source, boolean deep, Hashtable reversedIdentifiers) throws DOMException {
        Node newnode = null;
        short type = source.getNodeType();
        switch (type) {
            case 1: {
                Object elementId;
                boolean domLevel20 = source.getOwnerDocument().getImplementation().hasFeature("XML", "2.0");
                Element newElement = !domLevel20 || source.getLocalName() == null ? this.createElement(source.getNodeName()) : this.createElementNS(source.getNamespaceURI(), source.getNodeName());
                NamedNodeMap sourceAttrs = source.getAttributes();
                if (sourceAttrs != null) {
                    int length = sourceAttrs.getLength();
                    int index = 0;
                    while (index < length) {
                        Attr attr = (Attr)sourceAttrs.item(index);
                        if (attr.getSpecified()) {
                            Attr newAttr = (Attr)this.importNode(attr, true, reversedIdentifiers);
                            if (!domLevel20 || attr.getLocalName() == null) {
                                newElement.setAttributeNode(newAttr);
                            } else {
                                newElement.setAttributeNodeNS(newAttr);
                            }
                        }
                        ++index;
                    }
                }
                if (reversedIdentifiers != null && (elementId = reversedIdentifiers.get(source)) != null) {
                    if (this.identifiers == null) {
                        this.identifiers = new Hashtable();
                    }
                    this.identifiers.put(elementId, newElement);
                }
                newnode = newElement;
                break;
            }
            case 2: {
                newnode = source.getOwnerDocument().getImplementation().hasFeature("XML", "2.0") ? (source.getLocalName() == null ? this.createAttribute(source.getNodeName()) : this.createAttributeNS(source.getNamespaceURI(), source.getNodeName())) : this.createAttribute(source.getNodeName());
                if (source instanceof AttrImpl) {
                    AttrImpl attr = (AttrImpl)source;
                    if (attr.hasStringValue()) {
                        AttrImpl newattr = (AttrImpl)newnode;
                        newattr.setValue(attr.getValue());
                        deep = false;
                        break;
                    }
                    deep = true;
                    break;
                }
                if (source.getFirstChild() == null) {
                    newnode.setNodeValue(source.getNodeValue());
                    deep = false;
                    break;
                }
                deep = true;
                break;
            }
            case 3: {
                newnode = this.createTextNode(source.getNodeValue());
                break;
            }
            case 4: {
                newnode = this.createCDATASection(source.getNodeValue());
                break;
            }
            case 5: {
                newnode = this.createEntityReference(source.getNodeName());
                ((EntityReferenceImpl)newnode).isReadOnly(false);
                break;
            }
            case 6: {
                Entity srcentity = (Entity)source;
                EntityImpl newentity = (EntityImpl)this.createEntity(source.getNodeName());
                newentity.setPublicId(srcentity.getPublicId());
                newentity.setSystemId(srcentity.getSystemId());
                newentity.setNotationName(srcentity.getNotationName());
                newentity.isReadOnly(false);
                newnode = newentity;
                break;
            }
            case 7: {
                newnode = this.createProcessingInstruction(source.getNodeName(), source.getNodeValue());
                break;
            }
            case 8: {
                newnode = this.createComment(source.getNodeValue());
                break;
            }
            case 10: {
                int i;
                DocumentType srcdoctype = (DocumentType)source;
                DocumentTypeImpl newdoctype = (DocumentTypeImpl)this.createDocumentType(srcdoctype.getNodeName(), srcdoctype.getPublicId(), srcdoctype.getSystemId());
                NamedNodeMap smap = srcdoctype.getEntities();
                NamedNodeMap tmap = newdoctype.getEntities();
                if (smap != null) {
                    i = 0;
                    while (i < smap.getLength()) {
                        tmap.setNamedItem(this.importNode(smap.item(i), true, reversedIdentifiers));
                        ++i;
                    }
                }
                smap = srcdoctype.getNotations();
                tmap = newdoctype.getNotations();
                if (smap != null) {
                    i = 0;
                    while (i < smap.getLength()) {
                        tmap.setNamedItem(this.importNode(smap.item(i), true, reversedIdentifiers));
                        ++i;
                    }
                }
                newnode = newdoctype;
                break;
            }
            case 11: {
                newnode = this.createDocumentFragment();
                break;
            }
            case 12: {
                Notation srcnotation = (Notation)source;
                NotationImpl newnotation = (NotationImpl)this.createNotation(source.getNodeName());
                newnotation.setPublicId(srcnotation.getPublicId());
                newnotation.setSystemId(srcnotation.getSystemId());
                newnode = newnotation;
                break;
            }
            default: {
                throw new DOMException(9, "Node type being imported is not supported");
            }
        }
        if (deep) {
            Node srckid = source.getFirstChild();
            while (srckid != null) {
                newnode.appendChild(this.importNode(srckid, true, reversedIdentifiers));
                srckid = srckid.getNextSibling();
            }
        }
        if (newnode.getNodeType() == 5 || newnode.getNodeType() == 6) {
            ((NodeImpl)newnode).setReadOnly(true, true);
        }
        return newnode;
    }

    /*
     * WARNING - void declaration
     */
    public Node adoptNode(Node source) {
        NodeImpl node;
        try {
            node = (NodeImpl)source;
        }
        catch (ClassCastException e) {
            return null;
        }
        switch (node.getNodeType()) {
            case 2: {
                AttrImpl attr = (AttrImpl)node;
                attr.getOwnerElement().removeAttributeNode(attr);
                attr.isSpecified(true);
                attr.setOwnerDocument(this);
                break;
            }
            case 9: 
            case 10: {
                throw new DOMException(9, "cannot adopt this type of node.");
            }
            case 5: {
                NamedNodeMap entities;
                Node entityNode;
                Node child;
                Node parent = node.getParentNode();
                if (parent != null) {
                    parent.removeChild(source);
                }
                while ((child = node.getFirstChild()) != null) {
                    void var4_8;
                    node.removeChild((Node)var4_8);
                }
                node.setOwnerDocument(this);
                if (this.docType == null || (entityNode = (entities = this.docType.getEntities()).getNamedItem(node.getNodeName())) == null) break;
                EntityImpl entity = (EntityImpl)entityNode;
                child = entityNode.getFirstChild();
                while (child != null) {
                    Node childClone = child.cloneNode(true);
                    node.appendChild(childClone);
                    child = child.getNextSibling();
                }
                break;
            }
            case 1: {
                Node parent = node.getParentNode();
                if (parent != null) {
                    parent.removeChild(source);
                }
                node.setOwnerDocument(this);
                ((ElementImpl)node).reconcileDefaultAttributes();
                break;
            }
            default: {
                Node parent = node.getParentNode();
                if (parent != null) {
                    parent.removeChild(source);
                }
                node.setOwnerDocument(this);
            }
        }
        return node;
    }

    public Element getElementById(String elementId) {
        return this.getIdentifier(elementId);
    }

    public void putIdentifier(String idName, Element element) {
        if (element == null) {
            this.removeIdentifier(idName);
            return;
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            this.identifiers = new Hashtable();
        }
        this.identifiers.put(idName, element);
    }

    public Element getIdentifier(String idName) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            return null;
        }
        return (Element)this.identifiers.get(idName);
    }

    public void removeIdentifier(String idName) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            return;
        }
        this.identifiers.remove(idName);
    }

    public Enumeration getIdentifiers() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            this.identifiers = new Hashtable();
        }
        return this.identifiers.keys();
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(qualifiedName)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        return new ElementNSImpl(this, namespaceURI, qualifiedName);
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(qualifiedName)) {
            throw new DOMException(5, "DOM002 Illegal character");
        }
        return new AttrNSImpl(this, namespaceURI, qualifiedName);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return new DeepNodeListImpl(this, namespaceURI, localName);
    }

    public Object clone() throws CloneNotSupportedException {
        CoreDocumentImpl newdoc = (CoreDocumentImpl)super.clone();
        newdoc.docType = null;
        newdoc.docElement = null;
        return newdoc;
    }

    public static boolean isXMLName(String s) {
        if (s == null) {
            return false;
        }
        return XMLChar.isValidName(s);
    }

    protected boolean isKidOK(Node parent, Node child) {
        if (this.allowGrammarAccess && parent.getNodeType() == 10) {
            return child.getNodeType() == 1;
        }
        return 0 != (kidOK[parent.getNodeType()] & 1 << child.getNodeType());
    }

    protected void changed() {
        ++this.changes;
    }

    protected int changes() {
        return this.changes;
    }

    NodeListCache getNodeListCache(ParentNode owner) {
        if (this.fFreeNLCache == null) {
            return new NodeListCache(owner);
        }
        NodeListCache c = this.fFreeNLCache;
        this.fFreeNLCache = this.fFreeNLCache.next;
        c.fChild = null;
        c.fChildIndex = -1;
        c.fLength = -1;
        if (c.fOwner != null) {
            c.fOwner.fNodeListCache = null;
        }
        c.fOwner = owner;
        return c;
    }

    void freeNodeListCache(NodeListCache c) {
        c.next = this.fFreeNLCache;
        this.fFreeNLCache = c;
    }

    protected void setUserData(NodeImpl n, Object data) {
    }

    protected Object getUserData(NodeImpl n) {
        return null;
    }

    protected void addEventListener(NodeImpl node, String type, EventListener listener, boolean useCapture) {
    }

    protected void removeEventListener(NodeImpl node, String type, EventListener listener, boolean useCapture) {
    }

    protected boolean dispatchEvent(NodeImpl node, Event event) {
        return false;
    }

    void replacedText(NodeImpl node) {
    }

    void deletedText(NodeImpl node, int offset, int count) {
    }

    void insertedText(NodeImpl node, int offset, int count) {
    }

    void modifyingCharacterData(NodeImpl node) {
    }

    void modifiedCharacterData(NodeImpl node, String oldvalue, String value) {
    }

    void insertingNode(NodeImpl node, boolean replace) {
    }

    void insertedNode(NodeImpl node, NodeImpl newInternal, boolean replace) {
    }

    void removingNode(NodeImpl node, NodeImpl oldChild, boolean replace) {
    }

    void removedNode(NodeImpl node, boolean replace) {
    }

    void replacingNode(NodeImpl node) {
    }

    void replacedNode(NodeImpl node) {
    }

    void modifiedAttrValue(AttrImpl attr, String oldvalue) {
    }

    void setAttrNode(AttrImpl attr, AttrImpl previous) {
    }

    void removedAttrNode(AttrImpl attr, NodeImpl oldOwner, String name) {
    }

    static {
        CoreDocumentImpl.kidOK[9] = 1410;
        CoreDocumentImpl.kidOK[1] = 442;
        CoreDocumentImpl.kidOK[5] = 442;
        CoreDocumentImpl.kidOK[6] = 442;
        CoreDocumentImpl.kidOK[11] = 442;
        CoreDocumentImpl.kidOK[2] = 40;
        CoreDocumentImpl.kidOK[12] = 0;
        CoreDocumentImpl.kidOK[4] = 0;
        CoreDocumentImpl.kidOK[3] = 0;
        CoreDocumentImpl.kidOK[8] = 0;
        CoreDocumentImpl.kidOK[7] = 0;
        CoreDocumentImpl.kidOK[10] = 0;
    }
}

