/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.xlog;

import com.sap.dbtechtest.xlog.AbstractInfo;
import com.sap.dbtechtest.xlog.Failure;
import com.sap.dbtechtest.xlog.LogWriter;
import com.sap.dbtechtest.xlog.Parameter;
import com.sap.dbtechtest.xlog.Warning;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;

public class LogWriterXML
extends LogWriter {
    protected PrintWriter writer;

    public LogWriterXML() {
        this(null);
    }

    public LogWriterXML(String string) {
        super(string);
        if (string == null || string.equals("-")) {
            this.writer = new PrintWriter(System.out);
        } else {
            try {
                this.writer = new PrintWriter(new FileOutputStream(string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.writer = new PrintWriter(System.out);
            }
        }
    }

    public void start(String string) throws IOException {
        FileWriter fileWriter = new FileWriter(string);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        this.start(new PrintWriter(bufferedWriter));
    }

    public void start(PrintWriter printWriter) {
        this.writer = printWriter;
        this.start();
    }

    public void start() {
        this.writer.println("<Log name='" + this.current.name + "'>");
        if (this.current.parameters.size() > 0) {
            this.writer.println("    <Parameters>");
            Enumeration enumeration = this.current.parameters.elements();
            String string = "        ";
            while (enumeration.hasMoreElements()) {
                Parameter parameter = (Parameter)enumeration.nextElement();
                this.writer.println(parameter.toXML(string));
            }
            this.writer.println("    </Parameters>");
        }
        this.writer.println("    <Content>");
        this.writer.flush();
    }

    public void stop() {
        this.stopFluff();
        this.writer.println("    </Content>");
        if (this.hasErrors()) {
            this.writer.println("    <Failures>");
            Enumeration enumeration = this.current.failures.elements();
            while (enumeration.hasMoreElements()) {
                Failure failure = (Failure)enumeration.nextElement();
                failure.toXML(this.writer, "        ");
            }
            this.writer.println("    </Failures>");
        } else if (this.current.warnings.size() == 0) {
            this.writer.println("    <Success/>");
        } else {
            this.writer.println("    <Success>");
            Enumeration enumeration = this.current.warnings.elements();
            while (enumeration.hasMoreElements()) {
                Warning warning = (Warning)enumeration.nextElement();
                warning.toXML(this.writer, "        ");
            }
            this.writer.println("    </Success>");
        }
        this.writer.println("</Log><!--" + this.current.name + "-->");
        this.writer.flush();
    }

    protected void stopFluff() {
        if (this.fluffing) {
            this.writer.println("        </Fluff>");
            this.fluffing = false;
        }
    }

    protected void showInfo(AbstractInfo abstractInfo) {
        if (this.verbose) {
            if (!this.fluffing) {
                this.writer.println("        <Fluff>");
            }
            this.fluffing = true;
            abstractInfo.toXML(this.writer, "            ", true);
        }
    }

    public void dumpStack() {
        Enumeration enumeration = this.nesting.elements();
        System.out.println("<LogFile var=\"nesting\">");
        while (enumeration.hasMoreElements()) {
            System.out.println(enumeration.nextElement());
        }
        System.out.println("</LogFile>");
    }

    public void flush() {
        this.writer.flush();
    }

    public void dumpFailureTree() {
        this.failures.dumpPlain(new PrintWriter(System.out));
    }
}

