/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.xlog;

import java.io.PrintWriter;
import java.util.StringTokenizer;

public class AbstractInfo {
    protected String metaKind;
    protected String context;
    protected String message;

    public AbstractInfo(String string, String string2, String string3) {
        this.metaKind = string;
        this.context = string2;
        this.message = string3;
    }

    public AbstractInfo(String string, String string2) {
        this(string, null, string2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getKind());
        stringBuffer.append('(');
        if (this.context != null) {
            stringBuffer.append(this.context);
            stringBuffer.append(": ");
        }
        stringBuffer.append(this.getMessage());
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public String getMessage() {
        return this.message;
    }

    public String getMetaKind() {
        return this.metaKind;
    }

    public String getKind() {
        return this.metaKind;
    }

    protected String getAttributeString() {
        return null;
    }

    public void toXML(PrintWriter printWriter, String string, boolean bl) {
        String string2 = this.getMetaKind();
        printWriter.print(string);
        this.openXMLTag(printWriter, string2);
        this.writeXMLContent(printWriter, bl);
        this.closeXMLTag(printWriter, string2);
    }

    public void toXML(PrintWriter printWriter, String string) {
        this.toXML(printWriter, string, false);
    }

    protected void openXMLTag(PrintWriter printWriter, String string) {
        String string2 = this.getAttributeString();
        printWriter.print('<');
        printWriter.print(string);
        if (this.context != null) {
            printWriter.print(" context='");
            printWriter.print(this.filterXMLContent(this.context));
            printWriter.print('\'');
        }
        if (string2 != null) {
            printWriter.print(' ');
            printWriter.print(string2);
        }
        printWriter.print('>');
    }

    protected void closeXMLTag(PrintWriter printWriter, String string) {
        printWriter.print("</");
        printWriter.print(string);
        printWriter.println('>');
    }

    protected void writeXMLContent(PrintWriter printWriter, boolean bl) {
        printWriter.print(this.filterXMLContent(this.getMessage()));
    }

    protected String filterXMLContent(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "<>&\r\n", true);
        block6: while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            switch (string2.charAt(0)) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block6;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block6;
                }
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }
}

