/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.util;

import com.sap.dbtech.util.Tracer;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

public class ObjectServices {
    private ObjectServices() {
    }

    public static String toString(Object object) {
        if (object == null) {
            return "<null>";
        }
        if (object instanceof String) {
            String string = (String)object;
            return "\"" + string.substring(0, string.length() > 10 ? 10 : string.length()) + " ...\"";
        }
        if (object instanceof Clob) {
            try {
                Clob clob = (Clob)object;
                return "\"" + clob.getSubString(1L, clob.length() > 10L ? 10 : (int)clob.length()) + " ...\"";
            }
            catch (Exception exception) {
                return "Clob value";
            }
        }
        if (object instanceof Blob) {
            try {
                Blob blob = (Blob)object;
                return "\"" + Tracer.Hex2String((byte[])blob.getBytes(1L, blob.length() > 10L ? 10 : (int)blob.length())) + " ...\"";
            }
            catch (Exception exception) {
                return "Clob value";
            }
        }
        if (ObjectServices.isArray(object)) {
            return ObjectServices.arrayToString(object);
        }
        if (object instanceof Number) {
            return ObjectServices.classBase(object) + "(" + object + ")";
        }
        if (object instanceof Date) {
            return ObjectServices.classBase(object) + "(" + object + ")";
        }
        return object.toString();
    }

    private static String arrayToString(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "[";
        int n = Array.getLength(object);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(string);
            stringBuffer.append(ObjectServices.toString(Array.get(object, i)));
            string = ", ";
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public static String classBase(Object object) {
        String string = object.getClass().getName();
        int n = string.lastIndexOf(46);
        String string2 = n == -1 ? string : string.substring(n + 1);
        return string2;
    }

    public static boolean isEqual(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.equals(object2)) {
            return true;
        }
        if (ObjectServices.areEqualNumbers(object, object2)) {
            return true;
        }
        if (ObjectServices.areEqualArrays(object, object2)) {
            return true;
        }
        return ObjectServices.areEqualDates(object, object2);
    }

    private static boolean areEqualNumbers(Object object, Object object2) {
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2;
        if (!(object instanceof Number)) {
            return false;
        }
        if (!(object2 instanceof Number)) {
            return false;
        }
        BigDecimal bigDecimal3 = ObjectServices.toBigDecimal(object);
        BigDecimal bigDecimal4 = bigDecimal3.subtract(bigDecimal2 = ObjectServices.toBigDecimal(object2)).abs();
        int n = bigDecimal4.compareTo(bigDecimal = bigDecimal3.movePointLeft(13).abs());
        return n <= 0;
    }

    protected static BigDecimal toBigDecimal(Object object) {
        if (object instanceof Double) {
            return new BigDecimal((Double)object);
        }
        if (object instanceof Float) {
            return new BigDecimal(((Float)object).toString());
        }
        return new BigDecimal(object.toString());
    }

    private static boolean areEqualArrays(Object object, Object object2) {
        int n;
        if (!ObjectServices.isArray(object)) {
            return false;
        }
        if (!ObjectServices.isArray(object2)) {
            return false;
        }
        int n2 = Array.getLength(object);
        if (n2 != (n = Array.getLength(object2))) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            Object object3;
            Object object4 = Array.get(object, i);
            if (ObjectServices.isEqual(object4, object3 = Array.get(object2, i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isArray(Object object) {
        if (object == null) {
            return false;
        }
        return object.getClass().isArray();
    }

    private static boolean areEqualDates(Object object, Object object2) {
        if (!(object instanceof Date)) {
            return false;
        }
        if (!(object2 instanceof Date)) {
            return false;
        }
        if (object instanceof Time && object2 instanceof Time) {
            Time time = (Time)object;
            Time time2 = (Time)object2;
            return time.getHours() == time2.getHours() && time.getMinutes() == time2.getMinutes() && time.getSeconds() == time2.getSeconds();
        }
        if (object instanceof java.sql.Date && object2 instanceof java.sql.Date) {
            java.sql.Date date = (java.sql.Date)object;
            java.sql.Date date2 = (java.sql.Date)object2;
            return date.getYear() == date2.getYear() && date.getMonth() == date2.getMonth() && date.getDay() == date2.getDay();
        }
        if (object instanceof Timestamp && object2 instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            Timestamp timestamp2 = (Timestamp)object2;
            return timestamp.getTime() == timestamp2.getTime() && timestamp.getNanos() / 1000 == timestamp2.getNanos() / 1000;
        }
        return object.equals(object2);
    }

    public static boolean areEqualInputStreams(InputStream inputStream, InputStream inputStream2) {
        byte[] byArray = new byte[4098];
        byte[] byArray2 = new byte[4098];
        boolean bl = true;
        try {
            while (bl) {
                int n;
                int n2 = inputStream.read(byArray);
                if (n2 != (n = inputStream2.read(byArray2))) {
                    return false;
                }
                for (int i = 0; i < n2; ++i) {
                    if (byArray[i] == byArray2[i]) continue;
                    return false;
                }
                if (n2 > 0) continue;
                bl = false;
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public static boolean areEqualReader(Reader reader, Reader reader2) {
        char[] cArray = new char[4098];
        char[] cArray2 = new char[4098];
        boolean bl = true;
        try {
            while (bl) {
                int n;
                int n2 = reader.read(cArray);
                if (n2 != (n = reader2.read(cArray2))) {
                    return false;
                }
                if (n2 == -1 && n == -1) {
                    return true;
                }
                for (int i = 0; i < n2; ++i) {
                    if (cArray[i] == cArray2[i]) continue;
                    return false;
                }
                if (n2 != 0) continue;
                bl = false;
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public static Object arrayResize(Object object, int n) {
        Object object2 = ObjectServices.arrayFromSample(object, n);
        if (object2 != null) {
            int n2 = Math.min(n, Array.getLength(object));
            System.arraycopy(object, 0, object2, 0, n2);
        }
        return object2;
    }

    protected static Object arrayFromSample(Object object, int n) {
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz == null) {
            return null;
        }
        Object object2 = Array.newInstance(clazz, n);
        return object2;
    }

    public static Object pasteArrays(Object[] objectArray) {
        int n;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < objectArray.length; ++n) {
            n2 += Array.getLength(objectArray[n]);
        }
        Object object = ObjectServices.arrayFromSample(objectArray[0], n2);
        for (n = 0; n < objectArray.length; ++n) {
            int n4 = Array.getLength(objectArray[n]);
            System.arraycopy(objectArray[n], 0, object, n3, n4);
            n3 += n4;
        }
        return object;
    }

    public static Object pasteArrays(Object object, Object object2) {
        return ObjectServices.pasteArrays(new Object[]{object, object2});
    }

    public static Class loadClass(String string) {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = null;
            classNotFoundException.printStackTrace();
            System.exit(9);
        }
        return clazz;
    }

    public static String substring(String string, int n, int n2) {
        return string.substring(n, Math.min(n2, string.length() - n));
    }
}

