/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.types;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class UTFFromStream
extends Test {
    private static final String help = "help for UTFFromStream";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public UTFFromStream(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public UTFFromStream(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = "UTFFromStream";
        String string2 = this.getUnicodeIdentifier(string);
        this.dropTable(string2);
        this.stmt.execute("create table " + string2 + " (a int, b long byte)");
        byte[] byArray = new byte[153600];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(i % 127);
        }
        PreparedStatement preparedStatement = this.connection.prepareStatement("insert into " + string2 + " values (?,?)");
        for (int i = 0; i < 5; ++i) {
            preparedStatement.setInt(1, 1);
            preparedStatement.setBytes(2, byArray);
            preparedStatement.addBatch();
        }
        preparedStatement.executeBatch();
        this.connection.commit();
        ResultSet resultSet = this.stmt.executeQuery("select a,b from " + string2 + "");
        while (resultSet.next()) {
            Blob blob = resultSet.getBlob(2);
            this.log.addDifference(string, "Checking blob length", new Long(153600L), new Long(blob.length()));
            InputStream inputStream = blob.getBinaryStream();
            try {
                int n = 0;
                for (int i = 0; i < 153600; ++i) {
                    byte by = (byte)inputStream.read();
                    if (byArray[i] == by) continue;
                    this.log.addFailure(new Failure(string, "Wrong long content at position " + i + " expected " + byArray[i] + " retrieved " + by));
                    if (++n <= 10) continue;
                    this.log.addFailure(new Failure(string, "Long column corrupt - Test interrupted"));
                    return;
                }
            }
            catch (IOException iOException) {
                this.log.addFailure(new Failure(iOException.toString()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        UTFFromStream uTFFromStream = new UTFFromStream(stringArray);
        try {
            uTFFromStream.runInner();
        }
        finally {
            uTFFromStream.connection.close();
        }
        if (uTFFromStream.log.hasErrors()) {
            System.exit(5);
        }
    }
}

