/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.types;

import com.sap.dbtechtest.util.ObjectServices;
import com.sap.dbtechtest.xlog.ExceptionOccurred;
import com.sap.dbtechtest.xlog.LogWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class TypeDefinition {
    private String jdbcName;
    private String columnDef;
    private Object[] values;
    static final Integer firstCol = new Integer(1);
    static final Integer undefLength = new Integer(-1);

    public TypeDefinition(String string, String string2, Object[] objectArray) {
        this.jdbcName = string;
        this.columnDef = string2;
        this.values = TypeDefinition.addNullArg(objectArray);
    }

    public TypeDefinition(String string, String string2, Object object) {
        this(string, string2, new Object[]{object});
    }

    protected String sqlcolumnDefinition() {
        return this.colName() + " " + this.columnDef;
    }

    protected String colName() {
        return this.jdbcName + "Col";
    }

    protected String insertString(String string) {
        return "insert into " + string + " (" + this.colName() + ") values (?)";
    }

    protected String selectString(String string) {
        return "select " + this.colName() + " from " + string;
    }

    public void runSimpleTest(Connection connection, String string, LogWriter logWriter) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("delete from " + string);
        PreparedStatement preparedStatement2 = connection.prepareStatement(this.insertString(string));
        PreparedStatement preparedStatement3 = connection.prepareStatement(this.selectString(string));
        for (int i = 0; i < this.values.length; ++i) {
            Object object = this.values[i];
            String string2 = this.jdbcName + ":" + this.columnDef + ":" + ObjectServices.toString(object);
            try {
                preparedStatement.execute();
                this.setInsertValue(preparedStatement2, object);
                preparedStatement2.execute();
                logWriter.addInfo(string2, "value inserted");
                ResultSet resultSet = preparedStatement3.executeQuery();
                if (!resultSet.next()) {
                    logWriter.addDifference(string2, "cursor.next ()", Boolean.TRUE, Boolean.FALSE);
                    continue;
                }
                Object object2 = this.getFetchValue(resultSet);
                logWriter.addDifference(string2, "fetch", object, object2);
                continue;
            }
            catch (SQLException sQLException) {
                logWriter.addFailure(new ExceptionOccurred(string2, sQLException));
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                logWriter.addFailure(new ExceptionOccurred(string2, invocationTargetException));
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                logWriter.addFailure(new ExceptionOccurred(string2, illegalAccessException));
            }
        }
    }

    protected void setInsertValue(PreparedStatement preparedStatement, Object object) throws SQLException, InvocationTargetException, IllegalAccessException {
        if (object == null) {
            preparedStatement.setNull(1, 0);
        } else if (this.jdbcName.endsWith("Stream")) {
            Method method = this.getMethod(preparedStatement.getClass(), "set" + this.jdbcName, 3);
            method.invoke((Object)preparedStatement, firstCol, object, undefLength);
        } else {
            Method method = this.getMethod(preparedStatement.getClass(), "set" + this.jdbcName, 2);
            method.invoke((Object)preparedStatement, firstCol, object);
        }
    }

    protected Method getMethod(Class clazz, String string, int n) throws IllegalAccessError {
        Object object;
        int n2;
        Object object2 = null;
        Vector<Object> vector = new Vector<Object>();
        Class<?>[] classArray = clazz.getInterfaces();
        for (n2 = 0; n2 < classArray.length; ++n2) {
            object = classArray[n2].getMethods();
            for (int i = 0; i < ((Method[])object).length; ++i) {
                vector.add(object[i]);
            }
        }
        for (n2 = 0; n2 < vector.size(); ++n2) {
            object = (Method)vector.elementAt(n2);
            if (!((Method)object).getName().equals(string) || ((Method)object).getParameterTypes().length != n || ((Method)object).getParameterTypes()[0] != Integer.TYPE) continue;
            object2 = object;
            break;
        }
        if (object2 == null) {
            throw new IllegalAccessError("no method " + string + " with exactly " + n + " argument(s)");
        }
        return object2;
    }

    protected Object getFetchValue(ResultSet resultSet) throws SQLException, InvocationTargetException, IllegalAccessException {
        Method method = this.getMethod(resultSet.getClass(), "get" + this.jdbcName, 1);
        Object object = method.invoke((Object)resultSet, firstCol);
        if (resultSet.wasNull()) {
            object = null;
        }
        return object;
    }

    public static String createTableString(String string, TypeDefinition[] typeDefinitionArray) {
        StringBuffer stringBuffer = new StringBuffer("create table " + string + " (");
        String string2 = "";
        for (int i = 0; i < typeDefinitionArray.length; ++i) {
            stringBuffer.append(string2);
            stringBuffer.append(typeDefinitionArray[i].sqlcolumnDefinition());
            string2 = ", ";
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    protected static Object[] addNullArg(Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length + 1];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        objectArray2[objectArray.length] = null;
        return objectArray2;
    }
}

