/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.types;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class LongsInDBProcedures
extends Test {
    private static final String help = "help for LongsInDBProcedures";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public LongsInDBProcedures(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public LongsInDBProcedures(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        if (!this.checkVersion("7.6.0")) {
            return;
        }
        String string = "LongsInDBProcedures";
        String string2 = this.getUnicodeIdentifier("TAB1");
        String string3 = this.getUnicodeIdentifier("TAB2");
        this.dropTable(string2);
        this.stmt.execute("CREATE TABLE " + string2 + " ( i int PRIMARY KEY, l1 long, l2 long , l3 long , l4 long, l5 long)");
        this.dropTable(string3);
        this.stmt.execute("CREATE TABLE " + string3 + " ( i int PRIMARY KEY, l1 long, l2 long, l5 long )");
        try {
            this.stmt.execute("drop DBPROC " + string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stmt.execute("create DBPROC " + string2 + " ( IN i int, IN l1 LONG, IN l2 LONG, IN l3 LONG, IN l4 LONG, IN l5 LONG) AS" + "\tVAR ix2 INTEGER;\t" + " insert into " + this.getUsername() + "." + string2 + " set \ti = :i," + "\t\t\tl1 = :l1," + "\t\t\tl2 = :l2," + "\t\t\tl3 = :l3," + "\t\t\tl4 = :l4," + "\t\t\tl5 = :l5;" + "\tSET ix2 = i * 2;" + "\tinsert into " + this.getUsername() + "." + string3 + " set\ti = :ix2," + "\t\t\tl1 = :l1," + "\t\t\tl2 = :l2," + "\t\t\tl5 = :l5;");
        CallableStatement callableStatement = this.connection.prepareCall("CALL " + string2 + " ( ?, ?, ?, ?, ?, ?)");
        String string4 = this.makeRandomString(100000);
        String string5 = this.makeRandomString(200000);
        String string6 = this.makeRandomString(2);
        String string7 = this.makeRandomString(111111);
        int n = 1;
        callableStatement.setInt(1, n);
        callableStatement.setString(2, string4);
        callableStatement.setString(3, string5);
        callableStatement.setString(4, string6);
        callableStatement.setString(5, string7);
        callableStatement.setNull(6, 2005);
        callableStatement.execute();
        this.vtraceFlush();
        this.connection.commit();
        ResultSet resultSet = this.stmt.executeQuery("SELECT * from " + string2);
        this.log.addDifference(string, "fetch next", Boolean.TRUE, new Boolean(resultSet.next()));
        this.log.addDifference(string, "check column 1", new Integer(n), new Integer(resultSet.getInt(1)));
        this.log.addDifference(string, "check column 2", string4, resultSet.getString(2));
        this.log.addDifference(string, "check column 3", string5, resultSet.getString(3));
        this.log.addDifference(string, "check column 4", string6, resultSet.getString(4));
        this.log.addDifference(string, "check column 5", string7, resultSet.getString(5));
        this.log.addDifference(string, "check column 6", "TRUE", resultSet.getString(6) == null ? "TRUE" : "FALSE");
        resultSet = this.stmt.executeQuery("SELECT * from " + string3);
        this.log.addDifference(string, "fetch next", Boolean.TRUE, new Boolean(resultSet.next()));
        this.log.addDifference(string, "check column 1", new Integer(n * 2), new Integer(resultSet.getInt(1)));
        this.log.addDifference(string, "check column 2", string4, resultSet.getString(2));
        this.log.addDifference(string, "check column 3", string5, resultSet.getString(3));
        this.log.addDifference(string, "check column 4", "TRUE", resultSet.getString(4) == null ? "TRUE" : "FALSE");
        this.connection.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        LongsInDBProcedures longsInDBProcedures = new LongsInDBProcedures(stringArray);
        try {
            longsInDBProcedures.runInner();
        }
        finally {
            longsInDBProcedures.connection.close();
        }
        if (longsInDBProcedures.log.hasErrors()) {
            System.exit(5);
        }
    }
}

