/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.types;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class ColumnDefinition {
    String typeName;
    int typeCode;
    int datalen;
    int frac;

    public ColumnDefinition(String string, int n, int n2, int n3) {
        this.typeName = string;
        this.typeCode = n;
        this.datalen = n2;
        this.frac = n3;
    }

    public ColumnDefinition(String string, int n, int n2) {
        this(string, n, n2, -1);
    }

    public String toString() {
        return "<ColDef " + this.typeName + "(" + this.datalen + ", " + this.frac + ")>";
    }

    public static ColumnDefinition getColumnDefinition(ResultSet resultSet, int n) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        String string = resultSetMetaData.getColumnTypeName(n);
        int n2 = resultSetMetaData.getColumnType(n);
        int n3 = resultSetMetaData.getPrecision(n);
        int n4 = resultSetMetaData.getScale(n);
        ColumnDefinition columnDefinition = new ColumnDefinition(string, n2, n3, n4);
        return columnDefinition;
    }

    public static ColumnDefinition getColumnDefinition(ResultSet resultSet) throws SQLException {
        return ColumnDefinition.getColumnDefinition(resultSet, 1);
    }

    public static ColumnDefinition getTableColumnDefinition(Connection connection, String string, String string2) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string2 + " from " + string);
        ColumnDefinition columnDefinition = ColumnDefinition.getColumnDefinition(resultSet, 1);
        resultSet.close();
        statement.close();
        return columnDefinition;
    }
}

