/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.types;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class CalendarTest
extends Test {
    private static final String help = "Test that the big decimal scale is correctly set.";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public CalendarTest(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public CalendarTest(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = this.getUnicodeIdentifier("TEST_CALENDAR");
        this.dropTable(string);
        this.stmt.execute("CREATE TABLE " + string + " (V TIMESTAMP)");
        long l = Date.parse("Sat, 12 Aug 1995 13:30:00 GMT");
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        PreparedStatement preparedStatement = this.connection.prepareStatement("INSERT INTO " + string + " VALUES (?)");
        Timestamp timestamp = new Timestamp(l);
        preparedStatement.setTimestamp(1, timestamp, calendar);
        preparedStatement.executeUpdate();
        this.connection.commit();
        ResultSet resultSet = this.stmt.executeQuery("SELECT V FROM " + string);
        resultSet.next();
        this.log.addDifference("CalendarTest", "Check Timestamp", timestamp, resultSet.getTimestamp(1, calendar));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        CalendarTest calendarTest = new CalendarTest(stringArray);
        try {
            calendarTest.runInner();
        }
        finally {
            calendarTest.connection.close();
        }
        if (calendarTest.log.hasErrors()) {
            System.exit(5);
        }
    }
}

