/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.types;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BytesTest
extends Test {
    private static final String help = "This test tests whether setByte works. (PTS 1116672)";
    private static final OptionDesc[] optdesc = new OptionDesc[0];
    private static final boolean debug = true;

    public BytesTest(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public BytesTest(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        try {
            String string = this.getUnicodeIdentifier("BytesTest");
            this.dropTable(string);
            this.stmt.execute("CREATE TABLE " + string + " (A CHAR(1) BYTE)");
            PreparedStatement preparedStatement = this.prepare("INSERT INTO " + string + "  (A) VALUES (?)");
            preparedStatement.setByte(1, (byte)1);
            preparedStatement.executeUpdate();
            preparedStatement.close();
            PreparedStatement preparedStatement2 = this.prepare("SELECT A FROM " + string);
            ResultSet resultSet = preparedStatement2.executeQuery();
            resultSet.next();
            byte by = resultSet.getByte(1);
            this.log.addDifference("BytesTest", "set/getByte", "1", Byte.toString(by));
            this.dropTable("BytesTest");
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw sQLException;
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        BytesTest bytesTest = new BytesTest(stringArray);
        try {
            bytesTest.runInner();
        }
        finally {
            bytesTest.connection.close();
        }
        if (bytesTest.log.hasErrors()) {
            System.exit(5);
        }
    }
}

