/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.statement;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class AddBatch
extends Test {
    private static final String help = "help for AddBatch";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public AddBatch(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public AddBatch(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = "AddBatch";
        String string2 = this.getUnicodeIdentifier(string);
        this.dropTable(string2);
        this.stmt.execute("CREATE TABLE " + string2 + " (a int)");
        Statement statement = this.connection.createStatement();
        for (int i = 0; i < 100; ++i) {
            statement.addBatch("insert into " + string2 + " values (" + i + ")");
        }
        int[] nArray = statement.executeBatch();
        this.log.addInfo(string, "no of result counts: " + nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            this.log.addInfo(string, "resultCount: " + nArray[i]);
        }
        ResultSet resultSet = this.select("select a from " + string2 + " order by a");
        for (int i = 0; i < 100; ++i) {
            if (!resultSet.next()) {
                this.log.addDifference(string, "next ()", Boolean.TRUE, Boolean.FALSE);
                break;
            }
            int n = resultSet.getInt(1);
            this.log.addDifference(string, "fetch", new Integer(i), new Integer(n));
        }
        string = "empty batch";
        nArray = statement.executeBatch();
        this.log.addDifference(string, "no of resultCounts", new Integer(0), new Integer(nArray.length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        AddBatch addBatch = new AddBatch(stringArray);
        try {
            addBatch.runInner();
        }
        finally {
            addBatch.connection.close();
        }
        if (addBatch.log.hasErrors()) {
            System.exit(5);
        }
    }
}

