/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.resultset;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

public class UpdatableStmtInsertRow
extends Test {
    private static final String help = "help for UpdatableStmtInsertRow";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public UpdatableStmtInsertRow(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public UpdatableStmtInsertRow(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        int n;
        int n2;
        String string = "UpdatableStmtInsertRow";
        String string2 = this.getUnicodeIdentifier(string);
        this.dropTable(string2);
        this.stmt.execute("CREATE TABLE " + string2 + " (homer varchar(10), " + "bart integer, " + "liza timestamp, " + "marge varchar (10) byte, " + "apu long byte)");
        PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT * FROM " + string2, 1003, 1008);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.moveToInsertRow();
        resultSet.insertRow();
        resultSet = this.stmt.executeQuery("SELECT * FROM " + string2 + "");
        int n3 = 1;
        while (resultSet.next()) {
            for (n2 = 1; n2 <= resultSet.getMetaData().getColumnCount(); ++n2) {
                this.log.addDifference(string, "Check updated for null values", null, resultSet.getObject(n2));
            }
            ++n3;
        }
        String string3 = this.makeRandomString(10);
        n2 = 42;
        Timestamp timestamp = new Timestamp(n2);
        preparedStatement = this.connection.prepareStatement("INSERT INTO " + string2 + " values (?,?,?,?,?)");
        for (n = 0; n < 10; ++n) {
            preparedStatement.setString(1, string3);
            preparedStatement.setInt(2, n2);
            preparedStatement.setTimestamp(3, timestamp);
            preparedStatement.setBytes(4, string3.getBytes());
            preparedStatement.setBytes(5, string3.getBytes());
            preparedStatement.addBatch();
        }
        preparedStatement.executeBatch();
        preparedStatement = this.connection.prepareStatement("SELECT * FROM " + string2, 1003, 1008);
        resultSet = preparedStatement.executeQuery();
        resultSet.moveToInsertRow();
        resultSet.updateInt(2, 43);
        resultSet.insertRow();
        resultSet = this.stmt.executeQuery("SELECT * FROM " + string2 + " where bart = 43");
        resultSet.next();
        for (n = 1; n <= resultSet.getMetaData().getColumnCount(); ++n) {
            if (resultSet.getMetaData().getColumnName(n).equals("BART")) {
                this.log.addDifference(string, "Check updated for null values", new Integer(43), resultSet.getObject(n));
                continue;
            }
            this.log.addDifference(string, "Check updated for null values", null, resultSet.getObject(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        UpdatableStmtInsertRow updatableStmtInsertRow = new UpdatableStmtInsertRow(stringArray);
        try {
            updatableStmtInsertRow.runInner();
        }
        finally {
            updatableStmtInsertRow.connection.close();
        }
        if (updatableStmtInsertRow.log.hasErrors()) {
            System.exit(5);
        }
    }
}

