/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.resultset;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.TestDifference;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class UpdatablePrepStmt
extends Test {
    private static final String help = "help for UpdatablePrepStmt";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public UpdatablePrepStmt(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public UpdatablePrepStmt(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = "UpdatablePrepStmt";
        String string2 = this.getUnicodeIdentifier(string);
        this.dropTable(string2);
        this.stmt.execute("CREATE TABLE " + string2 + " (a int primary key)");
        string = "INSERT";
        PreparedStatement preparedStatement = this.prepare("insert into  " + string2 + " (a) values (?)");
        for (int i = 0; i < 1; ++i) {
            this.log.addInfo(string, "adding row through insert " + i);
            preparedStatement.setInt(1, i);
            preparedStatement.execute();
        }
        this.connection.commit();
        PreparedStatement preparedStatement2 = this.connection.prepareStatement("select * from  " + string2 + " order by a", 1004, 1008);
        ResultSet resultSet = preparedStatement2.executeQuery();
        this.log.addInfo(string, "Cursor opened");
        if (resultSet.first()) {
            this.log.addInfo(string, "to cursor.first ()");
        } else {
            this.log.addFailure(new TestDifference(string, "cursor.first ()", Boolean.TRUE, Boolean.FALSE));
        }
        for (int i = 1; i < 2; ++i) {
            this.log.addInfo(string, "adding row through cursor " + i);
            resultSet.moveToInsertRow();
            resultSet.updateInt(1, i);
            resultSet.insertRow();
        }
        string = "FETCH";
        ResultSet resultSet2 = this.select("select a from  " + string2 + " order by a");
        int n = 0;
        while (resultSet2.next()) {
            int n2 = resultSet2.getInt(1);
            this.log.addDifference(string, "column a", new Integer(n), new Integer(n2));
            ++n;
        }
        this.log.addDifference(string, "row count", new Integer(2), new Integer(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        UpdatablePrepStmt updatablePrepStmt = new UpdatablePrepStmt(stringArray);
        try {
            updatablePrepStmt.runInner();
        }
        finally {
            updatablePrepStmt.connection.close();
        }
        if (updatablePrepStmt.log.hasErrors()) {
            System.exit(5);
        }
    }
}

