/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.resultset;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SimpleNavigation
extends Test {
    private static final String help = "Test result set cursor navigation.";
    private static final boolean debug = true;
    private static final OptionDesc[] optdesc = new OptionDesc[0];
    public static final int RECORDS = 333;
    private String tableName = "";

    public SimpleNavigation(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public SimpleNavigation(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = "TEST_NAVIGATION";
        this.tableName = this.getUnicodeIdentifier(string);
        this.dropTable(this.tableName);
        long l = System.currentTimeMillis();
        this.stmt.execute("CREATE TABLE " + this.tableName + "(A INTEGER, B CHAR(1000))");
        String string2 = "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa";
        for (int i = 1; i <= 333; ++i) {
            this.stmt.execute("INSERT INTO " + this.tableName + " (A, B) VALUES (" + i + ", '" + string2 + "')");
        }
        int[] nArray = new int[]{0, 1, 2, 4, 10, 15, 47, 150, 1200, 333, 166, 111, 332, 334};
        int[] nArray2 = new int[]{0, 1, 2, 3, 4, 5, 10, 20, 90, 547, 333, 166, 111, 332, 334};
        String[] stringArray = new String[]{"testPrevious", "testAbsolute", "testFirst", "testLast"};
        boolean bl = true;
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                for (int k = 0; k < stringArray.length; ++k) {
                    if (this.checkedExecute(stringArray[k], nArray[i], nArray2[j])) continue;
                    return;
                }
                if (!bl) break;
            }
            if (!bl) break;
        }
        this.log.addInfo("execution time: " + (System.currentTimeMillis() - l));
    }

    void testAbsolute(int n, int n2) throws SQLException {
        int n3;
        int[] nArray = new int[]{1, -1, 2, -2, 3, -3, n, -n, n * 2, -n * 2, n2, -n2, n2 + 1, -n2 + 1, n2 - 1, -n2 - 1, 17, 23, 37, 42, 333, -333, 334, -334, 332, -332, 166, -166, 111, -111};
        int[] nArray2 = new int[Math.max(n2, 333) * 2 + nArray.length];
        for (n3 = 1; n3 <= Math.max(n2, 333); ++n3) {
            nArray2[n3 - 1] = n3;
        }
        for (n3 = 1; n3 < Math.max(n2, 333); ++n3) {
            nArray2[Math.max((int)n2, (int)333) + n3 - 1] = -n3;
        }
        for (n3 = 0; n3 < nArray.length; ++n3) {
            nArray2[2 * Math.max((int)n2, (int)333) + n3 - 1] = nArray[n3];
        }
        ResultSet resultSet = this.getQueryResult(n, n2);
        for (int i = 0; i < nArray2.length; ++i) {
            int n4;
            int n5 = nArray2[i];
            if (n5 == 0) continue;
            int n6 = this.checkpos(n5, n2);
            int n7 = this.invertNumber(n5, n2 == 0 ? 333 : Math.min(n2, 333));
            boolean bl = resultSet.absolute(n5);
            if (n6 == 0 && !bl) {
                this.fail("FETCH ABSOLUTE " + n5 + " FETCHSIZE " + n + " MAXROWS " + n2 + " NOT ON RESULT SET.");
                continue;
            }
            if (n6 == -1 && !resultSet.isBeforeFirst()) {
                this.fail("FETCH ABSOLUTE " + n5 + " FETCHSIZE " + n + " MAXROWS " + n2 + " NOT BEFORE RESULT SET.");
                continue;
            }
            if (n6 == 1 && !resultSet.isAfterLast()) {
                this.fail("FETCH ABSOLUTE " + n5 + " FETCHSIZE " + n + " MAXROWS " + n2 + " NOT AFTER RESULT SET.");
                continue;
            }
            if (n6 != 0) continue;
            int n8 = resultSet.getInt(1);
            if (n8 != n7) {
                this.fail("FETCH ABSOLUTE " + n5 + " FETCHSIZE " + n + " MAXROWS " + n2 + "EXPECTED: " + n7 + " RETRIEVED: " + n8);
            }
            if ((n4 = resultSet.getRow()) == n7) continue;
            this.fail("FETCH ABSOLUTE " + n5 + " FETCHSIZE " + n + " MAXROWS " + n2 + "EXPECTED ROW NUM: " + n7 + " RETRIEVED: " + n4);
        }
        resultSet.close();
    }

    void testFirst(int n, int n2) throws SQLException {
        ResultSet resultSet = this.getQueryResult(n, n2);
        if (!resultSet.first()) {
            this.fail("CALL TO FIRST FAILED");
        }
        if (!resultSet.isFirst()) {
            this.fail("RESULT NOT AT FIRST");
        }
        if (resultSet.getInt(1) != 1) {
            this.fail("DATA AT FIRST: EXPECTED 1, GOT " + resultSet.getInt(1));
        }
        if (resultSet.getRow() != 1) {
            this.fail("GETROW IS NOT 1");
        }
        resultSet.close();
    }

    void testLast(int n, int n2) throws SQLException {
        int n3;
        ResultSet resultSet = this.getQueryResult(n, n2);
        if (!resultSet.last()) {
            this.fail("CALL TO LAST FAILED");
        }
        if (!resultSet.isLast()) {
            this.fail("RESULT IS NOT LAST RESULT");
        }
        n3 = (n3 = n2) == 0 ? 333 : Math.min(n2, 333);
        if (resultSet.getInt(1) != n3) {
            this.fail("DATA AT LAST, EXPECTED " + n3 + " GOT " + resultSet.getInt(1));
        }
        if (resultSet.getRow() != n3) {
            this.fail("GETROW AT LAST, EXPECTED " + n3 + " GOT " + resultSet.getRow());
        }
        resultSet.close();
    }

    void testRelative(int n, int n2) {
    }

    void testPrevious(int n, int n2) throws SQLException {
        if (n <= 0) {
            // empty if block
        }
    }

    void fail(String string) {
        SimpleNavigation.trace(string);
        this.log.addFailure(new Failure(string));
    }

    int checkpos(int n, int n2) {
        if (n > 0) {
            if (n2 == 0 ? n > 333 : n > Math.min(333, n2)) {
                return 1;
            }
        } else if (n2 == 0 ? this.invertNumber(n, 333) <= 0 : this.invertNumber(n, Math.min(333, n2)) <= 0) {
            return -1;
        }
        return 0;
    }

    ResultSet getQueryResult(int n, int n2) throws SQLException {
        this.stmt.setFetchSize(n);
        this.stmt.setMaxRows(n2);
        return this.stmt.executeQuery("SELECT A, B FROM " + this.tableName + " ORDER BY A");
    }

    int invertNumber(int n, int n2) {
        if (n >= 0) {
            return n;
        }
        return n2 + n + 1;
    }

    boolean checkedExecute(String string, int n, int n2) {
        try {
            Class[] classArray = new Class[]{Integer.TYPE, Integer.TYPE};
            Method method = this.getClass().getDeclaredMethod(string, classArray);
            Object[] objectArray = new Object[]{new Integer(n), new Integer(n2)};
            method.invoke((Object)this, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            SimpleNavigation.trace("EXCEPTION IN " + string + ":" + invocationTargetException.getTargetException().getMessage());
            invocationTargetException.getTargetException().printStackTrace(System.err);
            this.log.addFailure(new Failure(string + "(" + n + ", " + n2 + ")", "Exception: " + invocationTargetException.getTargetException().getMessage()));
            return false;
        }
        catch (Exception exception) {
            SimpleNavigation.trace("EXCEPTION IN " + string + ":" + exception.getMessage());
            this.log.addFailure(new Failure(string + "(" + n + ", " + n2 + ")", "Exception: " + exception.getMessage()));
            return false;
        }
        return true;
    }

    static void trace(String string) {
        System.err.println(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        SimpleNavigation simpleNavigation = new SimpleNavigation(stringArray);
        try {
            simpleNavigation.runInner();
        }
        finally {
            simpleNavigation.connection.close();
        }
        if (simpleNavigation.log.hasErrors()) {
            System.exit(5);
        }
    }
}

