/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.resultset;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SelectForUpdate
extends Test {
    private static final String help = "help for SelectForUpdate";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public SelectForUpdate(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public SelectForUpdate(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        AutoCloseable autoCloseable;
        String string = "SelectForUpdate";
        String string2 = this.getUnicodeIdentifier(string);
        this.dropTable(string2);
        this.stmt.execute("CREATE TABLE " + string2 + " (ID   INTEGER   NOT NULL, TS   INTEGER   NOT NULL)");
        this.stmt.execute("INSERT INTO " + string2 + " VALUES (1, 1)");
        this.stmt.execute("INSERT INTO " + string2 + " VALUES (2, 2)");
        this.stmt.execute("INSERT INTO " + string2 + " VALUES (3, 3)");
        this.stmt.execute("INSERT INTO " + string2 + " VALUES (4, 4)");
        this.stmt.execute("INSERT INTO " + string2 + " VALUES (5, 5)");
        this.connection.commit();
        ResultSet resultSet = this.stmt.executeQuery("SELECT * FROM " + string2);
        resultSet.setFetchSize(1);
        int n = 1;
        while (resultSet.next()) {
            this.log.addDifference(string, "checking non mass fetch ROW " + n + " COLUMN 1", new Integer(n), resultSet.getObject(1));
            this.log.addDifference(string, "checking non mass fetch ROW " + n + " COLUMN 2", new Integer(n++), resultSet.getObject(2));
        }
        Statement statement = this.connection.createStatement(1005, 1007);
        statement.setCursorName("mycursor");
        ResultSet resultSet2 = statement.executeQuery("SELECT ID, TS FROM " + string2 + " FOR UPDATE OF TS");
        resultSet2.setFetchSize(1);
        while (resultSet2.next()) {
            int n2 = resultSet2.getInt("TS");
            autoCloseable = this.connection.createStatement();
            String string3 = n2 % 2 == 0 ? "UPDATE " + string2 + " SET TS = TS+2 " : "DELETE FROM " + string2;
            string3 = string3 + " WHERE CURRENT OF \"" + resultSet2.getCursorName() + "\"";
            int n3 = autoCloseable.executeUpdate(string3);
            this.log.addDifference(string, "Return of executeUpdate", new Integer(1), new Integer(n3));
        }
        statement.close();
        this.connection.commit();
        autoCloseable = this.stmt.executeQuery("SELECT * FROM " + string2);
        autoCloseable.setFetchSize(1);
        autoCloseable.next();
        this.log.addDifference(string, "checking pdated values", new Integer(2), autoCloseable.getObject(1));
        this.log.addDifference(string, "checking pdated values", new Integer(4), autoCloseable.getObject(2));
        autoCloseable.next();
        this.log.addDifference(string, "checking pdated values", new Integer(4), autoCloseable.getObject(1));
        this.log.addDifference(string, "checking pdated values", new Integer(6), autoCloseable.getObject(2));
        this.log.addDifference(string, "fetch next", Boolean.FALSE, new Boolean(autoCloseable.next()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        SelectForUpdate selectForUpdate = new SelectForUpdate(stringArray);
        try {
            selectForUpdate.runInner();
        }
        finally {
            selectForUpdate.connection.close();
        }
        if (selectForUpdate.log.hasErrors()) {
            System.exit(5);
        }
    }
}

