/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.resultset;

import com.sap.dbtech.jdbc.PeekAndPoke;
import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class ParseCache
extends Test {
    private static final String help = "help for ParseCache";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public ParseCache(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public ParseCache(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = "ParseCache";
        this.dropTable("ParseCache");
        this.stmt.execute("CREATE TABLE ParseCache (a int)");
        PreparedStatement preparedStatement = this.prepare("Insert into ParseCache values (?)");
        String string2 = this.getPidAsString(preparedStatement);
        for (int i = 0; i < 10; ++i) {
            preparedStatement = this.prepare("Insert into ParseCache values (?)");
            String string3 = this.getPidAsString(preparedStatement);
            this.log.addDifference(string, "insert pid", string2, string3);
        }
    }

    protected String pid2string(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append(byArray[0]);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(", ");
            stringBuffer.append(byArray[i]);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    protected String getPidAsString(PreparedStatement preparedStatement) {
        byte[] byArray = PeekAndPoke.getParseIdForMonitor((PreparedStatement)preparedStatement);
        String string = this.pid2string(byArray);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        stringArray = Test.addOptions(stringArray, new String[]{"-P:cache=all?"});
        ParseCache parseCache = new ParseCache(stringArray);
        try {
            parseCache.runInner();
        }
        finally {
            parseCache.connection.close();
        }
        if (parseCache.log.hasErrors()) {
            System.exit(5);
        }
    }
}

