/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.prepared;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import java.io.Reader;
import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class LongCharStream
extends Test {
    private static final String help = "Test for weird behaviour with LONGS and CharacterStream";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public LongCharStream(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public LongCharStream(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        PreparedStatement preparedStatement = null;
        PreparedStatement preparedStatement2 = null;
        PreparedStatement preparedStatement3 = null;
        this.connection.setAutoCommit(true);
        String string = this.getUnicodeIdentifier("LONGCHARSTREAM");
        this.dropTable(string);
        this.connection.createStatement().execute("CREATE TABLE " + string + "(NAME VARCHAR(1)  DEFAULT '' NOT NULL, XMLVALUE LONG )");
        this.connection.createStatement().execute("ALTER TABLE " + string + " ADD PRIMARY KEY (NAME)");
        preparedStatement = this.prepare("DELETE FROM " + string + " WHERE NAME=?");
        preparedStatement.setString(1, "x");
        try {
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        preparedStatement2 = this.prepare("INSERT INTO " + string + " VALUES (?, ?)");
        preparedStatement2.setString(1, "x");
        char[] cArray = this.getRandomCharArray(4259);
        String string2 = new String(cArray);
        preparedStatement2.setCharacterStream(2, (Reader)new StringReader(string2), 4259);
        preparedStatement2.executeUpdate();
        preparedStatement3 = this.prepare("SELECT XMLVALUE FROM " + string + " WHERE NAME = ?");
        preparedStatement3.setString(1, "x");
        ResultSet resultSet = preparedStatement3.executeQuery();
        if (!resultSet.next()) {
            this.log.addFailure(new Failure("Did not found the LONG"));
        }
        for (int i = 1; i < 5; ++i) {
            this.dropTable(string);
            this.dropTable(string);
            this.connection.createStatement().executeUpdate("CREATE TABLE " + string + "(NAME VARCHAR(1)  DEFAULT '' NOT NULL, XMLVALUE LONG )");
            this.connection.createStatement().executeUpdate("ALTER TABLE " + string + " ADD PRIMARY KEY (NAME)");
            ResultSet resultSet2 = this.connection.getMetaData().getColumns(null, null, "LONGCHARSTREAM", null);
            resultSet2.next();
            resultSet2.getString("COLUMN_NAME");
            resultSet2.getString("DATA_TYPE");
            resultSet2.next();
            resultSet2.close();
            preparedStatement.clearParameters();
            preparedStatement.clearBatch();
            preparedStatement.clearWarnings();
            preparedStatement.setString(1, "x");
            try {
                preparedStatement.executeUpdate();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            resultSet2 = this.connection.getMetaData().getColumns(null, null, "LONGCHARSTREAM", null);
            resultSet2.next();
            resultSet2.getString("COLUMN_NAME");
            resultSet2.getString("DATA_TYPE");
            resultSet2.next();
            resultSet2.close();
            preparedStatement2.clearParameters();
            preparedStatement2.clearBatch();
            preparedStatement2.clearWarnings();
            preparedStatement2.setString(1, "x");
            cArray = this.getRandomCharArray(10);
            string2 = new String(cArray);
            preparedStatement2.setCharacterStream(2, (Reader)new StringReader(string2), 10);
            preparedStatement2.executeUpdate();
            preparedStatement3.clearBatch();
            preparedStatement3.clearParameters();
            preparedStatement3.clearWarnings();
            preparedStatement3.setString(1, "x");
            resultSet = preparedStatement3.executeQuery();
            if (!resultSet.next()) {
                this.log.addFailure(new Failure("Did not found the LONG"));
                continue;
            }
            String string3 = resultSet.getString(1);
            if (string3.equals(string2)) continue;
            this.log.addFailure(new Failure("LONG CONTENT IS DIFFERENT"));
        }
    }

    void createCruft() throws SQLException {
        for (int i = 0; i < 10; ++i) {
            PreparedStatement preparedStatement = this.prepare("SELECT 1 FROM DUAL");
            preparedStatement.executeQuery();
        }
    }

    char[] getRandomCharArray(int n) {
        String string = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00df";
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = string.charAt(1);
        }
        return cArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        LongCharStream longCharStream = new LongCharStream(stringArray);
        try {
            longCharStream.runInner();
        }
        finally {
            longCharStream.connection.close();
        }
        if (longCharStream.log.hasErrors()) {
            System.exit(5);
        }
    }
}

