/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.prepared;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class LikeTest001
extends Test {
    private static final String help = "help for LikeTest001";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public LikeTest001(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public LikeTest001(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        if (!this.checkVersion("7.4.3")) {
            return;
        }
        String string = "LikeTest001";
        String string2 = this.getUnicodeIdentifier(string);
        this.dropTable(string2);
        this.stmt.execute("CREATE TABLE " + string2 + " (" + " CID fixed(19) primary key, " + " CPATH varchar(256) )   ");
        this.stmt.execute("CREATE UNIQUE INDEX LikeTest001_I0 ON " + string2 + " (\"CPATH\" ASC)");
        this.connection.setAutoCommit(false);
        this.stmt.executeUpdate("INSERT INTO " + string2 + " (CID, CPATH) values (1,'test/xxx(yyy)/hallo/SapDB')");
        this.stmt.executeUpdate("INSERT INTO " + string2 + " (CID, CPATH) values (2,'test/xxx(yyy)/hallo/forever')");
        this.stmt.executeUpdate("INSERT INTO " + string2 + " (CID, CPATH) values (3,'test')");
        this.stmt.executeUpdate("INSERT INTO " + string2 + " (CID, CPATH) values (4,'test/xxx(x/test')");
        this.stmt.executeUpdate("INSERT INTO " + string2 + " (CID, CPATH) values (5,'test/xxx(yyy)')");
        this.stmt.executeUpdate("INSERT INTO " + string2 + " (CID, CPATH) values (6,'test/xxx(yyy)/hallo')");
        String string3 = "SELECT \"CPATH\" FROM " + string2 + "     WHERE \"CPATH\" LIKE ? ESCAPE '#' ORDER BY CPATH";
        PreparedStatement preparedStatement = this.connection.prepareStatement(string3);
        preparedStatement.setString(1, "test/xxx(yyy)/hallo/%");
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        this.log.addDifference(string, "Check Resultset Row 1", "test/xxx(yyy)/hallo/SapDB", resultSet.getString(1));
        resultSet.next();
        this.log.addDifference(string, "Check Resultset Row 1", "test/xxx(yyy)/hallo/forever", resultSet.getString(1));
        while (resultSet.next()) {
            this.log.addFailure(new Failure(string, "too many rows in resultset"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        LikeTest001 likeTest001 = new LikeTest001(stringArray);
        try {
            likeTest001.runInner();
        }
        finally {
            likeTest001.connection.close();
        }
        if (likeTest001.log.hasErrors()) {
            System.exit(5);
        }
    }
}

