/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.prepared;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class EmptyStreamException
extends Test {
    private static final String help = "help for LongAbsturz";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public EmptyStreamException(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public EmptyStreamException(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = "EmptyStreamException";
        String string2 = this.getUnicodeIdentifier(string);
        this.dropTable(string2);
        this.stmt.execute("CREATE TABLE " + string2 + " (a long  ,b long byte )");
        PreparedStatement preparedStatement = this.connection.prepareStatement("Insert into " + string2 + " values (?,?)");
        String string3 = "Hallo Holger";
        preparedStatement.setAsciiStream(1, (InputStream)new StringBufferInputStream(string3), string3.length());
        preparedStatement.setBinaryStream(2, (InputStream)new ByteArrayInputStream(new byte[]{1, 2, 3, 4}), 4);
        preparedStatement.addBatch();
        preparedStatement.addBatch();
        try {
            preparedStatement.executeBatch();
            this.log.addFailure(new Failure(string, "expected stream exception not occured"));
        }
        catch (SQLException sQLException) {
            if (sQLException.getMessage().equals("Stream is empty or already closed.")) {
                this.log.addInfo("expected exception catched.");
            }
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        EmptyStreamException emptyStreamException = new EmptyStreamException(stringArray);
        try {
            emptyStreamException.runInner();
        }
        finally {
            emptyStreamException.connection.close();
        }
        if (emptyStreamException.log.hasErrors()) {
            System.exit(5);
        }
    }
}

