/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.prepared;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DBProcWithDate
extends Test {
    private static final String help = "help for DBProcWithDate";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public DBProcWithDate(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public DBProcWithDate(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = "DBProcWithDate";
        if (!this.isVersion("7.3.0") && !this.checkVersion("7.4.3")) {
            return;
        }
        String string2 = this.getUnicodeIdentifier(string);
        boolean bl = this.connection.getAutoCommit();
        this.connection.setAutoCommit(true);
        this.dropTable(string2);
        this.stmt.executeUpdate("create table " + string2 + " (a date, b time, c timestamp)");
        this.stmt.executeUpdate("insert into " + string2 + " values (DATE, TIME, TIMESTAMP)");
        try {
            this.stmt.executeUpdate("DROP DBPROC " + string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stmt.executeUpdate("CREATE DBPROC " + string2 + " RETURNS CURSOR AS " + "DECLARE :$CURSOR CURSOR FOR SELECT * FROM " + this.getUsername() + "." + string2 + ";");
        CallableStatement callableStatement = this.connection.prepareCall("CALL " + string2);
        ResultSet resultSet = callableStatement.executeQuery();
        this.log.addDifference(string, "Check DBProc ResultSet Fetch", Boolean.TRUE, new Boolean(resultSet.next()));
        ResultSet resultSet2 = this.stmt.executeQuery("Select * from " + string2);
        resultSet2.next();
        this.log.addDifference(string, "Check DBProc ResultSet getDate", resultSet2.getString(1), resultSet.getString(1));
        this.log.addDifference(string, "Check DBProc ResultSet getTime", resultSet2.getString(2), resultSet.getString(2));
        this.log.addDifference(string, "Check DBProc ResultSet getTimestamp", resultSet2.getString(3), resultSet.getString(3));
        this.connection.setAutoCommit(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        DBProcWithDate dBProcWithDate = new DBProcWithDate(stringArray);
        try {
            dBProcWithDate.runInner();
        }
        finally {
            dBProcWithDate.connection.close();
        }
        if (dBProcWithDate.log.hasErrors()) {
            System.exit(5);
        }
    }
}

