/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.prepared;

import com.sap.dbtech.util.Tracer;
import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import com.sap.sapdb.testframe.utilities.RandomGenerator;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Properties;

public class CloseCursorTest
extends Test {
    private static final String help = "help for CloseCursorTest";
    private static final OptionDesc[] optdesc = new OptionDesc[0];
    static long mDDLCount = 0L;
    static final String lastUpdate = "2004/08/06 13:10";
    private static boolean mTestEndsWithoutError = true;

    public CloseCursorTest(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public CloseCursorTest(Test test) throws SQLException {
        super(test);
    }

    private static boolean getBooleanParameter(Properties properties, String string, boolean bl) {
        String string2 = properties.getProperty(string);
        if (string2 != null) {
            return Boolean.valueOf(string2.toLowerCase());
        }
        return bl;
    }

    public int getIntParameter(Properties properties, String string, int n) {
        String string2 = properties.getProperty(string);
        if (string2 != null) {
            return Integer.parseInt(string2);
        }
        return n;
    }

    private void testPrepare(String string) throws SQLException {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.connect();
            connection.setAutoCommit(true);
            statement = connection.createStatement();
            statement.executeUpdate("DIAGNOSE SHARE PARSE DROP");
            try {
                statement.executeUpdate("DROP TABLE TABX");
                statement.executeUpdate("DROP TABLE TAB1");
                statement.executeUpdate("DROP TABLE TAB2");
            }
            catch (Exception exception) {
                // empty catch block
            }
            statement.executeUpdate("CREATE TABLE TAB1 (T INTEGER, K INTEGER, DATA VARCHAR(50), PRIMARY KEY (T,K))");
            statement.executeUpdate("CREATE TABLE TAB2 (T INTEGER, K INTEGER, DATA VARCHAR(50), PRIMARY KEY (T,K))");
            connection.close();
        }
        catch (Exception exception) {
            this.log.addFailure(new Failure(exception.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRun() throws SQLException {
        String string = "CloseCursorTest";
        String string2 = this.getUnicodeIdentifier(string);
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream("C:\\SAPDevelop\\V76\\develop\\sys\\src\\jtest\\tests\\parameters\\SharedSQL_Test.par"));
        }
        catch (Exception exception) {
            this.log.addFailure(new Failure(exception.toString()));
        }
        String string3 = null;
        try {
            System.out.println("; last update: 2004/08/06 13:10");
            string3 = "internal";
            if (!string3.equalsIgnoreCase("oracle")) {
                string3 = "internal";
            }
            this.log.addInfo("SQLMode is " + string3);
            this.log.addInfo("##### Stress testing ");
            int n = this.getIntParameter(properties, "TestCount", 1);
            for (int i = 1; i <= n; ++i) {
                boolean bl = CloseCursorTest.getBooleanParameter(properties, "SharedSQL_" + i, true);
                int n2 = this.getIntParameter(properties, "ThreadCnt_" + i, 21);
                boolean bl2 = CloseCursorTest.getBooleanParameter(properties, "DDLThread_" + i, true);
                boolean bl3 = CloseCursorTest.getBooleanParameter(properties, "AutoCommit_" + i, false);
                int n3 = this.getIntParameter(properties, "wDMLCom_1", 20);
                int n4 = this.getIntParameter(properties, "wDMLRoll_" + i, 2);
                int n5 = this.getIntParameter(properties, "TimePerThread_" + i, 1);
                int n6 = this.getIntParameter(properties, "RndInteger_" + i, 1000);
                int n7 = this.getIntParameter(properties, "RndString_" + i, 3);
                int n8 = this.getIntParameter(properties, "AddTime_" + i, 10);
                System.out.println("Run now " + i + " of " + n);
                this.log.addInfo("### RUN " + i + "// SharedSQL: " + bl + "/ Threads: " + n2 + "/ DDLThread: " + bl2 + "/ AutoCommit: " + bl3 + "/ wDMLCom: " + n3 + "/ wDMLRoll: " + n4 + "/ TimePerThread: " + n5 + "/ RndInteger: " + n6 + "/ RndString: " + n7 + "/ AddTime: " + n8);
                this.testPrepare(string3);
                this.lockingFunctionality(string3, bl, n2, bl2, bl3, n3, n4, n5, n6, n7, n8);
                this.extractStatistics("Select * from COMMANDCACHESTATISTICS");
            }
        }
        catch (Exception exception) {
            mTestEndsWithoutError = false;
            if (exception.getLocalizedMessage().indexOf("least one actor had an") != -1) {
                this.log.addInfo("run exception" + exception.getClass() + "\n" + exception.getLocalizedMessage());
            } else {
                this.log.addInfo("run exception" + exception.getClass() + "\n" + exception.getLocalizedMessage());
            }
            exception.printStackTrace();
        }
        finally {
            this.extractStatistics("Select * from COMMANDCACHESTATISTICS");
        }
    }

    public void basicFunctionality(String string, boolean bl) throws Exception {
        Connection connection = null;
        Connection connection2 = null;
        Connection connection3 = null;
        Statement statement = null;
        PreparedStatement preparedStatement = null;
        PreparedStatement preparedStatement2 = null;
        PreparedStatement preparedStatement3 = null;
        Object var10_10 = null;
        Object var11_11 = null;
        try {
            connection = this.connect();
            statement = connection.createStatement();
            connection.commit();
            connection.close();
            connection2 = this.connect();
            connection3 = this.connect();
            SQLBasicAlter sQLBasicAlter = new SQLBasicAlter(string, this.connect());
            SQLBasicSelect sQLBasicSelect = new SQLBasicSelect(string, this.connect());
            Thread.sleep(30000L);
            if (mTestEndsWithoutError) {
                connection2.setAutoCommit(true);
                connection3.setAutoCommit(true);
                preparedStatement = connection2.prepareStatement("INSERT INTO TAB1 VALUES (0, 001, 'Herbie Hancock (p)')");
                preparedStatement.executeUpdate();
                preparedStatement2 = connection3.prepareStatement("INSERT INTO TAB1 VALUES (0, 002, 'Miles Davis (tp)')");
                preparedStatement2.executeUpdate();
                preparedStatement = connection2.prepareStatement("INSERT INTO TAB1 VALUES (0, 003, 'John Coltrane (ts)')");
                preparedStatement.executeUpdate();
                preparedStatement = connection2.prepareStatement("SELECT * FROM TAB1 WHERE K = 001");
                preparedStatement.executeQuery();
                preparedStatement2 = connection3.prepareStatement("SELECT * FROM TAB1 WHERE K = 001");
                preparedStatement2.executeQuery();
                preparedStatement = connection2.prepareStatement("SELECT * FROM TAB1 WHERE K = 002");
                preparedStatement.executeQuery();
                preparedStatement3 = connection2.prepareStatement("ALTER TABLE TAB1 ADD DATAX CHAR(10)");
                preparedStatement3.executeUpdate();
                preparedStatement2 = connection3.prepareStatement("SELECT * FROM TAB1 WHERE K = 002");
                preparedStatement2.executeQuery();
                preparedStatement = connection2.prepareStatement("SELECT * FROM TAB1 WHERE K = 002");
                preparedStatement2 = connection3.prepareStatement("SELECT * FROM TAB1 WHERE K = 002");
                preparedStatement3 = connection2.prepareStatement("ALTER TABLE TAB1 DROP COLUMN DATAX");
                preparedStatement3.executeUpdate();
                preparedStatement.executeQuery();
                preparedStatement2.executeQuery();
                connection2.close();
                connection2 = null;
                connection3.close();
                connection3 = null;
            }
        }
        catch (Exception exception) {
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringWriter));
            this.log.addInfo("Trace: \n" + stringWriter.toString());
            throw new Exception("Error testing basic functionality: " + exception.getClass() + exception.getMessage());
        }
    }

    private void lockingFunctionality(String string, boolean bl, int n, boolean bl2, boolean bl3, int n2, int n3, int n4, int n5, int n6, int n7) throws Exception {
        Connection connection = null;
        Statement statement = null;
        try {
            int n8;
            int n9;
            connection = this.connect();
            connection.setAutoCommit(true);
            statement = connection.createStatement();
            connection.close();
            long l = 60000L * (long)n4;
            SQLActor[] sQLActorArray = new SQLActor[n + 1];
            this.log.addInfo("Start SQLActor" + Integer.toString(1));
            sQLActorArray[1] = new SQLActor(string, this, 1, false, bl3, n2, n3, n5, n6);
            for (n9 = 2; n9 <= n - 1; ++n9) {
                this.log.addInfo("Start SQLActor" + Integer.toString(n9));
                sQLActorArray[n9] = new SQLActor(string, this, n9, false, bl3, n2, n3, n5, n6);
                Thread.sleep(l);
            }
            sQLActorArray[n] = bl2 ? new SQLActor(string, this, n, true, bl3, 1, 0, n5, n6) : new SQLActor(string, this, n, false, bl3, n2, n3, n5, n6);
            Thread.sleep(l);
            l = 60000L * (long)n7;
            n9 = 0;
            boolean bl4 = false;
            long l2 = System.currentTimeMillis() + l;
            do {
                Thread.sleep(100L);
                if (l2 < System.currentTimeMillis()) {
                    bl4 = true;
                }
                for (n8 = 1; n8 <= n; ++n8) {
                    if (!sQLActorArray[n8].hasAnError) continue;
                    n9 = 1;
                }
            } while (n9 == 0 && !bl4);
            this.log.addInfo("Stop all threads");
            for (n8 = 1; n8 <= n; ++n8) {
                sQLActorArray[n8].pleaseStop();
            }
            int n10 = 0;
            do {
                ++n10;
                n8 = 0;
                for (int i = 1; i <= n; ++i) {
                    n8 |= sQLActorArray[i].isAlive();
                    Thread.sleep(200L);
                }
            } while (n8 != 0 && n10 < 100);
            if (n8 != 0) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("The following threads are not stopped:\n");
                for (int i = 1; i <= n; ++i) {
                    if (!sQLActorArray[i].isAlive()) continue;
                    stringBuffer.append(" " + sQLActorArray[i].name + " -> last sql stmt: '" + sQLActorArray[i].sqlstmt + "'; stmtCounter: " + sQLActorArray[i].StmtCount + "\n");
                }
                this.log.addInfo("Not all threads stopped" + stringBuffer.toString());
                this.log.addInfo("Not all threads stoppedshow tasks ->\n");
                this.log.addInfo("Not all threads stoppedshow regions ->\n");
                this.log.addInfo("Not all threads stoppedshow all ->\n");
                this.extractStatistics("Select * from LOCKSTATISTICS");
                this.extractStatistics("Select * from domain.sysmon_region");
                throw new Exception("Not all threads stopped");
            }
            this.log.addInfo("All threads stopped...");
            if (n9 != 0) {
                throw new Exception("At least one actor had an error.");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Exception("Error testing locking functionality: " + exception.getClass() + " " + exception.getMessage());
        }
    }

    private void extractStatistics(String string) {
        this.extractStatistics(null, string);
    }

    private void extractStatistics(Connection connection, String string) {
        ResultSet resultSet = null;
        boolean bl = false;
        String string2 = "";
        try {
            Connection connection2 = null;
            connection2 = connection != null ? connection : this.connect();
            Statement statement = connection2.createStatement();
            string2 = string;
            resultSet = statement.executeQuery(string2);
            StringBuffer stringBuffer = new StringBuffer();
            if (resultSet.first()) {
                int n;
                for (n = 1; n <= resultSet.getMetaData().getColumnCount(); ++n) {
                    if (resultSet.getMetaData().getColumnType(n) == -2) {
                        stringBuffer.append(this.paddTo(resultSet.getMetaData().getColumnName(n), 66));
                    } else {
                        stringBuffer.append(this.paddTo(resultSet.getMetaData().getColumnName(n), 15));
                    }
                    stringBuffer.append(" ");
                }
                stringBuffer.append("\n");
                do {
                    for (n = 1; n <= resultSet.getMetaData().getColumnCount(); ++n) {
                        if (resultSet.getMetaData().getColumnType(n) == -2) {
                            stringBuffer.append(this.paddTo(Tracer.Hex2String((byte[])resultSet.getBytes(n)), 66));
                        } else if (resultSet.getObject(n) != null && resultSet.getObject(n).toString() != null) {
                            stringBuffer.append(this.paddTo(resultSet.getObject(n).toString(), 15));
                        } else {
                            stringBuffer.append(this.paddTo("NULL", 15));
                        }
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append("\n");
                } while (resultSet.next());
                connection2.commit();
                statement.close();
                if (connection == null) {
                    connection2.close();
                }
                this.log.addInfo("Value(s) of " + string2 + "\n" + stringBuffer.toString());
            } else {
                this.log.addInfo("no result for '" + string2 + "'");
            }
        }
        catch (SQLException sQLException) {
            System.out.println("ERROR: Can't excute: " + string2 + "; get: " + sQLException.getClass() + "  " + sQLException.getErrorCode() + "  " + sQLException.getMessage());
            this.log.addInfo("Can't excute: " + string2 + "; get: " + sQLException.getClass() + "  " + sQLException.getErrorCode() + "  " + sQLException.getMessage());
        }
    }

    private String paddTo(String string, int n) {
        int n2 = string.length();
        if (n2 < n) {
            char[] cArray = new char[n - n2];
            Arrays.fill(cArray, ' ');
            return string + new String(cArray);
        }
        if (n2 == n) {
            return string;
        }
        return string.substring(0, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        CloseCursorTest closeCursorTest = new CloseCursorTest(stringArray);
        try {
            closeCursorTest.runInner();
        }
        finally {
            closeCursorTest.connection.close();
        }
        if (closeCursorTest.log.hasErrors()) {
            System.exit(5);
        }
    }

    class SQLActor
    extends Thread {
        boolean keepRuning;
        boolean hasAnError = false;
        String name;
        String SQLMode;
        int threadNr;
        long StmtCount;
        boolean doDDL;
        boolean autoCom;
        int wCom;
        int wRoll;
        int CounterToRollOrCom;
        boolean drop;
        int randomInt;
        int randomStr;
        String sqlstmt = null;
        Test test;

        SQLActor(String string, Test test, int n, boolean bl, boolean bl2, int n2, int n3, int n4, int n5) {
            this.SQLMode = string;
            this.keepRuning = true;
            this.threadNr = n;
            this.name = "SQLActor" + n;
            if (n < 10) {
                this.name = this.name + " ";
            }
            this.StmtCount = 0L;
            this.doDDL = bl;
            this.autoCom = bl2;
            this.wCom = n2;
            this.wRoll = n3;
            this.CounterToRollOrCom = RandomGenerator.randomInteger((int)1, (int)n2);
            this.randomInt = n4;
            this.randomStr = n5;
            this.test = test;
            this.drop = false;
            this.start();
        }

        public void run() {
            Connection connection = null;
            try {
                connection = this.test.connect();
                if (!this.doDDL) {
                    connection.setAutoCommit(this.autoCom);
                } else {
                    connection.setAutoCommit(true);
                }
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery("select t.process, t.session from connectparameters c , transactions t where t.session = c.session");
                if (resultSet.first()) {
                    this.name = this.name + " (Task: " + resultSet.getString("PROCESS") + ", Session: " + resultSet.getString("SESSION") + ")";
                } else {
                    System.out.println("Thread " + this.name + " Task and session id not readable.");
                }
                resultSet.close();
                statement.close();
                connection.commit();
                while (this.keepRuning) {
                    if (!this.doDDL) {
                        this.executeDML(connection);
                        Thread.sleep(50L);
                        continue;
                    }
                    this.executeDDL(connection);
                    Thread.sleep(30000L);
                }
                connection.commit();
                connection.close();
                connection = null;
                if (!this.doDDL) {
                    System.out.println("Thread " + this.name + " executed " + this.StmtCount + " SELECT/INSERT/UPDATE/DELETE Statements");
                } else {
                    System.out.println("Thread " + this.name + " executed " + this.StmtCount + " ALTER TABLE Statements");
                }
            }
            catch (Exception exception) {
                this.hasAnError = true;
            }
        }

        public void pleaseStop() {
            this.keepRuning = false;
        }

        private void CommitOrRollback(Connection connection) throws Exception {
            try {
                --this.CounterToRollOrCom;
                if (this.CounterToRollOrCom <= 0) {
                    int n = RandomGenerator.randomInteger((int)1, (int)100);
                    if (n <= this.wRoll) {
                        connection.rollback();
                    } else {
                        connection.commit();
                    }
                    this.CounterToRollOrCom = RandomGenerator.randomInteger((int)1, (int)this.wCom);
                }
            }
            catch (Exception exception) {
                throw new Exception("Error within Commit or Rollback: " + exception.getClass() + " " + exception.getMessage());
            }
        }

        private void executeDML(Connection connection) throws Exception {
            block24: {
                PreparedStatement preparedStatement = null;
                this.sqlstmt = "???";
                try {
                    int n;
                    boolean bl = false;
                    int n2 = RandomGenerator.randomInteger((int)1, (int)13);
                    int n3 = 1;
                    int n4 = 1;
                    long l = 0L;
                    switch (n2) {
                        case 1: {
                            int n5 = RandomGenerator.randomInteger((int)1, (int)this.randomInt);
                            this.sqlstmt = "SELECT * FROM TAB1 WHERE T = ? AND K = " + n5;
                            n3 = RandomGenerator.randomInteger((int)1, (int)10);
                            break;
                        }
                        case 2: {
                            int n5 = RandomGenerator.randomInteger((int)1, (int)this.randomInt);
                            this.sqlstmt = "SELECT * FROM TAB2 WHERE T = ? AND K = " + n5;
                            n3 = RandomGenerator.randomInteger((int)1, (int)10);
                            break;
                        }
                        case 3: {
                            String string = RandomGenerator.randomString((int)1);
                            string = string + '%';
                            this.sqlstmt = "SELECT * FROM TAB1 WHERE T = ? AND DATA LIKE '" + string + "'";
                            n3 = RandomGenerator.randomInteger((int)1, (int)10);
                            break;
                        }
                        case 4: {
                            String string = RandomGenerator.randomString((int)1);
                            string = string + '%';
                            this.sqlstmt = "SELECT * FROM TAB2 WHERE T = ? AND DATA LIKE '" + string + "'";
                            n3 = RandomGenerator.randomInteger((int)1, (int)10);
                            break;
                        }
                        case 5: {
                            int n5 = RandomGenerator.randomInteger((int)1, (int)this.randomInt);
                            String string = RandomGenerator.randomString((int)this.randomStr);
                            this.sqlstmt = "INSERT INTO TAB1 (T, K, DATA) VALUES (?, " + n5 + ", '" + string + "')";
                            break;
                        }
                        case 6: {
                            int n5 = RandomGenerator.randomInteger((int)1, (int)this.randomInt);
                            String string = RandomGenerator.randomString((int)this.randomStr);
                            this.sqlstmt = "INSERT INTO TAB2 (T, K, DATA) VALUES (?, " + n5 + ", '" + string + "')";
                            break;
                        }
                        case 7: {
                            int n5 = RandomGenerator.randomInteger((int)1, (int)this.randomInt);
                            String string = RandomGenerator.randomString((int)this.randomStr);
                            this.sqlstmt = "UPDATE TAB1 SET DATA = '" + string + "' WHERE T = ? AND K = " + n5;
                            break;
                        }
                        case 8: {
                            int n5 = RandomGenerator.randomInteger((int)1, (int)this.randomInt);
                            String string = RandomGenerator.randomString((int)this.randomStr);
                            this.sqlstmt = "UPDATE TAB2 SET DATA = '" + string + "' WHERE T = ? AND K = " + n5;
                            break;
                        }
                        case 9: {
                            int n5 = RandomGenerator.randomInteger((int)1, (int)this.randomInt);
                            this.sqlstmt = "DELETE FROM TAB1 WHERE T = ? AND K = " + n5;
                            break;
                        }
                        case 10: {
                            int n5 = RandomGenerator.randomInteger((int)1, (int)this.randomInt);
                            this.sqlstmt = "DELETE FROM TAB2 WHERE T = ? AND K = " + n5;
                            break;
                        }
                        case 11: {
                            int n5 = RandomGenerator.randomInteger((int)1, (int)this.randomInt);
                            this.sqlstmt = "SELECT * FROM TAB1 A, TAB2 B WHERE A.T = B.T AND A.K = B.K AND A.T = ? AND A.K < " + n5 + " ORDER BY B.K";
                            n3 = RandomGenerator.randomInteger((int)1, (int)10);
                            break;
                        }
                        case 12: {
                            int n5 = RandomGenerator.randomInteger((int)1, (int)this.randomInt);
                            this.sqlstmt = "SELECT * FROM TAB1 WHERE T = ? AND K = ( SELECT MAX(K) FROM TAB2 WHERE T = ? AND K < " + n5 + " )";
                            n4 = 2;
                            n3 = RandomGenerator.randomInteger((int)1, (int)10);
                            break;
                        }
                        case 13: {
                            this.sqlstmt = this.SQLMode.equalsIgnoreCase("oracle") ? "SELECT K,DATA FROM TAB1 WHERE T = ? MINUS SELECT K,DATA FROM TAB2 WHERE T = ?" : "SELECT K,DATA FROM TAB1 WHERE T = ? EXCEPT SELECT K,DATA FROM TAB2 WHERE T = ?";
                            n4 = 2;
                            n3 = RandomGenerator.randomInteger((int)1, (int)10);
                        }
                    }
                    preparedStatement = connection.prepareStatement(this.sqlstmt);
                    for (n = 1; n <= n4; ++n) {
                        preparedStatement.setInt(n, this.threadNr);
                    }
                    l = mDDLCount;
                    for (n = 1; n <= n3 && l == mDDLCount; ++n) {
                        preparedStatement.execute();
                        ++this.StmtCount;
                    }
                    if (!this.autoCom) {
                        if (l == mDDLCount) {
                            this.CommitOrRollback(connection);
                        } else {
                            connection.commit();
                        }
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    if (((SQLException)exception).getErrorCode() == -1 || ((SQLException)exception).getErrorCode() == 200 || ((SQLException)exception).getErrorCode() == 250 || ((SQLException)exception).getErrorCode() == -3007) break block24;
                    System.out.println("Thread " + this.name + ": Method executeCmd " + " execute failed: " + this.sqlstmt + " " + ((SQLException)exception).getErrorCode() + " " + ((SQLException)exception).getLocalizedMessage());
                    if (((SQLException)exception).getErrorCode() == -807) {
                        this.keepRuning = false;
                    }
                    this.hasAnError = true;
                }
            }
        }

        private void executeDDL(Connection connection) throws Exception {
            PreparedStatement preparedStatement = null;
            this.sqlstmt = "???";
            try {
                if (this.drop) {
                    this.drop = false;
                    this.sqlstmt = "ALTER TABLE TAB1 DROP COLUMN DATAX";
                } else {
                    this.drop = true;
                    this.sqlstmt = "ALTER TABLE TAB1 ADD DATAX CHAR(10) DEFAULT NULL";
                }
                preparedStatement = connection.prepareStatement(this.sqlstmt);
                if (preparedStatement != null) {
                    ++mDDLCount;
                    preparedStatement.executeUpdate();
                    ++this.StmtCount;
                    connection.commit();
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {
                System.out.println("Thread " + this.name + ": Method executeAlter " + " execute failed: " + this.sqlstmt + " " + ((SQLException)exception).getErrorCode());
                System.out.println("Thread " + this.name + "StmtCount = " + this.StmtCount);
                if (((SQLException)exception).getErrorCode() == -807) {
                    this.keepRuning = false;
                    throw new Exception("Time out -807 for thread " + this.name);
                }
                this.keepRuning = false;
                this.hasAnError = true;
            }
        }
    }

    class SQLBasicSelect
    extends Thread {
        Connection mConnectionB = null;
        PreparedStatement mStmtB = null;

        SQLBasicSelect(String string, Connection connection) {
            Properties properties = new Properties();
            try {
                this.mConnectionB = connection;
                this.mConnectionB.setAutoCommit(false);
                this.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void run() {
            try {
                Thread.sleep(2000L);
                this.mStmtB = this.mConnectionB.prepareStatement("INSERT INTO TABX VALUES (1)");
                this.mStmtB.executeUpdate();
                this.mConnectionB.commit();
                Thread.sleep(5000L);
                this.mStmtB = this.mConnectionB.prepareStatement("SELECT * FROM TABX");
                this.mStmtB.executeQuery();
                Thread.sleep(7000L);
                this.mConnectionB.commit();
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
            }
        }
    }

    class SQLBasicAlter
    extends Thread {
        Connection mConnectionA = null;
        PreparedStatement mStmtA = null;

        SQLBasicAlter(String string, Connection connection) {
            Properties properties = new Properties();
            try {
                this.mConnectionA = connection;
                this.mConnectionA.setAutoCommit(false);
                this.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void run() {
            ResultSet resultSet = null;
            try {
                this.mStmtA = this.mConnectionA.prepareStatement("CREATE TABLE TABX (I INT)");
                this.mStmtA.executeUpdate();
                this.mConnectionA.commit();
                Thread.sleep(5000L);
                this.mStmtA = this.mConnectionA.prepareStatement("ALTER TABLE TABX ADD (K INT)");
                this.mStmtA.executeUpdate();
                Thread.sleep(5000L);
                this.mConnectionA.commit();
                this.mStmtA = this.mConnectionA.prepareStatement("SELECT * FROM LOCKSTATISTICS");
                resultSet = this.mStmtA.executeQuery();
                this.mConnectionA.commit();
                if (resultSet.first()) {
                    // empty if block
                }
                this.mConnectionA.commit();
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
            }
        }
    }
}

