/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.prepared;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BindByName
extends Test {
    private static final String help = "help for BindByName";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public BindByName(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public BindByName(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = "BindByName";
        String string2 = this.getUnicodeIdentifier(string);
        this.dropTable(string2);
        this.stmt.execute("CREATE TABLE " + string2 + " (a int, b boolean, c varchar(10))");
        PreparedStatement preparedStatement = this.connection.prepareStatement("insert into " + string2 + " values (?,?,?)");
        preparedStatement.setInt(1, 1);
        preparedStatement.setBoolean(2, true);
        preparedStatement.setString(3, "Hello");
        preparedStatement.execute();
        preparedStatement = this.connection.prepareStatement("select * from " + string2);
        preparedStatement.execute();
        ResultSet resultSet = preparedStatement.getResultSet();
        while (resultSet.next()) {
            this.log.addDifference(string, "check result value", new Integer(1), new Integer(resultSet.getInt("a")));
            this.log.addDifference(string, "check result value", Boolean.TRUE, new Boolean(resultSet.getBoolean("b")));
            this.log.addDifference(string, "check result value", "Hello", resultSet.getString("c"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        BindByName bindByName = new BindByName(stringArray);
        try {
            bindByName.runInner();
        }
        finally {
            bindByName.connection.close();
        }
        if (bindByName.log.hasErrors()) {
            System.exit(5);
        }
    }
}

