/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.prepared;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class BatchOverflow
extends Test {
    private static final String help = "help for BatchOverflow";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public BatchOverflow(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public BatchOverflow(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        String string = "BatchOverflow";
        String string2 = this.getUnicodeIdentifier(string);
        this.dropTable(string2);
        this.stmt.execute("CREATE TABLE " + string2 + " (a char (1))");
        PreparedStatement preparedStatement = this.prepare("insert into " + string2 + " values (?)");
        for (int i = 0; i < 40000; ++i) {
            preparedStatement.setString(1, "x");
            preparedStatement.addBatch();
        }
        preparedStatement.executeBatch();
        Statement statement = this.connection.createStatement(1005, 1007);
        ResultSet resultSet = statement.executeQuery("Select  a from " + string2);
        while (resultSet.next()) {
        }
        resultSet.previous();
        this.log.addDifference(string, "Check number of inserted rows", new Integer(40000), new Integer(resultSet.getRow()));
        resultSet.close();
        this.connection.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        BatchOverflow batchOverflow = new BatchOverflow(stringArray);
        try {
            batchOverflow.runInner();
        }
        finally {
            batchOverflow.connection.close();
        }
        if (batchOverflow.log.hasErrors()) {
            System.exit(5);
        }
    }
}

