/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.prepared;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import java.io.UnsupportedEncodingException;
import java.sql.BatchUpdateException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BatchInsert
extends Test {
    private static final String help = "help for BatchInsert";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public BatchInsert(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public BatchInsert(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        int n;
        String string = "BatchInsert";
        String string2 = this.getUnicodeIdentifier(string);
        this.dropTable(string2);
        this.stmt.execute("CREATE TABLE " + string2 + " (a int ,b varchar(10),CONSTRAINT a <= 1000000)");
        int n2 = 0;
        PreparedStatement preparedStatement = this.prepare("insert into " + string2 + " values (?,?)");
        preparedStatement.setString(2, "\u00d6\u00d6\u00c4\u00c4\u00dc\u00dcIIAA");
        int n3 = 0;
        while (n3 < 100) {
            preparedStatement.setInt(1, n3);
            preparedStatement.addBatch();
            ++n3;
            ++n2;
        }
        int[] nArray = new int[]{};
        nArray = preparedStatement.executeBatch();
        this.log.addDifference(string, "Checking update count array size ", new Integer(100), new Integer(nArray.length));
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 1 || nArray[i] == -2) continue;
            this.log.addFailure(new Failure(string, "Unexpected update count: " + nArray[i]));
        }
        ResultSet resultSet = this.select("select a,b from " + string2 + " order by a");
        for (n = 0; n < 100; ++n) {
            if (!resultSet.next()) {
                this.log.addDifference(string, "next ()", Boolean.TRUE, Boolean.FALSE);
                break;
            }
            int n4 = resultSet.getInt(1);
            this.log.addDifference(string, "fetch", new Integer(n), new Integer(n4));
            try {
                byte[] byArray = resultSet.getBytes(2);
                String string3 = new String(byArray, "8859_1");
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.toString();
            }
        }
        n = 0;
        while (n < 100) {
            if (n == 50) {
                preparedStatement.setInt(1, 2000000);
            } else {
                preparedStatement.setInt(1, n);
            }
            preparedStatement.addBatch();
            ++n;
            ++n2;
        }
        try {
            nArray = preparedStatement.executeBatch();
            this.log.addFailure(new Failure(string, "Expected BatchUpdateException not occured"));
        }
        catch (BatchUpdateException batchUpdateException) {
            int[] nArray2 = batchUpdateException.getUpdateCounts();
            n2 -= 100 - nArray2.length;
            this.log.addDifference(string, "Checking update count array size 1", new Integer(50), new Integer(nArray2.length));
            for (int i = 0; i < nArray2.length; ++i) {
                if (nArray2[i] == 1 || nArray2[i] == -2) continue;
                this.log.addFailure(new Failure(string, "Unexpected update count: " + nArray2[i]));
            }
        }
        preparedStatement.clearBatch();
        preparedStatement.setString(2, "\u00d6\u00d6\u00c4\u00c4\u00dc\u00dcIIAA");
        int n5 = 0;
        while (n5 < 100) {
            preparedStatement.setInt(1, n5);
            preparedStatement.addBatch();
            ++n5;
            ++n2;
        }
        nArray = new int[]{};
        nArray = preparedStatement.executeBatch();
        this.log.addDifference(string, "Checking update count array size 2", new Integer(100), new Integer(nArray.length));
        for (n5 = 0; n5 < nArray.length; ++n5) {
            if (nArray[n5] == 1 || nArray[n5] == -2) continue;
            this.log.addFailure(new Failure(string, "Unexpected update count: " + nArray[n5]));
        }
        resultSet = this.select("select a,b from " + string2 + " order by a");
        for (n5 = 0; n5 < n2; ++n5) {
            if (resultSet.next()) continue;
            this.log.addDifference(string, "next ()" + n5, Boolean.TRUE, Boolean.FALSE);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        BatchInsert batchInsert = new BatchInsert(stringArray);
        try {
            batchInsert.runInner();
        }
        finally {
            batchInsert.connection.close();
        }
        if (batchInsert.log.hasErrors()) {
            System.exit(5);
        }
    }
}

