/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.jdbc.prepared;

import com.sap.dbtechtest.util.options.OptionDesc;
import com.sap.dbtechtest.util.testdriver.Test;
import com.sap.dbtechtest.xlog.Failure;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BatchCallDBProc
extends Test {
    private static final String help = "help for BatchCallDBProc";
    private static final OptionDesc[] optdesc = new OptionDesc[0];

    public BatchCallDBProc(String[] stringArray) throws SQLException {
        super(optdesc, help, stringArray);
    }

    public BatchCallDBProc(Test test) throws SQLException {
        super(test);
    }

    public void testRun() throws SQLException {
        int n;
        String string = "BatchCallDBProc";
        String string2 = this.getUnicodeIdentifier("BatchCallDBProc");
        String string3 = this.getUnicodeIdentifier("Batch_CallDBProc");
        String string4 = this.options.getUser();
        this.dropTable(string2 + "1");
        this.dropTable(string2 + "2");
        try {
            this.stmt.execute("DROP DBPROC " + string3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.stmt.execute("DROP DBPROC FAILURE2");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stmt.execute("CREATE TABLE " + string2 + "1 (a int, c varchar(5))");
        this.stmt.execute("CREATE TABLE " + string2 + "2 (a int, c varchar(5))");
        this.stmt.execute("CREATE DBPROC " + string3 + " (IN KEY INTEGER, IN V  CHAR(5)) AS " + "BEGIN INSERT INTO " + string4 + "." + string2 + "1 VALUES (:KEY, :V); INSERT INTO " + string4 + "." + string2 + "2 VALUES (:KEY, :V); END;");
        this.stmt.execute("CREATE DBPROC Failure2 (IN KEY INTEGER, IN V  CHAR(5), OUT B CHAR(3)) AS BEGIN INSERT INTO " + string4 + "." + string2 + "1 VALUES (:KEY, :V); INSERT INTO " + string4 + "." + string2 + "2 VALUES (:KEY, :V); END;");
        CallableStatement callableStatement = this.connection.prepareCall("CALL " + string3 + "(?,?)");
        for (int i = 0; i < 10; ++i) {
            callableStatement.setInt(1, i);
            callableStatement.setString(2, "12345");
            callableStatement.addBatch();
        }
        int[] nArray = callableStatement.executeBatch();
        this.log.addDifference(string, "Checking update count array size ", new Integer(10), new Integer(nArray.length));
        this.connection.commit();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 1 || nArray[i] == -2) continue;
            this.log.addFailure(new Failure(string, "Unexpected update count: " + nArray[i]));
        }
        ResultSet resultSet = this.select("select a from " + string2 + "1 order by a");
        for (n = 0; n < 10; ++n) {
            if (!resultSet.next()) {
                this.log.addDifference(string, "next ()", Boolean.TRUE, Boolean.FALSE);
                break;
            }
            int n2 = resultSet.getInt(1);
            this.log.addDifference(string, "fetch", new Integer(n), new Integer(n2));
        }
        callableStatement = this.connection.prepareCall("CALL FAILURE2(?,?,?)");
        for (n = 0; n < 10; ++n) {
            callableStatement.setInt(1, n);
            callableStatement.setString(2, "12345");
            callableStatement.addBatch();
        }
        try {
            callableStatement.executeBatch();
            this.log.addFailure(new Failure("Execute Batch with OUT Params - excepted SQLException is not occured"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SQLException {
        BatchCallDBProc batchCallDBProc = new BatchCallDBProc(stringArray);
        try {
            batchCallDBProc.runInner();
        }
        finally {
            batchCallDBProc.connection.close();
        }
        if (batchCallDBProc.log.hasErrors()) {
            System.exit(5);
        }
    }
}

